/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.lib.command.CmdBase;

public class CmdSeekBlock
extends CmdBase {
    private static final int MAX_RESULTS = 100;

    public CmdSeekBlock() {
        super("seek_block", CmdBase.Level.OP);
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/seek_block <blockID>:<meta>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length != 1) {
            String message = "Usage: /seekblock <blockID>:<meta>";
            sender.func_145747_a((IChatComponent)new ChatComponentText(message));
            FMLLog.info((String)message, (Object[])new Object[0]);
            return;
        }
        String[] parts = args[0].split(":");
        if (parts.length != 2) {
            String message = "Invalid format. Use /seekblock <blockID>:<meta>";
            sender.func_145747_a((IChatComponent)new ChatComponentText(message));
            FMLLog.info((String)message, (Object[])new Object[0]);
            return;
        }
        try {
            int targetBlockID = Integer.parseInt(parts[0]);
            int targetMeta = Integer.parseInt(parts[1]);
            String message = "--- Searching for Block ID " + targetBlockID + ":" + targetMeta + " ---";
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
            FMLLog.info((String)message, (Object[])new Object[0]);
            int foundCount = 0;
            Integer[] integerArray = DimensionManager.getIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int dimId = integerArray[i];
                WorldServer world = DimensionManager.getWorld((int)dimId);
                if (world == null) continue;
                ChunkProviderServer chunkProvider = (ChunkProviderServer)world.func_72863_F();
                if (!chunkProvider.field_73245_g.isEmpty() || sender instanceof MinecraftServer) {
                    message = "Dimension " + dimId + ":";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + message));
                    FMLLog.info((String)message, (Object[])new Object[0]);
                }
                for (Chunk chunkObj : chunkProvider.field_73245_g) {
                    if ((foundCount += this.scanChunk(chunkObj, (World)world, sender, targetBlockID, targetMeta, dimId, foundCount)) < 100) continue;
                    message = "Search limit reached (100 results).";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
                    FMLLog.info((String)message, (Object[])new Object[0]);
                    return;
                }
            }
            message = "Search complete! Found " + foundCount + " matches.";
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
            FMLLog.info((String)message, (Object[])new Object[0]);
        }
        catch (NumberFormatException e) {
            String message = "Invalid number format.";
            sender.func_145747_a((IChatComponent)new ChatComponentText(message));
            FMLLog.info((String)message, (Object[])new Object[0]);
        }
    }

    private int scanChunk(Chunk chunk, World world, ICommandSender sender, int blockID, int meta, int dimension, int foundCount) {
        int chunkX = chunk.field_76635_g * 16;
        int chunkZ = chunk.field_76647_h * 16;
        int count = 0;
        for (int x = chunkX; x < chunkX + 16; ++x) {
            for (int z = chunkZ; z < chunkZ + 16; ++z) {
                for (int y = 0; y < world.func_72800_K(); ++y) {
                    Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
                    int foundBlockID = Block.func_149682_b((Block)block);
                    int foundMeta = world.func_72805_g(x, y, z);
                    if (foundBlockID != blockID || foundMeta != meta) continue;
                    String message = "Found at Dim " + dimension + " (" + x + ", " + y + ", " + z + ")";
                    FMLLog.info((String)message, (Object[])new Object[0]);
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + message));
                    if (foundCount + ++count < 100) continue;
                    return count;
                }
            }
        }
        return count;
    }
}

