/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.StringKey;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Box;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends Widget<TextWidget> {
    private final IKey key;
    private Alignment alignment = Alignment.CenterLeft;
    private Integer color = null;
    private Boolean shadow = null;
    private float scale = 1.0f;

    public TextWidget(IKey key) {
        this.key = key;
    }

    public TextWidget(String key) {
        this(new StringKey(key));
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setColor(this.color != null ? this.color.intValue() : widgetTheme.getTextColor());
        renderer.setAlignment(this.alignment, (float)this.getArea().w() + this.scale, this.getArea().h());
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : widgetTheme.getTextShadow());
        renderer.setPos(this.getArea().getPadding().left, this.getArea().getPadding().top);
        renderer.setScale(this.scale);
        renderer.setSimulate(false);
        renderer.draw(this.key.getFormatted());
    }

    private TextRenderer simulate(float maxWidth) {
        Box padding = this.getArea().getPadding();
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setAlignment(Alignment.TopLeft, maxWidth);
        renderer.setPos(padding.left, padding.top);
        renderer.setScale(this.scale);
        renderer.setSimulate(true);
        renderer.draw(this.key.getFormatted());
        return renderer;
    }

    @Override
    public int getDefaultHeight() {
        float maxWidth = this.resizer() != null && this.resizer().isWidthCalculated() ? (float)this.getArea().width + this.scale : (this.getParent().resizer() != null && this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width + this.scale : (float)this.getScreen().getScreenArea().width);
        TextRenderer renderer = this.simulate(maxWidth);
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)(renderer.getLastHeight() + (float)padding.vertical() + 0.5f));
    }

    @Override
    public int getDefaultWidth() {
        float maxWidth = this.getScreen().getScreenArea().width;
        if (this.getParent().resizer() != null && this.getParent().resizer().isWidthCalculated()) {
            maxWidth = this.getParent().getArea().width;
        }
        TextRenderer renderer = this.simulate(maxWidth);
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)(renderer.getLastWidth() + (float)padding.horizontal() + 0.5f));
    }

    public IKey getKey() {
        return this.key;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public float getScale() {
        return this.scale;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public TextWidget alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TextWidget color(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    public TextWidget scale(float scale) {
        this.scale = scale;
        return this;
    }

    public TextWidget shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public TextWidget style(EnumChatFormatting formatting) {
        this.key.style(formatting);
        return this;
    }
}

