/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollData {
    public static final int DEFAULT_THICKNESS = 4;
    private final GuiAxis axis;
    private final boolean axisStart;
    private final int thickness;
    private int scrollSpeed = 30;
    private boolean cancelScrollEdge = true;
    private int scrollSize;
    private int scroll;
    protected boolean dragging;
    protected int clickOffset;
    private int animatingTo = 0;
    private final Animator scrollAnimator = new Animator(30, Interpolation.QUAD_OUT);

    public static ScrollData of(GuiAxis axis) {
        return ScrollData.of(axis, false, 4);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart) {
        return ScrollData.of(axis, axisStart, 4);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart, int thickness) {
        if (axis.isHorizontal()) {
            return new HorizontalScrollData(axisStart, thickness);
        }
        return new VerticalScrollData(axisStart, thickness);
    }

    protected ScrollData(GuiAxis axis, boolean axisStart, int thickness) {
        this.axis = axis;
        this.axisStart = axisStart;
        this.thickness = thickness <= 0 ? 4 : thickness;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    public boolean isOnAxisStart() {
        return this.axisStart;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public int getScroll() {
        return this.scroll;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isVertical() {
        return this.axis.isVertical();
    }

    public boolean isHorizontal() {
        return this.axis.isHorizontal();
    }

    public boolean isCancelScrollEdge() {
        return this.cancelScrollEdge;
    }

    public void setCancelScrollEdge(boolean cancelScrollEdge) {
        this.cancelScrollEdge = cancelScrollEdge;
    }

    protected final int getRawVisibleSize(ScrollArea area) {
        return Math.max(0, this.getRawFullVisibleSize(area) - area.getPadding().getTotal(this.axis));
    }

    protected final int getRawFullVisibleSize(ScrollArea area) {
        return area.getSize(this.axis);
    }

    public final int getFullVisibleSize(ScrollArea area) {
        return this.getFullVisibleSize(area, false);
    }

    public final int getFullVisibleSize(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawVisibleSize(area);
        ScrollData data = this.getOtherScrollData(area);
        if (data != null && (isOtherActive || data.isScrollBarActive(area, true))) {
            s -= data.getThickness();
        }
        return s;
    }

    public final int getVisibleSize(ScrollArea area) {
        return this.getVisibleSize(area, false);
    }

    public final int getVisibleSize(ScrollArea area, int fullVisibleSize) {
        return Math.max(0, fullVisibleSize - area.getPadding().getTotal(this.axis));
    }

    public final int getVisibleSize(ScrollArea area, boolean isOtherActive) {
        return this.getVisibleSize(area, this.getFullVisibleSize(area, isOtherActive));
    }

    public float getProgress(ScrollArea area, int mainAxisPos, int crossAxisPos) {
        float fullSize = this.getFullVisibleSize(area);
        return (float)(mainAxisPos - area.getPoint(this.axis) - this.clickOffset) / (fullSize - (float)this.getScrollBarLength(area));
    }

    @Nullable
    public abstract ScrollData getOtherScrollData(ScrollArea var1);

    public boolean clamp(ScrollArea area) {
        int size = this.getVisibleSize(area);
        int old = this.scroll;
        this.scroll = this.scrollSize <= size ? 0 : MathHelper.func_76125_a((int)this.scroll, (int)0, (int)(this.scrollSize - size));
        return old != this.scroll;
    }

    public boolean scrollBy(ScrollArea area, int x) {
        this.scroll += x;
        return this.clamp(area);
    }

    public boolean scrollTo(ScrollArea area, int x) {
        this.scroll = x;
        return this.clamp(area);
    }

    public void animateTo(ScrollArea area, int x) {
        this.scrollAnimator.setCallback(value -> this.scrollTo(area, (int)value));
        this.scrollAnimator.setValueBounds(this.scroll, x);
        this.scrollAnimator.forward();
        this.animatingTo = x;
    }

    public final boolean isScrollBarActive(ScrollArea area) {
        return this.isScrollBarActive(area, false);
    }

    public final boolean isScrollBarActive(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawVisibleSize(area);
        if (s < this.scrollSize) {
            return true;
        }
        ScrollData data = this.getOtherScrollData(area);
        if (data == null || s - data.getThickness() >= this.scrollSize) {
            return false;
        }
        if (isOtherActive || data.isScrollBarActive(area, true)) {
            s -= data.getThickness();
        }
        return s < this.scrollSize;
    }

    public final boolean isOtherScrollBarActive(ScrollArea area, boolean isSelfActive) {
        ScrollData data = this.getOtherScrollData(area);
        return data != null && data.isScrollBarActive(area, isSelfActive);
    }

    public int getScrollBarLength(ScrollArea area) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, false);
        int length = (int)((float)(this.getVisibleSize(area, isOtherActive) * this.getFullVisibleSize(area, isOtherActive)) / (float)this.scrollSize);
        return Math.max(length, 4);
    }

    public abstract boolean isInsideScrollbarArea(ScrollArea var1, int var2, int var3);

    public boolean isAnimating() {
        return this.scrollAnimator.isRunning();
    }

    public int getAnimationDirection() {
        if (!this.isAnimating()) {
            return 0;
        }
        return this.scrollAnimator.getMax() >= this.scrollAnimator.getMin() ? 1 : -1;
    }

    public int getAnimatingTo() {
        return this.animatingTo;
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, int fullVisibleSize) {
        return (fullVisibleSize - scrollBarLength) * this.getScroll() / (this.getScrollSize() - this.getVisibleSize(area, fullVisibleSize));
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, boolean isOtherActive) {
        return this.getScrollBarStart(area, scrollBarLength, this.getFullVisibleSize(area, isOtherActive));
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawScrollbar(ScrollArea var1);

    @SideOnly(value=Side.CLIENT)
    protected void drawScrollBar(int x, int y, int w, int h) {
        GuiDraw.drawRect(x, y, w, h, -1118482);
        GuiDraw.drawRect(x + 1, y + 1, w - 1, h - 1, -10066330);
        GuiDraw.drawRect(x + 1, y + 1, w - 2, h - 2, -5592406);
    }

    public boolean onMouseClicked(ScrollArea area, int mainAxisPos, int crossAxisPos, int button) {
        if (this.isOnAxisStart() ? crossAxisPos <= area.getPoint(this.axis.getOther()) + this.getThickness() : crossAxisPos >= area.getEndPoint(this.axis.getOther()) - this.getThickness()) {
            this.dragging = true;
            this.clickOffset = mainAxisPos;
            int scrollBarSize = this.getScrollBarLength(area);
            int start = this.getScrollBarStart(area, scrollBarSize, false);
            int areaStart = area.getPoint(this.axis);
            boolean clickInsideBar = mainAxisPos >= areaStart + start && mainAxisPos <= areaStart + start + scrollBarSize;
            this.clickOffset = clickInsideBar ? mainAxisPos - areaStart - start : scrollBarSize / 2;
            return true;
        }
        return false;
    }
}

