/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AbstractParentWidget<I extends IWidget, W extends AbstractParentWidget<I, W>>
extends Widget<W> {
    private final List<I> children = new ArrayList<I>();

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return this.children;
    }

    public List<I> getTypeChildren() {
        return this.children;
    }

    @Override
    public boolean canHover() {
        if (IDrawable.isVisible(this.getBackground()) || IDrawable.isVisible(this.getHoverBackground()) || IDrawable.isVisible(this.getHoverOverlay()) || this.getTooltip() != null) {
            return true;
        }
        WidgetTheme widgetTheme = this.getWidgetTheme(this.getContext().getTheme());
        if (this.getBackground() == null && IDrawable.isVisible(widgetTheme.getBackground())) {
            return true;
        }
        return this.getHoverBackground() == null && IDrawable.isVisible(widgetTheme.getHoverBackground());
    }

    @Override
    public boolean canClickThrough() {
        return !this.canHover();
    }

    protected boolean addChild(I child, int index) {
        if (child == null || child == this || this.getChildren().contains(child)) {
            return false;
        }
        if (child instanceof ModularPanel) {
            throw new IllegalArgumentException("ModularPanel should not be added as child widget; Use ModularScreen#openPanel instead");
        }
        if (!this.isChildValid(child)) {
            throw new IllegalArgumentException("Child '" + child + "' is not valid for parent '" + this + "'!");
        }
        if (index < 0) {
            index += this.getChildren().size() + 1;
        }
        this.children.add(index, child);
        if (this.isValid()) {
            child.initialise(this);
        }
        this.onChildAdd(child);
        return true;
    }

    protected boolean remove(I child) {
        if (this.children.remove(child)) {
            child.dispose();
            this.onChildRemove(child);
            return true;
        }
        return false;
    }

    protected boolean remove(int index) {
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        IWidget child = (IWidget)this.children.remove(index);
        child.dispose();
        this.onChildRemove(child);
        return true;
    }

    protected boolean isChildValid(I child) {
        return true;
    }

    protected void onChildAdd(I child) {
    }

    protected void onChildRemove(I child) {
    }
}

