/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.BufferBuilder;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.utils.fakeworld.Camera;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.cleanroommc.modularui.utils.fakeworld.Projection;
import com.cleanroommc.modularui.utils.fakeworld.RenderWorld;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public class SchemaRenderer
implements IDrawable {
    private static final Framebuffer FBO = new Framebuffer(1080, 1080, true);
    private final ISchema schema;
    private final IBlockAccess renderWorld;
    private final Framebuffer framebuffer;
    private final Camera camera = new Camera(new Vector3f(), new Vector3f());
    private boolean cameraSetup = false;
    private DoubleSupplier scale;
    private BooleanSupplier disableTESR;
    private Consumer<IRayTracer> onRayTrace;
    private Consumer<Projection> afterRender;
    private BiConsumer<Camera, ISchema> cameraFunc;
    private int clearColor = 0;
    private boolean isometric = false;

    public SchemaRenderer(ISchema schema, Framebuffer framebuffer) {
        this.schema = schema;
        this.framebuffer = framebuffer;
        this.renderWorld = new RenderWorld(schema);
    }

    public SchemaRenderer(ISchema schema) {
        this(schema, FBO);
    }

    public SchemaRenderer cameraFunc(BiConsumer<Camera, ISchema> camera) {
        this.cameraFunc = camera;
        return this;
    }

    public SchemaRenderer onRayTrace(Consumer<IRayTracer> consumer) {
        this.onRayTrace = consumer;
        return this;
    }

    public SchemaRenderer afterRender(Consumer<Projection> consumer) {
        this.afterRender = consumer;
        return this;
    }

    public SchemaRenderer isometric(boolean isometric) {
        this.isometric = isometric;
        return this;
    }

    public SchemaRenderer scale(double scale) {
        return this.scale(() -> scale);
    }

    public SchemaRenderer scale(DoubleSupplier scale) {
        this.scale = scale;
        return this;
    }

    public SchemaRenderer disableTESR(boolean disable) {
        return this.disableTESR(() -> disable);
    }

    public SchemaRenderer disableTESR(BooleanSupplier disable) {
        this.disableTESR = disable;
        return this;
    }

    @Override
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        this.render(x, y, width, height, context.getMouseX(), context.getMouseY());
    }

    public void render(int x, int y, int width, int height, final int mouseX, final int mouseY) {
        if (this.cameraFunc != null) {
            this.cameraFunc.accept(this.camera, this.schema);
        }
        if (Objects.nonNull(this.scale)) {
            Vector3f cameraPos = this.camera.getPos();
            Vector3f looking = this.camera.getLookAt();
            Vector3f.sub((Vector3f)cameraPos, (Vector3f)looking, (Vector3f)cameraPos);
            if (cameraPos.length() != 0.0f) {
                cameraPos.normalise();
            }
            cameraPos.scale((float)this.scale.getAsDouble());
            Vector3f.add((Vector3f)looking, (Vector3f)cameraPos, (Vector3f)cameraPos);
        }
        int lastFbo = this.bindFBO();
        this.setupCamera(this.framebuffer.field_147621_c, this.framebuffer.field_147618_d);
        this.renderWorld();
        if (this.onRayTrace != null && Area.isInside(x, y, width, height, mouseX, mouseY)) {
            this.onRayTrace.accept(new IRayTracer(){

                @Override
                public MovingObjectPosition rayTrace(int screenX, int screenY) {
                    return SchemaRenderer.this.rayTrace(Projection.INSTANCE.unProject(screenX, screenY));
                }

                @Override
                public MovingObjectPosition rayTraceMousePos() {
                    return this.rayTrace(mouseX, mouseY);
                }
            });
        }
        this.resetCamera();
        this.unbindFBO(lastFbo);
        GlStateManager.enableTexture2D();
        GlStateManager.disableLighting();
        lastFbo = GL11.glGetInteger((int)3553);
        GlStateManager.bindTexture(this.framebuffer.field_147617_g);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78382_b();
        BufferBuilder.bufferbuilder.pos(x + width, y + height, 0.0).tex(1.0, 0.0).endVertex();
        BufferBuilder.bufferbuilder.pos(x + width, y, 0.0).tex(1.0, 1.0).endVertex();
        BufferBuilder.bufferbuilder.pos(x, y, 0.0).tex(0.0, 1.0).endVertex();
        BufferBuilder.bufferbuilder.pos(x, y + height, 0.0).tex(0.0, 0.0).endVertex();
        Tessellator.field_78398_a.func_78381_a();
        GlStateManager.bindTexture(lastFbo);
    }

    private void renderWorld() {
    }

    private static void setDefaultPassRenderState(int pass) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (pass == 0) {
            GlStateManager.enableDepth();
            GlStateManager.disableBlend();
            GlStateManager.depthMask(true);
        } else {
            GlStateManager.enableBlend();
            GlStateManager.blendFunc(770, 771);
            GlStateManager.depthMask(false);
        }
    }

    protected void setupCamera(int width, int height) {
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        GlStateManager.disableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableBlend();
        GlStateManager.viewport(0, 0, width, height);
        Color.setGlColor(this.clearColor);
        GlStateManager.clear(16640);
        GlStateManager.matrixMode(5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        float near = this.isometric ? 1.0f : 0.1f;
        float far = 10000.0f;
        float fovY = 60.0f;
        float aspect = (float)width / (float)height;
        float top = near * (float)Math.tan(Math.toRadians(fovY) / 2.0);
        float bottom = -top;
        float left = aspect * bottom;
        float right = aspect * top;
        if (this.isometric) {
            GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        } else {
            GL11.glFrustum((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        }
        GlStateManager.matrixMode(5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        if (this.isometric) {
            GlStateManager.scale(0.1, 0.1, 0.1);
        }
        Vector3f c = this.camera.getPos();
        Vector3f lookAt = this.camera.getLookAt();
        GLU.gluLookAt((float)c.x, (float)c.y, (float)c.z, (float)lookAt.x, (float)lookAt.y, (float)lookAt.z, (float)0.0f, (float)1.0f, (float)0.0f);
        this.cameraSetup = true;
    }

    protected void resetCamera() {
        this.cameraSetup = false;
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.viewport(0, 0, minecraft.field_71443_c, minecraft.field_71440_d);
        GlStateManager.matrixMode(5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
        GlStateManager.disableDepth();
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.framebuffer.func_147614_f();
        this.framebuffer.func_147610_a(true);
        GlStateManager.pushMatrix();
        return lastID;
    }

    private void unbindFBO(int lastID) {
        GlStateManager.popMatrix();
        this.framebuffer.func_147606_d();
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastID);
    }

    private MovingObjectPosition rayTrace(Vector3f hitPos) {
        Vec3 startPos = Vec3.func_72443_a((double)this.camera.getPos().x, (double)this.camera.getPos().y, (double)this.camera.getPos().z);
        hitPos.scale(2.0f);
        Vec3 endPos = Vec3.func_72443_a((double)((double)hitPos.x - startPos.field_72450_a), (double)((double)hitPos.y - startPos.field_72448_b), (double)((double)hitPos.z - startPos.field_72449_c));
        return this.schema.getWorld().func_72933_a(startPos, endPos);
    }

    public boolean isCameraSetup() {
        return this.cameraSetup;
    }

    public static interface ICamera {
        public void setupCamera(Vector3f var1, Vector3f var2);
    }

    public static interface IRayTracer {
        public MovingObjectPosition rayTrace(int var1, int var2);

        public MovingObjectPosition rayTraceMousePos();
    }
}

