/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.api.drawable.IInterpolation;
import com.cleanroommc.modularui.utils.ColorShade;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.ToIntFunction;
import net.minecraft.util.MathHelper;

public class Color {
    public static final ColorShade WHITE = ColorShade.builder(-1).addDarker(-526345, -1052689, -1579033, -2105377, -2631721, -3158065, -3684409, -4210753).build();
    public static final ColorShade BLACK = ColorShade.builder(-16777216).addBrighter(-16250872, -15724528, -15198184, -14671840, -14145496, -13619152, -13092808, -12566464).build();
    public static final ColorShade RED = ColorShade.builder(-769226).addBrighter(-1092784, -1739917, -1074534, -12846, -5138).addDarker(-1754827, -2937041, -3790808, -4776932).build();
    public static final ColorShade RED_ACCENT = ColorShade.builder(-44462).addBrighter(-30080).addDarker(-59580, -2818048).build();
    public static final ColorShade PINK = ColorShade.builder(-1499549).addBrighter(-1294214, -1023342, -749647, -476208, -203540).addDarker(-2614432, -4056997, -5434281, -7860657).build();
    public static final ColorShade PINK_ACCENT = ColorShade.builder(-49023).addBrighter(-32597).addDarker(-720809, -3862174).build();
    public static final ColorShade PURPLE = ColorShade.builder(-6543440).addBrighter(-5552196, -4560696, -3238952, -1982745, -793099).addDarker(-7461718, -8708190, -9823334, -11922292).build();
    public static final ColorShade PURPLE_ACCENT = ColorShade.builder(-2080517).addBrighter(-1408772).addDarker(-2817799, -5635841).build();
    public static final ColorShade DEEP_PURPLE = ColorShade.builder(-10011977).addBrighter(-8497214, -6982195, -5005861, -3029783, -1185802).addDarker(-10603087, -11457112, -12245088, -13558894).build();
    public static final ColorShade DEEP_PURPLE_ACCENT = ColorShade.builder(-8630785).addBrighter(-5011201).addDarker(-10149889, -10149889).build();
    public static final ColorShade INDIGO = ColorShade.builder(-12627531).addBrighter(-10720320, -8812853, -6313766, -3814679, -1512714).addDarker(-13022805, -13615201, -14142061, -15064194).build();
    public static final ColorShade INDIGO_ACCENT = ColorShade.builder(-11309570).addBrighter(-7561473).addDarker(-12756226, -13611010).build();
    public static final ColorShade BLUE = ColorShade.builder(-14575885).addBrighter(-12409355, -10177034, -7288071, -4464901, -1838339).addDarker(-14776091, -15108398, -15374912, -15906911).build();
    public static final ColorShade BLUE_ACCENT = ColorShade.builder(-12285185).addBrighter(-8211969).addDarker(-14059009, -14064897).build();
    public static final ColorShade LIGHT_BLUE = ColorShade.builder(-16537100).addBrighter(-14043402, -11549705, -8268550, -4987396, -1968642).addDarker(-16540699, -16611119, -16615491, -16689253).build();
    public static final ColorShade LIGHT_BLUE_ACCENT = ColorShade.builder(-12532481).addBrighter(-8333057).addDarker(-16731905, -16739862).build();
    public static final ColorShade CYAN = ColorShade.builder(-16728876).addBrighter(-14235942, -11677471, -8331542, -5051406, -2033670).addDarker(-16732991, -16738393, -16743537, -16752540).build();
    public static final ColorShade CYAN_ACCENT = ColorShade.builder(-15138817).addBrighter(-8060929).addDarker(-16718337, -16729900).build();
    public static final ColorShade TEAL = ColorShade.builder(-16738680).addBrighter(-14244198, -11684180, -8336444, -5054501, -2034959).addDarker(-16742021, -16746133, -16750244, -16757440).build();
    public static final ColorShade TEAL_ACCENT = ColorShade.builder(-10158118).addBrighter(-5767189).addDarker(-14816842, -16728155).build();
    public static final ColorShade GREEN = ColorShade.builder(-11751600).addBrighter(-10044566, -8271996, -5908825, -3610935, -1509911).addDarker(-12345273, -13070788, -13730510, -14983648).build();
    public static final ColorShade GREEN_ACCENT = ColorShade.builder(-9834322).addBrighter(-4589878).addDarker(-16718218, -16725933).build();
    public static final ColorShade LIGHT_GREEN = ColorShade.builder(-7617718).addBrighter(-6501275, -5319295, -3808859, -2298424, -919319).addDarker(-8604862, -9920712, -11171025, -13407970).build();
    public static final ColorShade LIGHT_GREEN_ACCENT = ColorShade.builder(-5046439).addBrighter(-3342448).addDarker(-8978685, -10167017).build();
    public static final ColorShade LIME = ColorShade.builder(-3285959).addBrighter(-2825897, -2300043, -1642852, -985917, -394265).addDarker(-4142541, -5262293, -6382300, -8227049).build();
    public static final ColorShade LIME_ACCENT = ColorShade.builder(-1114303).addBrighter(-721023).addDarker(-3735808, -5314048).build();
    public static final ColorShade YELLOW = ColorShade.builder(-5317).addBrighter(-4520, -3722, -2659, -1596, -537).addDarker(-141259, -278483, -415707, -688361).build();
    public static final ColorShade YELLOW_ACCENT = ColorShade.builder(-256).addBrighter(-115).addDarker(-5632, -10752).build();
    public static final ColorShade AMBER = ColorShade.builder(-16121).addBrighter(-13784, -10929, -8062, -4941, -1823).addDarker(-19712, -24576, -28928, -37120).build();
    public static final ColorShade AMBER_ACCENT = ColorShade.builder(-10432).addBrighter(-6785).addDarker(-15360, -21760).build();
    public static final ColorShade ORANGE = ColorShade.builder(-26624).addBrighter(-22746, -18611, -13184, -8014, -3104).addDarker(-291840, -689152, -1086464, -1683200).build();
    public static final ColorShade ORANGE_ACCENT = ColorShade.builder(-21696).addBrighter(-11904).addDarker(-28416, -37632).build();
    public static final ColorShade DEEP_ORANGE = ColorShade.builder(-43230).addBrighter(-36797, -30107, -21615, -13124, -267801).addDarker(-765666, -1684967, -2604267, -4246004).build();
    public static final ColorShade DEEP_ORANGE_ACCENT = ColorShade.builder(-37312).addBrighter(-24960).addDarker(-49920, -2282496).build();
    public static final ColorShade BROWN = ColorShade.builder(-8825528).addBrighter(-7508381, -6190977, -4412764, -2634552, -1053719).addDarker(-9614271, -10665929, -11652050, -12703965).build();
    public static final ColorShade GREY = ColorShade.builder(-6381922).addBrighter(-4342339, -2039584, -1118482, -657931, -328966).addDarker(-9079435, -10395295, -12434878, -14606047).build();
    public static final ColorShade BLUE_GREY = ColorShade.builder(-10453621).addBrighter(-8875876, -7297874, -5194043, -3155748, -1249295).addDarker(-11243910, -12232092, -13154481, -14273992).build();

    public static int rgb(int red, int green, int blue) {
        return Color.argb(red, green, blue, 255);
    }

    public static int argb(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int argb(float red, float green, float blue, float alpha) {
        return Color.argb((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int rgba(int red, int green, int blue, int alpha) {
        return (red & 0xFF) << 24 | (green & 0xFF) << 16 | (blue & 0xFF) << 8 | alpha & 0xFF;
    }

    public static int rgba(float red, float green, float blue, float alpha) {
        return Color.rgba((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int rgb(float red, float green, float blue) {
        return Color.argb(red, green, blue, 1.0f);
    }

    public static int ofHSV(float hue, float saturation, float value) {
        return Color.ofHSV(hue, saturation, value, 1.0f);
    }

    public static int ofHSV(float hue, float saturation, float value, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)1.0f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        return Color.ofHxcm(hue, c, x, m, alpha);
    }

    public static int ofHSL(float hue, float saturation, float lightness) {
        return Color.ofHSL(hue, saturation, lightness, 1.0f);
    }

    public static int ofHSL(float hue, float saturation, float lightness, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)1.0f);
        lightness = MathHelper.func_76131_a((float)lightness, (float)0.0f, (float)1.0f);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = lightness - c / 2.0f;
        return Color.ofHxcm(hue, c, x, m, alpha);
    }

    private static int ofHxcm(float hue, float c, float x, float m, float alpha) {
        if (hue < 60.0f) {
            return Color.argb(c + m, x + m, m, alpha);
        }
        if (hue < 120.0f) {
            return Color.argb(x + m, c + m, m, alpha);
        }
        if (hue < 180.0f) {
            return Color.argb(m, c + m, x + m, alpha);
        }
        if (hue < 240.0f) {
            return Color.argb(m, x + m, c + m, alpha);
        }
        if (hue < 300.0f) {
            return Color.argb(x + m, m, c + m, alpha);
        }
        return Color.argb(c + m, m, x + m, alpha);
    }

    public static int ofCMYK(float cyan, float magenta, float yellow, float black) {
        return Color.ofCMYK(cyan, magenta, yellow, black, 1.0f);
    }

    public static int ofCMYK(float cyan, float magenta, float yellow, float black, float alpha) {
        float oneMinusBlack = 1.0f - black;
        return Color.argb((1.0f - cyan) * oneMinusBlack, (1.0f - magenta) * oneMinusBlack, (1.0f - yellow) * oneMinusBlack, alpha);
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static float getRedF(int argb) {
        return (float)Color.getRed(argb) / 255.0f;
    }

    public static float getGreenF(int argb) {
        return (float)Color.getGreen(argb) / 255.0f;
    }

    public static float getBlueF(int argb) {
        return (float)Color.getBlue(argb) / 255.0f;
    }

    public static float getAlphaF(int argb) {
        return (float)Color.getAlpha(argb) / 255.0f;
    }

    public static int withRed(int argb, int red) {
        return (argb &= 0xFF00FFFF) | red << 16;
    }

    public static int withGreen(int argb, int green) {
        return (argb &= 0xFFFF00FF) | green << 8;
    }

    public static int withBlue(int argb, int blue) {
        return (argb &= 0xFFFFFF00) | blue;
    }

    public static int withAlpha(int argb, int alpha) {
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int withRed(int argb, float red) {
        return Color.withRed(argb, (int)(red * 255.0f));
    }

    public static int withGreen(int argb, float green) {
        return Color.withGreen(argb, (int)(green * 255.0f));
    }

    public static int withBlue(int argb, float blue) {
        return Color.withBlue(argb, (int)(blue * 255.0f));
    }

    public static int withAlpha(int argb, float alpha) {
        return Color.withAlpha(argb, (int)(alpha * 255.0f));
    }

    public static float getHue(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        if (r == g && r == b) {
            return 0.0f;
        }
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        if (r >= g && r >= b) {
            hue = (g - b) / (r - min) % 6.0f;
        } else if (g >= r && g >= b) {
            hue = (b - r) / (g - min) + 2.0f;
        } else if (b >= r && b >= g) {
            hue = (r - g) / (b - min) + 4.0f;
        }
        hue *= 60.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        return hue;
    }

    public static float getHSVSaturation(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return max == 0.0f ? 0.0f : (max - min) / max;
    }

    public static float getHSLSaturation(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max - min) / (1.0f - Math.abs(max + min - 1.0f));
    }

    public static float getValue(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        return Math.max(r, Math.max(g, b));
    }

    public static float getLightness(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max + min) / 2.0f;
    }

    public static int withHSVHue(int argb, float hue) {
        return Color.ofHSV(hue, Color.getHSVSaturation(argb), Color.getValue(argb), Color.getAlphaF(argb));
    }

    public static int withHSVSaturation(int argb, float saturation) {
        return Color.ofHSV(Color.getHue(argb), saturation, Color.getValue(argb), Color.getAlphaF(argb));
    }

    public static int withValue(int argb, float value) {
        return Color.ofHSV(Color.getHue(argb), Color.getHSVSaturation(argb), value, Color.getAlphaF(argb));
    }

    public static int withHSLHue(int argb, float hue) {
        return Color.ofHSL(hue, Color.getHSLSaturation(argb), Color.getLightness(argb), Color.getAlphaF(argb));
    }

    public static int withHSLSaturation(int argb, float saturation) {
        return Color.ofHSL(Color.getHue(argb), saturation, Color.getLightness(argb), Color.getAlphaF(argb));
    }

    public static int withLightness(int argb, float lightness) {
        return Color.ofHSL(Color.getHue(argb), Color.getHSLSaturation(argb), lightness, Color.getAlphaF(argb));
    }

    public static float getCyan(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - r / oneMinusBlack;
    }

    public static float getMagenta(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - g / oneMinusBlack;
    }

    public static float getYellow(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - b / oneMinusBlack;
    }

    public static float getBlack(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        return 1.0f - Math.max(r, Math.max(g, b));
    }

    public static int withCyan(int argb, float cyan) {
        return Color.ofCMYK(cyan, Color.getMagenta(argb), Color.getYellow(argb), Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withMagenta(int argb, float magenta) {
        return Color.ofCMYK(Color.getCyan(argb), magenta, Color.getYellow(argb), Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withYellow(int argb, float yellow) {
        return Color.ofCMYK(Color.getCyan(argb), Color.getMagenta(argb), yellow, Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withBlack(int argb, float black) {
        return Color.ofCMYK(Color.getCyan(argb), Color.getMagenta(argb), Color.getYellow(argb), black, Color.getAlphaF(argb));
    }

    public static int[] getRGBValues(int argb) {
        return new int[]{Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb)};
    }

    public static int[] getARGBValues(int argb) {
        return new int[]{Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb)};
    }

    public static float[] getHSVValues(int argb) {
        return new float[]{Color.getHue(argb), Color.getHSVSaturation(argb), Color.getValue(argb)};
    }

    public static float[] getHSLValues(int argb) {
        return new float[]{Color.getHue(argb), Color.getHSLSaturation(argb), Color.getLightness(argb)};
    }

    public static float[] getCMYKValues(int argb) {
        return new float[]{Color.getCyan(argb), Color.getMagenta(argb), Color.getYellow(argb), Color.getBlack(argb)};
    }

    public static int rgbaToArgb(int rgba) {
        return Color.argb(Color.getAlpha(rgba), Color.getRed(rgba), Color.getGreen(rgba), Color.getBlue(rgba));
    }

    public static int argbToRgba(int argb) {
        return Color.rgba(Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static int invert(int argb) {
        return Color.argb(255 - Color.getRed(argb), 255 - Color.getGreen(argb), 255 - Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static int multiply(int argb, float factor, boolean multiplyAlpha) {
        return Color.argb(Color.getRedF(argb) * factor, Color.getGreenF(argb) * factor, Color.getBlueF(argb) * factor, multiplyAlpha ? Color.getAlphaF(argb) * factor : Color.getAlphaF(argb));
    }

    public static int average(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int color : colors) {
            r += Color.getRed(color);
            g += Color.getGreen(color);
            b += Color.getBlue(color);
            a += Color.getAlpha(color);
        }
        return Color.argb(r / colors.length, g / colors.length, b / colors.length, a / colors.length);
    }

    @SafeVarargs
    public static <T> int average(ToIntFunction<T> colorFunction, T ... colorHolders) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (T colorHolder : colorHolders) {
            int color = colorFunction.applyAsInt(colorHolder);
            r += Color.getRed(color);
            g += Color.getGreen(color);
            b += Color.getBlue(color);
            a += Color.getAlpha(color);
        }
        return Color.argb(r / colorHolders.length, g / colorHolders.length, b / colorHolders.length, a / colorHolders.length);
    }

    public static int interpolate(int color1, int color2, float value) {
        return Color.interpolate(Interpolation.LINEAR, color1, color2, value);
    }

    public static int interpolate(IInterpolation curve, int color1, int color2, float value) {
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        int r = (int)curve.interpolate(Color.getRed(color1), Color.getRed(color2), value);
        int g = (int)curve.interpolate(Color.getGreen(color1), Color.getGreen(color2), value);
        int b = (int)curve.interpolate(Color.getBlue(color1), Color.getBlue(color2), value);
        int a = (int)curve.interpolate(Color.getAlpha(color1), Color.getAlpha(color2), value);
        return Color.argb(r, g, b, a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColor(int color) {
        if (color == 0) {
            GlStateManager.color(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        float a = Color.getAlphaF(color);
        if (a == 0.0f) {
            a = 1.0f;
        }
        GlStateManager.color(Color.getRedF(color), Color.getGreenF(color), Color.getBlueF(color), a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColorOpaque(int color) {
        if (color == 0) {
            GlStateManager.color(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        GlStateManager.color(Color.getRedF(color), Color.getGreenF(color), Color.getBlueF(color), 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetGlColor() {
        GlStateManager.colorMask(true, true, true, true);
        Color.setGlColorOpaque(Color.WHITE.main);
    }

    public static int ofJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            int color = (int)Long.decode(jsonElement.getAsString()).longValue();
            if (color != 0 && Color.getAlpha(color) == 0) {
                return Color.withAlpha(color, 255);
            }
            return color;
        }
        if (jsonElement.isJsonObject()) {
            int alpha;
            float alphaF;
            JsonObject json = jsonElement.getAsJsonObject();
            String alphaS = JsonHelper.getString(json, "1f", "a", "alpha");
            if (alphaS.contains(".") || alphaS.endsWith("f") || alphaS.endsWith("F") || alphaS.endsWith("d") || alphaS.endsWith("D")) {
                try {
                    alphaF = MathHelper.func_76131_a((float)Float.parseFloat(alphaS), (float)0.0f, (float)1.0f);
                    alpha = (int)(alphaF * 255.0f);
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException("Failed to parse alpha value", (Throwable)e);
                }
            }
            try {
                alpha = MathHelper.func_76125_a((int)Integer.parseInt(alphaS), (int)0, (int)255);
                alphaF = (float)alpha / 255.0f;
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Failed to parse alpha value", (Throwable)e);
            }
            if (Color.hasRGB(json)) {
                int blue;
                int green;
                if (Color.hasHS(json) || Color.hasV(json) || Color.hasL(json)) {
                    throw new JsonParseException("Found RGB values, but also HSV or HSL values!");
                }
                if (Color.hasCMYK(json)) {
                    throw new JsonParseException("Found RGB values, but also CMYK values!");
                }
                int red = JsonHelper.getInt(json, 255, "r", "red");
                if ((red | (green = JsonHelper.getInt(json, 255, "g", "green")) | (blue = JsonHelper.getInt(json, 255, "b", "blue"))) != 0 && alpha == 0) {
                    alpha = 255;
                }
                return Color.argb(red, green, blue, alpha);
            }
            if (Color.hasHS(json)) {
                if (Color.hasCMYK(json)) {
                    throw new JsonParseException("Found HSV or HSL values, but also CMYK values!");
                }
                int hue = JsonHelper.getInt(json, 0, "h", "hue");
                float saturation = JsonHelper.getFloat(json, 0.0f, "s", "saturation");
                if (Color.hasV(json)) {
                    if (Color.hasL(json)) {
                        throw new JsonParseException("Found HSV values, but also HSL values!");
                    }
                    float value = JsonHelper.getFloat(json, 1.0f, "v", "value");
                    return Color.ofHSV(hue, saturation, value, alphaF);
                }
                float lightness = JsonHelper.getFloat(json, 0.5f, "l", "lightness");
                return Color.ofHSL(hue, saturation, lightness, alphaF);
            }
            if (Color.hasCMYK(json)) {
                float c = JsonHelper.getFloat(json, 1.0f, "c", "cyan");
                float m = JsonHelper.getFloat(json, 1.0f, "m", "magenta");
                float y = JsonHelper.getFloat(json, 1.0f, "y", "yellow");
                float k = JsonHelper.getFloat(json, 1.0f, "k", "black");
                return Color.ofCMYK(c, m, y, k, alphaF);
            }
            throw new JsonParseException("Empty color declaration");
        }
        throw new JsonParseException("Color must be a primitive or an object!");
    }

    private static boolean hasRGB(JsonObject json) {
        return json.has("r") || json.has("red") || json.has("g") || json.has("green") || json.has("b") || json.has("blue");
    }

    private static boolean hasHS(JsonObject json) {
        return json.has("h") || json.has("hue") || json.has("s") || json.has("saturation");
    }

    private static boolean hasV(JsonObject json) {
        return json.has("v") || json.has("value");
    }

    private static boolean hasL(JsonObject json) {
        return json.has("l") || json.has("lightness");
    }

    private static boolean hasCMYK(JsonObject json) {
        return json.has("c") || json.has("cyan") || json.has("m") || json.has("magenta") || json.has("y") || json.has("yellow") || json.has("k") || json.has("black");
    }
}

