/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.text.RichText;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.widget.sizer.Area;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RichTooltip
implements IRichTextBuilder<RichTooltip> {
    private static final Area HOLDER = new Area();
    private final Consumer<Area> parent;
    private final RichText text = new RichText();
    private Pos pos = null;
    private Consumer<RichTooltip> tooltipBuilder;
    private int showUpTimer = 0;
    private boolean autoUpdate = false;
    private int titleMargin = 0;
    private boolean appliedMargin = true;
    private int x = 0;
    private int y = 0;
    private int maxWidth = Integer.MAX_VALUE;
    private boolean dirty;

    public RichTooltip(IWidget parent) {
        this((Area area) -> {
            area.setSize(parent.getArea());
            area.setPos(0, 0);
        });
    }

    public RichTooltip(Area parent) {
        this((Area area) -> area.set(parent));
    }

    public RichTooltip(Supplier<Area> parent) {
        this((Area area) -> area.set((Rectangle)parent.get()));
    }

    public RichTooltip(Consumer<Area> parent) {
        this.parent = parent;
    }

    public void buildTooltip() {
        this.dirty = false;
        if (this.tooltipBuilder != null) {
            this.text.clearText();
            this.tooltipBuilder.accept(this);
            this.appliedMargin = false;
        }
    }

    public void draw(GuiContext context) {
        this.draw(context, null);
    }

    public void draw(GuiContext context, @Nullable ItemStack stack) {
        if (this.autoUpdate) {
            this.markDirty();
        }
        if (this.isEmpty()) {
            return;
        }
        if (this.maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
        }
        if (!this.appliedMargin) {
            if (this.titleMargin > 0) {
                this.text.insertTitleMargin(this.titleMargin);
            }
            this.appliedMargin = true;
        }
        Area screen = context.getScreenArea();
        this.maxWidth = Math.min(this.maxWidth, screen.width);
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        TextRenderer renderer = TextRenderer.SHARED;
        List<String> textLines = this.text.getStringRepresentation();
        ScaledResolution res = new ScaledResolution(MCHelper.getMc(), MCHelper.getMc().field_71443_c, MCHelper.getMc().field_71440_d);
        int screenWidth = res.func_78326_a();
        int screenHeight = res.func_78328_b();
        this.text.setupRenderer(renderer, 0, 0, this.maxWidth, -1.0f, Color.WHITE.main, false);
        this.text.compileAndDraw(renderer, context, true);
        Rectangle area = this.determineTooltipArea(context, renderer, screenWidth, screenHeight, mouseX, mouseY);
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.disableBlend();
        GuiDraw.drawTooltipBackground(stack, textLines, area.x, area.y, area.width, area.height);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        renderer.setPos(area.x, area.y);
        this.text.compileAndDraw(renderer, context, false);
    }

    public Rectangle determineTooltipArea(GuiContext context, TextRenderer renderer, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        int width = (int)renderer.getLastWidth();
        int height = (int)renderer.getLastHeight();
        Pos pos = this.pos;
        if (pos == null) {
            Pos pos2 = pos = context.isMuiContext() ? context.getMuiContext().getScreen().getCurrentTheme().getTooltipPosOverride() : null;
            if (pos == null) {
                pos = ModularUIConfig.tooltipPos;
            }
        }
        if (pos == Pos.FIXED) {
            return new Rectangle(this.x, this.y, width, height);
        }
        if (pos == Pos.NEXT_TO_MOUSE) {
            int padding = 8;
            int mouseOffset = 12;
            int x = mouseX + 12;
            int y = mouseY - 12;
            if (x < 8) {
                x = 8;
            } else if (x + width + 8 > screenWidth) {
                if (screenWidth - mouseX < mouseX) {
                    if ((x -= 24 + width) < 8) {
                        x = 8;
                    }
                    width = mouseX - 12 - x;
                } else {
                    width = screenWidth - 8 - x;
                }
                renderer.setPos(x, y);
                renderer.setAlignment(this.text.getAlignment(), width, -1.0f);
                this.text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastWidth();
                height = (int)renderer.getLastHeight();
            }
            y = MathHelper.func_76125_a((int)y, (int)8, (int)(screenHeight - 8 - height));
            return new Rectangle(x, y, width, height);
        }
        if (this.parent == null) {
            throw new IllegalStateException("Tooltip pos is " + pos.name() + ", but no widget parent is set!");
        }
        int minWidth = this.text.getMinWidth();
        int shiftAmount = 10;
        int padding = 7;
        Area area = HOLDER;
        this.parent.accept(area);
        area.transformAndRectanglerize(context);
        int x = 0;
        int y = 0;
        if (pos.axis.isVertical()) {
            if (width < area.width) {
                x = area.x + shiftAmount;
            } else {
                x = area.x - shiftAmount;
                if (x < padding) {
                    x = padding;
                } else if (x + width > screenWidth - padding) {
                    int maxWidth = Math.max(minWidth, screenWidth - x - padding);
                    renderer.setAlignment(this.text.getAlignment(), maxWidth);
                    this.text.compileAndDraw(renderer, context, true);
                    width = (int)renderer.getLastWidth();
                    height = (int)renderer.getLastHeight();
                }
            }
            if (pos == Pos.VERTICAL) {
                int bottomSpace = screenHeight - area.ey();
                Pos pos3 = pos = bottomSpace < height + padding && bottomSpace < area.y ? Pos.ABOVE : Pos.BELOW;
            }
            if (pos == Pos.BELOW) {
                y = area.ey() + padding;
            } else if (pos == Pos.ABOVE) {
                y = area.y - height - padding;
            }
        } else if (pos.axis.isHorizontal()) {
            boolean usedMoreSpaceSide = false;
            Pos oPos = pos;
            if (oPos == Pos.HORIZONTAL) {
                if (area.x > screenWidth - area.ex()) {
                    pos = Pos.LEFT;
                } else {
                    pos = Pos.RIGHT;
                    x = screenWidth - area.ex() + padding;
                }
            }
            if (height < area.height) {
                y = area.y + shiftAmount;
            } else {
                y = area.y - shiftAmount;
                if (y < padding) {
                    y = padding;
                }
            }
            if (x + width > screenWidth - padding) {
                int maxWidth = pos == Pos.LEFT ? Math.max(minWidth, area.x - padding * 2) : Math.max(minWidth, screenWidth - area.ex() - padding * 2);
                usedMoreSpaceSide = true;
                renderer.setAlignment(this.text.getAlignment(), maxWidth);
                this.text.compileAndDraw(renderer, context, true);
                width = (int)renderer.getLastWidth();
                height = (int)renderer.getLastHeight();
            }
            if (oPos == Pos.HORIZONTAL && !usedMoreSpaceSide) {
                int rightSpace = screenWidth - area.ex();
                Pos pos4 = pos = rightSpace < width + padding && rightSpace < area.x ? Pos.LEFT : Pos.RIGHT;
            }
            if (pos == Pos.RIGHT) {
                x = area.ex() + padding;
            } else if (pos == Pos.LEFT) {
                x = area.x - width - padding;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean isEmpty() {
        if (this.dirty) {
            this.buildTooltip();
        }
        return this.text.isEmpty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public int getShowUpTimer() {
        return this.showUpTimer;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public RichTooltip pos(Pos pos) {
        this.pos = pos;
        return this;
    }

    public RichTooltip pos(int x, int y) {
        this.pos = Pos.FIXED;
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public RichTooltip getThis() {
        return this;
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTooltip showUpTimer(int showUpTimer) {
        this.showUpTimer = showUpTimer;
        return this;
    }

    public RichTooltip tooltipBuilder(Consumer<RichTooltip> tooltipBuilder) {
        Consumer<RichTooltip> existingBuilder = this.tooltipBuilder;
        this.tooltipBuilder = existingBuilder != null ? tooltip -> {
            existingBuilder.accept(this);
            tooltipBuilder.accept(this);
        } : tooltipBuilder;
        this.markDirty();
        return this;
    }

    public RichTooltip setAutoUpdate(boolean update) {
        this.autoUpdate = update;
        return this;
    }

    public RichTooltip addFromItem(ItemStack item) {
        List<String> lines = MCHelper.getItemToolTip(item);
        ((RichTooltip)this.add(lines.get(0))).spaceLine(2);
        int n = lines.size();
        for (int i = 1; i < n; ++i) {
            ((RichTooltip)this.add(lines.get(i))).newLine();
        }
        return this;
    }

    public RichTooltip addFromFluid(FluidStack fluid) {
        List<String> lines = MCHelper.getFluidTooltip(fluid);
        ((RichTooltip)this.add(lines.get(0))).spaceLine(2);
        int n = lines.size();
        for (int i = 1; i < n; ++i) {
            ((RichTooltip)this.add(lines.get(i))).newLine();
        }
        return this;
    }

    public RichTooltip addAdditionalInfoFromFluid(FluidStack fluid) {
        List<String> lines = MCHelper.getAdditionalFluidTooltip(fluid);
        for (String line : lines) {
            ((RichTooltip)this.add(line)).newLine();
        }
        return this;
    }

    public RichTooltip titleMargin() {
        return this.titleMargin(0);
    }

    public RichTooltip titleMargin(int margin) {
        this.titleMargin = margin;
        this.appliedMargin = false;
        return this;
    }

    public static enum Pos {
        ABOVE(GuiAxis.Y),
        BELOW(GuiAxis.Y),
        LEFT(GuiAxis.X),
        RIGHT(GuiAxis.X),
        VERTICAL(GuiAxis.Y),
        HORIZONTAL(GuiAxis.X),
        NEXT_TO_MOUSE(null),
        FIXED(null);

        public final GuiAxis axis;

        private Pos(GuiAxis axis) {
            this.axis = axis;
        }

        public static Pos fromString(String name) {
            try {
                return Pos.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                return VERTICAL;
            }
        }
    }
}

