/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.drawable.DrawableArray;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public interface IDrawable {
    public static final IDrawable EMPTY = (context, x, y, width, height, widgetTheme) -> {};
    public static final IDrawable NONE = (context, x, y, width, height, widgetTheme) -> {};

    public static IDrawable of(IDrawable ... drawables) {
        if (drawables == null || drawables.length == 0) {
            return null;
        }
        if (drawables.length == 1) {
            return drawables[0];
        }
        return new DrawableArray(drawables);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext var1, int var2, int var3, int var4, int var5, WidgetTheme var6);

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void draw(GuiContext context, int x, int y, int width, int height) {
        this.draw(context, x, y, width, height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void drawAtZero(GuiContext context, int width, int height) {
        this.drawAtZero(context, width, height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, int width, int height, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, width, height, widgetTheme);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void draw(GuiContext context, Area area) {
        this.draw(context, area, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.x + area.getPadding().left, area.y + area.getPadding().top, area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, Area area) {
        this.drawAtZero(context, area, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, area.paddedWidth(), area.paddedHeight(), widgetTheme);
    }

    default public boolean canApplyTheme() {
        return false;
    }

    default public Widget<?> asWidget() {
        return new DrawableWidget(this);
    }

    default public Icon asIcon() {
        return new Icon(this);
    }

    default public void loadFromJson(JsonObject json) {
    }

    public static boolean isVisible(@Nullable IDrawable drawable) {
        if (drawable == null || drawable == EMPTY || drawable == NONE) {
            return false;
        }
        if (drawable instanceof DrawableArray) {
            DrawableArray array = (DrawableArray)drawable;
            return array.getDrawables().length > 0;
        }
        return true;
    }

    public static class DrawableWidget
    extends Widget<DrawableWidget> {
        private final IDrawable drawable;

        public DrawableWidget(IDrawable drawable) {
            this.drawable = drawable;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
            this.drawable.drawAtZero((GuiContext)context, this.getArea(), widgetTheme);
        }
    }
}

