/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.model;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import tconstruct.client.BlockSkinRenderHelper;
import tconstruct.util.ItemHelper;
import tconstruct.world.TinkerWorld;
import tconstruct.world.blocks.SlimePad;

@ThreadSafeISBRH(perThread=false)
public class SlimePadRender
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            ItemHelper.renderStandardInvBlock(renderer, TinkerWorld.slimeGel, metadata);
            renderer.func_147782_a(0.0, 0.0625, 0.0, 1.0, 0.5, 1.0);
            ItemHelper.renderStandardInvBlock(renderer, TinkerWorld.slimeGel, 1);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            int metadata = world.func_72805_g(x, y, z);
            BlockSkinRenderHelper.renderLiquidBlock(((SlimePad)block).getFluidIcon(metadata), ((SlimePad)block).getFluidIcon(metadata), x, y, z, renderer, world);
            renderer.func_147782_a(0.125, 0.0625, 0.125, 0.875, 0.625, 0.875);
            renderer.func_147784_q(block, x, y, z);
            float[] size = this.size(metadata % 8);
            renderer.func_147782_a((double)size[0], 0.5, (double)size[1], (double)size[2], 0.6875, (double)size[3]);
            BlockSkinRenderHelper.renderLiquidBlock(((SlimePad)block).getNubIcon(metadata), ((SlimePad)block).getNubIcon(metadata), x, y, z, renderer, world);
            return true;
        }
        return false;
    }

    float[] size(int meta) {
        switch (meta) {
            case 0: {
                return new float[]{0.375f, 0.6875f, 0.625f, 0.9375f};
            }
            case 1: {
                return new float[]{0.0625f, 0.6875f, 0.3125f, 0.9375f};
            }
            case 2: {
                return new float[]{0.0625f, 0.375f, 0.3125f, 0.625f};
            }
            case 3: {
                return new float[]{0.0625f, 0.0625f, 0.3125f, 0.3125f};
            }
            case 4: {
                return new float[]{0.375f, 0.0625f, 0.625f, 0.3125f};
            }
            case 5: {
                return new float[]{0.6875f, 0.0625f, 0.9375f, 0.3125f};
            }
            case 6: {
                return new float[]{0.6875f, 0.375f, 0.9375f, 0.625f};
            }
            case 7: {
                return new float[]{0.6875f, 0.6875f, 0.9375f, 0.9375f};
            }
        }
        return new float[]{0.375f, 0.375f, 0.625f, 0.625f};
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return model;
    }
}

