/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.opencomputers;

import java.util.HashSet;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Architecture;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.interfaces.IOpenComputersProxy;
import logisticspipes.proxy.opencomputers.IOCTile;
import logisticspipes.proxy.opencomputers.asm.BaseWrapperClass;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class OpenComputersProxy
implements IOpenComputersProxy {
    private static final Set<String> targetName = new HashSet<String>();
    private static final Set<String> skipName = new HashSet<String>();

    @Override
    public void initLogisticsTileGenericPipe(LogisticsTileGenericPipe tile) {
        tile.node = Network.newNode((Environment)tile, (Visibility)Visibility.Neighbors).withComponent("logisticspipe", Visibility.Neighbors).create();
    }

    @Override
    public void initLogisticsSolidTileEntity(LogisticsSolidTileEntity tile) {
        tile.node = Network.newNode((Environment)tile, (Visibility)Visibility.Neighbors).withComponent("logisticssolidblock", Visibility.Neighbors).create();
    }

    @Override
    public void addToNetwork(TileEntity tile) {
        Network.joinOrCreateNetwork((TileEntity)tile);
    }

    @Override
    public void handleInvalidate(IOCTile tile) {
        if (tile.getOCNode() != null) {
            ((Node)tile.getOCNode()).remove();
        }
    }

    @Override
    public void handleChunkUnload(IOCTile tile) {
        if (tile.getOCNode() != null) {
            ((Node)tile.getOCNode()).remove();
        }
    }

    @Override
    public void handleReadFromNBT(IOCTile tile, NBTTagCompound nbt) {
        if (tile.getOCNode() != null && ((Node)tile.getOCNode()).host() == tile) {
            ((Node)tile.getOCNode()).load(nbt.func_74775_l("oc:node"));
        }
    }

    @Override
    public void handleWriteToNBT(IOCTile tile, NBTTagCompound nbt) {
        if (tile.getOCNode() != null && ((Node)tile.getOCNode()).host() == tile) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            ((Node)tile.getOCNode()).save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    @Override
    public void pushSignal(String event, Object[] arguments, IOCTile tile) {
        if (tile.getOCNode() != null) {
            Object[] data = new Object[1 + arguments.length];
            data[0] = event;
            System.arraycopy(arguments, 0, data, 1, arguments.length);
            ((Node)tile.getOCNode()).sendToNeighbors("computer.signal", data);
        }
    }

    @Override
    public void handleMesssage(Object sourceId, String receiveId, Object message, IOCTile tile) {
        if (tile.getOCNode() != null && ((Node)tile.getOCNode()).address().equals(receiveId)) {
            ((Node)tile.getOCNode()).sendToNeighbors("computer.signal", new Object[]{"LP_MESSAGE", sourceId, message});
        }
    }

    @Override
    public String getAddress(IOCTile tile) {
        return tile.getOCNode() != null ? ((Node)tile.getOCNode()).address() : null;
    }

    @Override
    public boolean isServerSide(Thread thread) {
        StackTraceElement[] ste = thread.getStackTrace();
        if (ste.length < 8) {
            return false;
        }
        for (int i = ste.length - 8; i >= 0; --i) {
            if (skipName.contains(ste[i].getClassName())) continue;
            if (targetName.contains(ste[i].getClassName())) {
                return true;
            }
            try {
                Class<?> clazz = Class.forName(ste[i].getClassName());
                if (Architecture.class.isAssignableFrom(clazz)) {
                    targetName.add(ste[i].getClassName());
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            skipName.add(ste[i].getClassName());
        }
        return false;
    }

    @Override
    public Object getWrappedObject(Object object) {
        return CCObjectWrapper.getWrappedObject(object, BaseWrapperClass.WRAPPER);
    }
}

