/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.block.OpenBlock;
import openmods.geometry.Orientation;

public class ItemOpenBlock
extends ItemBlock {
    public ItemOpenBlock(Block block) {
        super(block);
    }

    private static boolean canReplace(Block block, World world, int x, int y, int z) {
        return block != null && block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    protected void afterBlockPlaced(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        --stack.field_77994_a;
    }

    protected boolean isStackValid(ItemStack stack, EntityPlayer player) {
        return stack.field_77994_a >= 0;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!this.isStackValid(stack, player)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150433_aE && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        }
        ForgeDirection sideDir = ForgeDirection.getOrientation((int)side);
        if (!ItemOpenBlock.canReplace(block, world, x, y, z)) {
            x += sideDir.offsetX;
            y += sideDir.offsetY;
            z += sideDir.offsetZ;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        Block ownBlock = this.field_150939_a;
        if (y == 255 && ownBlock.func_149688_o().func_76220_a()) {
            return false;
        }
        if (!world.func_147472_a(ownBlock, x, y, z, false, side, (Entity)player, stack)) {
            return false;
        }
        if (ownBlock instanceof OpenBlock) {
            OpenBlock ob = (OpenBlock)ownBlock;
            Orientation blockOrientation = ob.calculatePlacementSide(player, sideDir);
            if (blockOrientation == null) {
                return false;
            }
            int newMeta = this.calculateBlockMeta(world, ownBlock, x, y, z, side, hitX, hitY, hitZ, stack.func_77960_j());
            if (!ob.canPlaceBlock(world, player, stack, x, y, z, sideDir, blockOrientation, hitX, hitY, hitZ, newMeta)) {
                return false;
            }
            if (!this.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, newMeta)) {
                return false;
            }
            ob.afterBlockPlaced(world, player, stack, x, y, z, sideDir, blockOrientation, hitX, hitY, hitZ, newMeta);
        } else {
            int newMeta = this.calculateBlockMeta(world, ownBlock, x, y, z, side, hitX, hitY, hitZ, stack.func_77960_j());
            if (!this.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, newMeta)) {
                return false;
            }
        }
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, ownBlock.field_149762_H.func_150495_a(), (ownBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, ownBlock.field_149762_H.func_150494_d() * 0.8f);
        this.afterBlockPlaced(stack, player, world, x, y, z);
        return true;
    }

    protected int calculateBlockMeta(World world, Block ownBlock, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int damage) {
        int newMeta = this.func_77647_b(damage);
        return ownBlock.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, newMeta);
    }
}

