/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import openmods.access.ApiImplementation;
import openmods.access.ApiInstanceProvider;
import openmods.access.ApiSingleton;

public class ApiProviderRegistry<A> {
    private final Class<? super A> markerType;
    private final Map<Class<? extends A>, ApiInstanceProvider<?>> providers = Maps.newHashMap();
    private boolean isFrozen;

    private static boolean shouldIncludeSuper(ApiSingleton meta) {
        return meta == null || meta.includeSuper();
    }

    public void freeze() {
        this.isFrozen = true;
    }

    private void findAllImplementedApis(Collection<Class<? extends A>> output, Class<?> ... intfs) {
        for (Class<?> cls : intfs) {
            Preconditions.checkArgument((boolean)cls.isInterface());
            if (!this.markerType.isAssignableFrom(cls) || this.markerType == cls) continue;
            output.add(cls);
        }
    }

    private void addAllApiInterfaces(Set<Class<? extends A>> interfaces) {
        Class cls;
        LinkedList queue = Lists.newLinkedList(interfaces);
        while ((cls = (Class)queue.poll()) != null) {
            interfaces.add(cls);
            this.findAllImplementedApis(queue, cls.getInterfaces());
        }
    }

    private <T extends A> void registerInterfaces(Class<? extends T> cls, ApiInstanceProvider<T> provider, boolean includeSuper) {
        HashSet implemented = Sets.newHashSet();
        this.findAllImplementedApis(implemented, cls.getInterfaces());
        if (includeSuper) {
            this.addAllApiInterfaces(implemented);
        }
        for (Class impl : implemented) {
            ApiInstanceProvider<T> prev = this.providers.put(impl, provider);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Conflict on %s: %s -> %s", (Object[])new Object[]{impl, prev, provider});
        }
    }

    private static boolean shouldIncludeSuper(ApiImplementation meta) {
        return meta == null || meta.includeSuper();
    }

    private static boolean isCacheable(ApiImplementation meta) {
        return meta == null || meta.cacheable();
    }

    public ApiProviderRegistry(Class<? super A> markerType) {
        this.markerType = markerType;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public <T extends A> void registerClass(Class<? extends T> cls) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0, (Object)"This registry is already frozen");
        Preconditions.checkArgument((!Modifier.isAbstract(cls.getModifiers()) ? 1 : 0) != 0);
        ApiImplementation meta = cls.getAnnotation(ApiImplementation.class);
        ApiInstanceProvider provider = ApiProviderRegistry.isCacheable(meta) ? new ApiInstanceProvider.CachedInstance<T>(cls) : new ApiInstanceProvider.NewInstance<T>(cls);
        this.registerInterfaces(cls, provider, ApiProviderRegistry.shouldIncludeSuper(meta));
    }

    public <T extends A> void registerInstance(T obj) {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0, (Object)"This registry is already frozen");
        Class<?> cls = obj.getClass();
        ApiSingleton meta = cls.getAnnotation(ApiSingleton.class);
        ApiInstanceProvider.Singleton<T> provider = new ApiInstanceProvider.Singleton<T>(obj);
        this.registerInterfaces(cls, provider, ApiProviderRegistry.shouldIncludeSuper(meta));
    }

    public <T extends A> T getApi(Class<T> cls) {
        ApiInstanceProvider<?> provider = this.providers.get(cls);
        Preconditions.checkNotNull(provider, (String)"Can't get implementation for class %s", (Object[])new Object[]{cls});
        return (T)provider.getInterface();
    }

    public <T extends A> boolean isApiPresent(Class<T> cls) {
        return this.providers.containsKey(cls);
    }
}

