/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.api;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public interface IBoots {
    public static final String TAG_MODE_JUMP = "jump";
    public static final String TAG_MODE_SPEED = "speed";
    public static final String TAG_MODE_OMNI = "omni";
    public static final String TAG_MODE_INERTIA = "inertiacanceling";

    default public void setModeSpeed(ItemStack stack, double modifier) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74780_a(TAG_MODE_SPEED, modifier);
    }

    default public void setModeJump(ItemStack stack, double modifier) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74780_a(TAG_MODE_JUMP, modifier);
    }

    default public void setModeOmni(ItemStack stack, boolean enabled) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a(TAG_MODE_OMNI, enabled);
    }

    default public void setIsInertiaCanceling(ItemStack stack, boolean enabled) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a(TAG_MODE_INERTIA, enabled);
    }

    default public double changeSpeed(ItemStack stack, double modifier) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        double oldSpeed = stack.field_77990_d.func_74769_h(TAG_MODE_SPEED);
        double newSpeed = (double)Math.round(20.0 * (oldSpeed + modifier)) / 20.0;
        if (oldSpeed == 1.0) {
            newSpeed = 0.0;
        } else if (newSpeed > 1.0 && oldSpeed < 1.0) {
            newSpeed = 1.0;
        }
        stack.field_77990_d.func_74780_a(TAG_MODE_SPEED, newSpeed);
        return newSpeed;
    }

    default public double changeJump(ItemStack stack, double modifier) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        double oldJump = stack.field_77990_d.func_74769_h(TAG_MODE_JUMP);
        double newJump = (double)Math.round(20.0 * (oldJump + modifier)) / 20.0;
        if (oldJump == 1.0) {
            newJump = 0.0;
        } else if (newJump > 1.0 && oldJump < 1.0) {
            newJump = 1.0;
        }
        stack.field_77990_d.func_74780_a(TAG_MODE_JUMP, newJump);
        return newJump;
    }

    default public boolean changeOmniState(ItemStack stack) {
        boolean omni;
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        omni = !(omni = stack.field_77990_d.func_74767_n(TAG_MODE_OMNI));
        stack.field_77990_d.func_74757_a(TAG_MODE_OMNI, omni);
        return omni;
    }

    default public boolean changeIsInertiaCanceled(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        boolean inertiaCanceling = !stack.field_77990_d.func_74767_n(TAG_MODE_INERTIA);
        stack.field_77990_d.func_74757_a(TAG_MODE_INERTIA, inertiaCanceling);
        return inertiaCanceling;
    }

    default public double isSpeedEnabled(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74769_h(TAG_MODE_SPEED);
        }
        return 0.0;
    }

    public static double isJumpEnabled(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74769_h(TAG_MODE_JUMP);
        }
        return 0.0;
    }

    default public boolean isOmniEnabled(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74767_n(TAG_MODE_OMNI);
        }
        return false;
    }

    default public boolean isInertiaCanceled(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return stack.field_77990_d.func_74767_n(TAG_MODE_INERTIA);
        }
        return false;
    }

    public static ItemStack getBoots(EntityPlayer player) {
        ItemStack stack1 = player.func_82169_q(0);
        return IBoots.isBoot(stack1) ? stack1 : null;
    }

    public static boolean isBoot(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IBoots;
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDJumpNotification() {
        Minecraft mc = Minecraft.func_71410_x();
        String text = IBoots.getModeText("thaumicboots.jumpEffect", IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74769_h(TAG_MODE_JUMP) * 100.0);
        GTNHLib.proxy.printMessageAboveHotbar(text, 60, true, true);
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDSpeedNotification() {
        Minecraft mc = Minecraft.func_71410_x();
        String text = IBoots.getModeText("thaumicboots.speedEffect", IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74769_h(TAG_MODE_SPEED) * 100.0);
        GTNHLib.proxy.printMessageAboveHotbar(text, 60, true, true);
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDOmniNotification() {
        Minecraft mc = Minecraft.func_71410_x();
        String result = "thaumicboots.activeState" + IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74767_n(TAG_MODE_OMNI);
        String midResult = IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74767_n(TAG_MODE_OMNI) ? EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)result) : EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)result);
        String finalResult = EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"thaumicboots.omniEffect") + " " + midResult;
        GTNHLib.proxy.printMessageAboveHotbar(finalResult, 60, true, true);
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDInertiaNotification(boolean serverConfigValue) {
        String finalResult;
        if (serverConfigValue) {
            Minecraft mc = Minecraft.func_71410_x();
            String result = "thaumicboots.activeState" + IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74767_n(TAG_MODE_INERTIA);
            String midResult = IBoots.getBoots((EntityPlayer)mc.field_71439_g).field_77990_d.func_74767_n(TAG_MODE_INERTIA) ? EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)result) : EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)result);
            finalResult = EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"thaumicboots.inertiaCancelingEffect") + " " + midResult;
        } else {
            finalResult = EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"thaumicboots.inertiaCancelingConfigDisabledMessage");
        }
        GTNHLib.proxy.printMessageAboveHotbar(finalResult, 60, true, true);
    }

    @Optional.Method(modid="gtnhlib")
    public static String getModeText(String effect, double val) {
        String endResult = (int)val + "%";
        String result = "";
        switch ((int)Math.floor(val / 25.0)) {
            case 0: {
                result = EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)endResult);
                break;
            }
            case 1: {
                result = EnumChatFormatting.RED + StatCollector.func_74838_a((String)endResult);
                break;
            }
            case 2: {
                result = EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)endResult);
                break;
            }
            case 3: {
                result = EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)endResult);
                break;
            }
            case 4: {
                result = EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)endResult);
                break;
            }
            default: {
                result = EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)endResult);
            }
        }
        return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)effect) + " " + result;
    }
}

