/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockBerryBush;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.core.handlers.ServerEventHandler;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.WeightedRandomItem;
import ganymedes01.etfuturum.entities.EntityRabbit;
import ganymedes01.etfuturum.entities.ai.EntityAICustomAvoidEntity;
import ganymedes01.etfuturum.entities.ai.EntityAICustomNearestAttackableTarget;
import ganymedes01.etfuturum.entities.ai.EntityAIFleeSunExtended;
import ganymedes01.etfuturum.entities.ai.ExtendedEntityLookHelper;
import ganymedes01.etfuturum.entities.ai.TargetPredicate;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntityFox
extends EntityAnimal {
    private static final int OWNER = 18;
    private static final int OTHER_TRUSTED = 19;
    private static final int TYPE = 20;
    private static final int FOX_FLAGS = 21;
    private static final IEntitySelector PICKABLE_DROP_FILTER = entity -> {
        if (!(entity instanceof EntityItem)) return false;
        EntityItem item = (EntityItem)entity;
        if (item.field_145804_b > 0) return false;
        if (!item.func_70089_S()) return false;
        return true;
    };
    private static final Predicate<EntityLivingBase> CHICKEN_AND_RABBIT_FILTER = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<EntityLivingBase> NOTICEABLE_PLAYER_FILTER = entity -> {
        EntityPlayer player;
        return !(entity instanceof EntityPlayer) || !(player = (EntityPlayer)entity).func_70093_af() && !player.field_71075_bZ.field_75098_d && !SpectatorMode.isSpectator(player);
    };
    private static final Predicate<EntityLivingBase> JUST_ATTACKED_SOMETHING_FILTER = entity -> entity instanceof EntityLiving;
    private EntityAIBase followChickenAndRabbitTask;
    private float headRollProgress;
    private float lastHeadRollProgress;
    private float extraRollingHeight;
    private float lastExtraRollingHeight;
    private int eatingTime;
    private EntityLivingBase friend;
    private boolean followOwner;
    private static List<WeightedRandomItem<Item>> spawnItems;
    private static List<Item> breedingItems;

    public EntityFox(World world) {
        super(world);
        this.field_70749_g = new FoxLookHelper();
        this.field_70765_h = new FoxMoveHelper();
        this.func_70105_a(0.6f, 0.7f);
        this.func_98053_h(true);
        this.initTasks();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)"");
        this.field_70180_af.func_75682_a(19, (Object)"");
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected void initTasks() {
        this.followChickenAndRabbitTask = new EntityAICustomNearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISwim());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIStopWandering());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIEscapeWhenNotAggressive(2.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICustomAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 1.6, 1.4, livingEntity -> NOTICEABLE_PLAYER_FILTER.test((EntityLivingBase)livingEntity) && !this.canTrust(livingEntity.func_110124_au()) && !this.isAggressive()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICustomAvoidEntity((EntityCreature)this, EntityWolf.class, 8.0f, 1.6, 1.4, livingEntity -> !((EntityWolf)livingEntity).func_70909_n() && !this.isAggressive()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMoveToHunt());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIJumpChase());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIMate(1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAvoidDaylight(1.25));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIAttack(1.2, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIDelayedCalmDown());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIFollowParent(this, 1.25));
        if (ConfigBlocksItems.enableSweetBerryBushes) {
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIEatSweetBerries(1.2, 12, 2));
        }
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIPickupItem());
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AILookAtEntity((EntityLiving)this, EntityPlayer.class, 24.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AISitDownAndLookAround());
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIDefendFriend(EntityLiving.class, false, false, entity -> entity != null && JUST_ATTACKED_SOMETHING_FILTER.test((EntityLivingBase)entity) && !this.canTrust(entity.func_110124_au())));
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            EntityLivingBase livingEntity;
            ++this.eatingTime;
            ItemStack itemStack = this.func_70694_bm();
            if (this.canEat(itemStack)) {
                int eatDelay = 560;
                if (this.eatingTime > eatDelay + 40) {
                    ItemStack itemStack2 = this.eatFood(this.field_70170_p, itemStack);
                    if (itemStack2 != null && itemStack2.func_77973_b() != null && itemStack2.field_77994_a > 0) {
                        this.func_70062_b(0, itemStack2);
                    } else {
                        this.func_70062_b(0, null);
                    }
                    this.eatingTime = 0;
                } else if (this.eatingTime > eatDelay && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.func_85030_a(this.getEatSound(), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
            if ((livingEntity = this.func_70638_az()) == null || !livingEntity.func_70089_S()) {
                this.setCrouching(false);
                this.setRollingHead(false);
            }
        }
        if (this.getPetOwner() != null && this.func_70068_e((Entity)this.getPetOwner()) > 4096.0) {
            this.followOwner = false;
        }
        if (this.func_70608_bn() || this.field_70128_L) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_98052_bS() && this.func_70089_S() && !this.field_70729_aU && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
            for (EntityItem item : list) {
                if (item.field_70128_L || item.func_92059_d() == null || item.field_145804_b > 0) continue;
                this.loot(item);
            }
        }
        if (this.isAggressive() && this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_85030_a("minecraft_1.21:entity.fox.aggro", 1.0f, 1.0f);
        }
    }

    private boolean canEat(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemFood && this.func_70638_az() == null && this.field_70122_E && !this.func_70608_bn();
    }

    protected void initEquipment() {
        List<WeightedRandomItem<Item>> items;
        if (this.field_70146_Z.nextFloat() < 0.2f && !(items = EntityFox.getSpawnItems()).isEmpty()) {
            WeightedRandomItem choice = (WeightedRandomItem)WeightedRandom.func_76271_a((Random)this.func_70681_au(), items);
            this.func_70062_b(0, new ItemStack((Item)choice.data));
        }
    }

    private static List<WeightedRandomItem<Item>> getSpawnItems() {
        if (spawnItems == null) {
            spawnItems = new ArrayList<WeightedRandomItem<Item>>();
            int extra = 5;
            if (ConfigEntities.enableRabbit) {
                extra = 0;
                spawnItems.add(new WeightedRandomItem<Item>(10, ModItems.RABBIT_FOOT.get()));
                spawnItems.add(new WeightedRandomItem<Item>(10, ModItems.RABBIT_HIDE.get()));
            }
            spawnItems.add(new WeightedRandomItem<Item>(5, Items.field_151166_bC));
            spawnItems.add(new WeightedRandomItem<Item>(15 + extra, Items.field_151110_aK));
            spawnItems.add(new WeightedRandomItem<Item>(20 + extra, Items.field_151015_O));
            spawnItems.add(new WeightedRandomItem<Item>(20 + extra, Items.field_151116_aA));
            spawnItems.add(new WeightedRandomItem<Item>(20 + extra, Items.field_151008_G));
        }
        return spawnItems;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 45) {
            ItemStack itemStack = this.func_70694_bm();
            if (itemStack != null && itemStack.func_77973_b() != null && itemStack.field_77994_a > 0) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = Vec3.func_72443_a((double)(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1), (double)(Math.random() * 0.1 + 0.1), (double)0.0);
                    vec3d.func_72440_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d.func_72442_b(-this.field_70177_z * ((float)Math.PI / 180));
                    Vec3 rv = EntityFox.getRotationVector(this.field_70125_A, this.field_70177_z);
                    this.field_70170_p.func_72869_a(EntityFox.getItemStackParticleName(itemStack), this.field_70165_t + rv.field_72450_a / 2.0, this.field_70163_u, this.field_70161_v + rv.field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(status);
        }
    }

    private static String getItemStackParticleName(ItemStack stack) {
        String s = "iconcrack_" + Item.func_150891_b((Item)stack.func_77973_b());
        if (stack.func_77981_g()) {
            s = s + "_" + stack.func_77960_j();
        }
        return s;
    }

    private static Vec3 getRotationVector(float pitch, float yaw) {
        float f = (float)((double)pitch * Math.PI / 180.0);
        float g = (float)((double)(-yaw) * Math.PI / 180.0);
        float h = MathHelper.func_76134_b((float)g);
        float i = MathHelper.func_76126_a((float)g);
        float j = MathHelper.func_76134_b((float)f);
        float k = MathHelper.func_76126_a((float)f);
        return Vec3.func_72443_a((double)(i * j), (double)(-k), (double)(h * j));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public EntityFox createChild(EntityAgeable passiveEntity) {
        EntityFox EntityFox2 = new EntityFox(this.field_70170_p);
        EntityFox2.setType(this.field_70146_Z.nextBoolean() ? this.getFoxType() : ((EntityFox)passiveEntity).getFoxType());
        return EntityFox2;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityData) {
        entityData = super.func_110161_a(entityData);
        Type type = Type.fromBiome(this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v));
        boolean bl = false;
        if (entityData instanceof FoxData) {
            type = ((FoxData)entityData).type;
            if (((FoxData)entityData).getSpawnedCount() >= 2) {
                bl = true;
            }
        } else {
            entityData = new FoxData(type);
        }
        this.setType(type);
        if (bl) {
            this.func_70873_a(-24000);
        }
        if (this.field_70170_p instanceof WorldServer) {
            this.addTypeSpecificTasks();
        }
        this.initEquipment();
        FoxData foxData = (FoxData)entityData;
        if (foxData.canSpawnBaby() && foxData.getSpawnedCount() > 0 && this.field_70146_Z.nextFloat() <= foxData.getBabyChance()) {
            this.func_70873_a(-24000);
        }
        foxData.countSpawned();
        return entityData;
    }

    private void addTypeSpecificTasks() {
        if (this.getFoxType() == Type.RED) {
            this.field_70715_bh.func_75776_a(4, this.followChickenAndRabbitTask);
        } else {
            this.field_70715_bh.func_75776_a(6, this.followChickenAndRabbitTask);
        }
    }

    public void eat(EntityPlayer player, ItemStack stack) {
        if (this.func_70877_b(stack)) {
            this.func_85030_a(this.getEatSound(), 1.0f, 1.0f);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O * 0.85f : 0.4f;
    }

    public Type getFoxType() {
        return Type.fromId(this.field_70180_af.func_75683_a(20));
    }

    private void setType(Type type) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)type.getId()));
    }

    private List<UUID> getTrustedUuids() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        String owner = this.field_70180_af.func_75681_e(18);
        list.add(owner == null || owner.isEmpty() ? null : UUID.fromString(owner));
        String otherTrusted = this.field_70180_af.func_75681_e(19);
        list.add(otherTrusted == null || otherTrusted.isEmpty() ? null : UUID.fromString(otherTrusted));
        return list;
    }

    private void addTrustedUuid(UUID uuid) {
        if (!this.field_70180_af.func_75681_e(18).isEmpty()) {
            this.field_70180_af.func_75692_b(19, (Object)uuid.toString());
        } else {
            this.field_70180_af.func_75692_b(18, (Object)uuid.toString());
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        List<UUID> list = this.getTrustedUuids();
        NBTTagList listTag = new NBTTagList();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            listTag.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
        }
        tag.func_74782_a("Trusted", (NBTBase)listTag);
        tag.func_74757_a("Sleeping", this.func_70608_bn());
        tag.func_74778_a("Type", this.getFoxType().getKey());
        tag.func_74757_a("Sitting", this.isSitting());
        tag.func_74757_a("Crouching", this.isInSneakingPose());
        if (this.followOwner) {
            tag.func_74757_a("FollowOwner", true);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList listTag = tag.func_150295_c("Trusted", 8);
        for (int i = 0; i < listTag.func_74745_c(); ++i) {
            this.addTrustedUuid(UUID.fromString(listTag.func_150307_f(i)));
        }
        this.setSleeping(tag.func_74767_n("Sleeping"));
        this.setType(Type.byName(tag.func_74779_i("Type")));
        this.setSitting(false);
        this.setCrouching(tag.func_74767_n("Crouching"));
        if (this.field_70170_p instanceof WorldServer) {
            this.addTypeSpecificTasks();
        }
        if (tag.func_74764_b("FollowOwner")) {
            this.followOwner = tag.func_74767_n("FollowOwner");
        }
    }

    public boolean isSitting() {
        return this.getFoxFlag(1);
    }

    public void setSitting(boolean sitting) {
        this.setFoxFlag(1, sitting);
    }

    public boolean isWalking() {
        return this.getFoxFlag(64);
    }

    private void setWalking(boolean walking) {
        this.setFoxFlag(64, walking);
    }

    private boolean isAggressive() {
        return this.getFoxFlag(128);
    }

    private void setAggressive(boolean aggressive) {
        this.setFoxFlag(128, aggressive);
    }

    public boolean func_70608_bn() {
        return this.getFoxFlag(32);
    }

    private void setSleeping(boolean sleeping) {
        this.setFoxFlag(32, sleeping);
    }

    private void setFoxFlag(int mask, boolean value) {
        if (value) {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(this.field_70180_af.func_75683_a(21) | mask)));
        } else {
            this.field_70180_af.func_75692_b(21, (Object)((byte)(this.field_70180_af.func_75683_a(21) & ~mask)));
        }
    }

    private boolean getFoxFlag(int bitmask) {
        return (this.field_70180_af.func_75683_a(21) & bitmask) != 0;
    }

    public boolean canPickupItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemStack itemStack = this.func_71124_b(0);
        return itemStack == null || this.eatingTime > 0 && item instanceof ItemFood && !(itemStack.func_77973_b() instanceof ItemFood);
    }

    private void spit(ItemStack stack) {
        if (stack != null && !this.field_70170_p.field_72995_K) {
            Vec3 rv = EntityFox.getRotationVector(this.field_70125_A, this.field_70177_z);
            EntityItem EntityItem2 = new EntityItem(this.field_70170_p, this.field_70165_t + rv.field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + rv.field_72449_c, stack);
            EntityItem2.field_145804_b = 40;
            EntityItem2.func_145799_b(this.func_110124_au().toString());
            this.func_85030_a("minecraft_1.21:entity.fox.spit", 1.0f, 1.0f);
            this.field_70170_p.func_72838_d((Entity)EntityItem2);
        }
    }

    private void dropItem(ItemStack stack) {
        EntityItem EntityItem2 = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_72838_d((Entity)EntityItem2);
    }

    protected void loot(EntityItem item) {
        ItemStack itemStack = item.func_92059_d();
        if (this.canPickupItem(itemStack)) {
            int i;
            EntityPlayer dropper = (EntityPlayer)ServerEventHandler.droppedEntityItems.getIfPresent((Object)item);
            if (this.func_70877_b(itemStack) && dropper != null && dropper.func_110124_au().equals(this.getTrustedUuids().get(0))) {
                this.followOwner = true;
            }
            if ((i = itemStack.field_77994_a) > 1) {
                this.dropItem(itemStack.func_77979_a(i - 1));
            }
            this.spit(this.func_71124_b(0));
            this.func_70062_b(0, itemStack.func_77979_a(1));
            this.field_82174_bp[0] = 2.0f;
            this.func_71001_a((Entity)item, itemStack.field_77994_a);
            item.func_70106_y();
            this.eatingTime = 0;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            boolean bl = this.field_70171_ac;
            if (bl || this.func_70638_az() != null || this.field_70170_p.func_72911_I()) {
                this.stopSleeping();
            }
            if (bl || this.func_70608_bn()) {
                this.setSitting(false);
            }
            if (this.isWalking() && this.field_70170_p.field_73012_v.nextFloat() < 0.2f) {
                this.field_70170_p.func_72926_e(2001, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), this.field_70170_p.func_72805_g(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)));
            }
        }
        this.lastHeadRollProgress = this.headRollProgress;
        this.headRollProgress = this.isRollingHead() ? (this.headRollProgress += (1.0f - this.headRollProgress) * 0.4f) : (this.headRollProgress += (0.0f - this.headRollProgress) * 0.4f);
        this.lastExtraRollingHeight = this.extraRollingHeight;
        if (this.isInSneakingPose()) {
            this.extraRollingHeight += 0.2f;
            if (this.extraRollingHeight > 3.0f) {
                this.extraRollingHeight = 3.0f;
            }
        } else {
            this.extraRollingHeight = 0.0f;
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && EntityFox.getBreedingItems().contains(stack.func_77973_b());
    }

    private static List<Item> getBreedingItems() {
        if (breedingItems == null) {
            breedingItems = new ArrayList<Item>();
            if (ConfigBlocksItems.enableSweetBerryBushes) {
                breedingItems.add(ModItems.SWEET_BERRIES.get());
            }
            if (breedingItems.isEmpty()) {
                breedingItems.add(Items.field_151015_O);
            }
        }
        return breedingItems;
    }

    public boolean isChasing() {
        return this.getFoxFlag(16);
    }

    public void setChasing(boolean chasing) {
        this.setFoxFlag(16, chasing);
    }

    public boolean isFullyCrouched() {
        return this.extraRollingHeight == 3.0f;
    }

    public void setCrouching(boolean crouching) {
        this.setFoxFlag(4, crouching);
    }

    public boolean isInSneakingPose() {
        return this.getFoxFlag(4);
    }

    public void setRollingHead(boolean rollingHead) {
        this.setFoxFlag(8, rollingHead);
    }

    public boolean isRollingHead() {
        return this.getFoxFlag(8);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRoll(float tickDelta) {
        return (this.lastHeadRollProgress + tickDelta * (this.headRollProgress - this.lastHeadRollProgress)) * 0.11f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBodyRotationHeightOffset(float tickDelta) {
        return this.lastExtraRollingHeight + tickDelta * (this.extraRollingHeight - this.lastExtraRollingHeight);
    }

    public void func_70624_b(EntityLivingBase target) {
        if (this.isAggressive() && target == null) {
            this.setAggressive(false);
        }
        super.func_70624_b(target);
    }

    public float computeFallDistance(float fallDistance) {
        return fallDistance - 2.0f;
    }

    private void stopSleeping() {
        this.setSleeping(false);
    }

    public boolean func_70650_aV() {
        return true;
    }

    private void stopActions() {
        this.setRollingHead(false);
        this.setCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setAggressive(false);
        this.setWalking(false);
    }

    private boolean wantsToPickupItem() {
        return !this.func_70608_bn() && !this.isSitting() && !this.isWalking();
    }

    public void func_70642_aH() {
        String soundEvent = this.func_70639_aQ();
        if (soundEvent.equals("minecraft_1.21:entity.fox.screech")) {
            this.func_85030_a(soundEvent, 2.0f, this.func_70647_i());
        } else {
            super.func_70642_aH();
        }
    }

    protected String func_70639_aQ() {
        List list;
        if (this.func_70608_bn()) {
            return "minecraft_1.21:entity.fox.sleep";
        }
        if (!this.field_70170_p.func_72935_r() && this.field_70146_Z.nextFloat() < 0.1f && (list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0))).isEmpty()) {
            return "minecraft_1.21:entity.fox.screech";
        }
        return "minecraft_1.21:entity.fox.ambient";
    }

    protected String func_70621_aR() {
        return "minecraft_1.21:entity.fox.hurt";
    }

    protected String func_70673_aS() {
        return "minecraft_1.21:entity.fox.death";
    }

    protected String getEatSound() {
        return "minecraft_1.21:entity.fox.eat";
    }

    private boolean canTrust(UUID uuid) {
        return this.getTrustedUuids().contains(uuid);
    }

    public void func_70645_a(DamageSource source) {
        ItemStack itemStack;
        if (!this.field_70170_p.field_72995_K && (itemStack = this.func_71124_b(0)) != null) {
            this.func_70099_a(itemStack, 0.0f);
            this.func_70062_b(0, null);
        }
        super.func_70645_a(source);
    }

    public static boolean canJumpChase(EntityFox fox, EntityLivingBase chasedEntity) {
        double d = chasedEntity.field_70161_v - fox.field_70161_v;
        double e = chasedEntity.field_70165_t - fox.field_70165_t;
        double f = d / e;
        for (int j = 0; j < 6; ++j) {
            double g = f == 0.0 ? 0.0 : d * (double)((float)j / 6.0f);
            double h = f == 0.0 ? e * (double)((float)j / 6.0f) : g / f;
            for (int k = 1; k < 4; ++k) {
                if (fox.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(fox.field_70165_t + h)), MathHelper.func_76128_c((double)(fox.field_70163_u + (double)k)), MathHelper.func_76128_c((double)(fox.field_70161_v + g))).func_149688_o().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_70652_k(Entity target) {
        boolean result;
        int j;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (target instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
            target.func_70015_d(j * 4);
        }
        if (result = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            if (i > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            this.dealDamage((EntityLivingBase)this, target);
            this.onAttacking(target);
            this.func_85030_a("minecraft_1.21:entity.fox.bite", 1.0f, 1.0f);
        }
        return result;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == BlockBerryBush.SWEET_BERRY_BUSH) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public EntityLivingBase getPetOwner() {
        UUID uUID = this.getTrustedUuids().get(0);
        if (uUID != null && this.field_70170_p instanceof WorldServer) {
            return this.field_70170_p.func_152378_a(uUID);
        }
        return null;
    }

    public int getLootingLevel() {
        int lootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)this.func_70694_bm());
        return Math.max(0, lootingLevel);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (this.func_70877_b(itemStack)) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.canEat()) {
                this.eat(player, itemStack);
                this.func_146082_f(player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    public boolean canEat() {
        return !this.func_70880_s();
    }

    public ItemStack eatFood(World world, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemFood) {
            ItemFood food = (ItemFood)item;
            world.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getEatSound(), 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f, false);
            if (!world.field_72995_K && food.field_77851_ca > 0 && world.field_73012_v.nextFloat() < food.field_77858_cd) {
                this.func_70690_d(new PotionEffect(food.field_77851_ca, food.field_77850_cb * 20, food.field_77857_cc));
            }
            --stack.field_77994_a;
        }
        return stack;
    }

    public int getLookPitchSpeed() {
        return 40;
    }

    public int getBodyYawSpeed() {
        return 75;
    }

    public void dealDamage(EntityLivingBase attacker, Entity target) {
        if (target instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)attacker);
        }
        EnchantmentHelper.func_151385_b((EntityLivingBase)attacker, (Entity)target);
    }

    public void onAttacking(Entity target) {
        this.func_130011_c((Entity)(target instanceof EntityLivingBase ? target : null));
    }

    private class FoxLookHelper
    extends ExtendedEntityLookHelper {
        public FoxLookHelper() {
            super((EntityLiving)EntityFox.this);
        }

        @Override
        public void func_75649_a() {
            if (!EntityFox.this.func_70608_bn()) {
                super.func_75649_a();
            }
        }

        @Override
        protected boolean shouldStayHorizontal() {
            return !EntityFox.this.isChasing() && !EntityFox.this.isInSneakingPose() && !EntityFox.this.isRollingHead() && !EntityFox.this.isWalking();
        }
    }

    private class FoxMoveHelper
    extends EntityMoveHelper {
        public FoxMoveHelper() {
            super((EntityLiving)EntityFox.this);
        }

        public void func_75641_c() {
            if (EntityFox.this.wantsToPickupItem()) {
                super.func_75641_c();
            }
        }
    }

    private class AISwim
    extends EntityAISwimming {
        public AISwim() {
            super((EntityLiving)EntityFox.this);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityFox.this.stopActions();
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    private class AIStopWandering
    extends EntityAIBase {
        int timer;

        public AIStopWandering() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityFox.this.isWalking();
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && this.timer > 0;
        }

        public void func_75249_e() {
            this.timer = 40;
        }

        public void func_75251_c() {
            EntityFox.this.setWalking(false);
        }

        public void func_75246_d() {
            --this.timer;
        }
    }

    private class AIEscapeWhenNotAggressive
    extends EntityAIPanic {
        private int startTime;
        private static final int MAX_DURATION = 140;

        public AIEscapeWhenNotAggressive(double speed) {
            super((EntityCreature)EntityFox.this, speed);
        }

        public boolean func_75250_a() {
            return !EntityFox.this.isAggressive() && super.func_75250_a();
        }

        public void func_75249_e() {
            this.startTime = EntityFox.this.field_70173_aa;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.isTimedOut();
        }

        public void func_75251_c() {
            if (this.isTimedOut()) {
                EntityFox.this.func_70661_as().func_75499_g();
            }
            super.func_75251_c();
        }

        private boolean isTimedOut() {
            return EntityFox.this.field_70173_aa >= this.startTime + 140;
        }
    }

    private class AIMoveToHunt
    extends EntityAIBase {
        public AIMoveToHunt() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (EntityFox.this.func_70608_bn()) {
                return false;
            }
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            return livingEntity != null && livingEntity.func_70089_S() && CHICKEN_AND_RABBIT_FILTER.test(livingEntity) && EntityFox.this.func_70068_e((Entity)livingEntity) > 36.0 && !EntityFox.this.isInSneakingPose() && !EntityFox.this.isRollingHead() && !EntityFox.this.field_70703_bu;
        }

        public void func_75249_e() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setWalking(false);
        }

        public void func_75251_c() {
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            if (livingEntity != null && EntityFox.canJumpChase(EntityFox.this, livingEntity)) {
                EntityFox.this.setRollingHead(true);
                EntityFox.this.setCrouching(true);
                EntityFox.this.func_70661_as().func_75499_g();
                EntityFox.this.func_70671_ap().func_75651_a((Entity)livingEntity, (float)EntityFox.this.getBodyYawSpeed(), (float)EntityFox.this.getLookPitchSpeed());
            } else {
                EntityFox.this.setRollingHead(false);
                EntityFox.this.setCrouching(false);
            }
        }

        public void func_75246_d() {
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            EntityFox.this.func_70671_ap().func_75651_a((Entity)livingEntity, (float)EntityFox.this.getBodyYawSpeed(), (float)EntityFox.this.getLookPitchSpeed());
            if (EntityFox.this.func_70068_e((Entity)livingEntity) <= 36.0) {
                EntityFox.this.setRollingHead(true);
                EntityFox.this.setCrouching(true);
                EntityFox.this.func_70661_as().func_75499_g();
            } else {
                EntityFox.this.func_70661_as().func_75497_a((Entity)livingEntity, 1.5);
            }
        }
    }

    private class AIJumpChase
    extends EntityAIBase {
        public AIJumpChase() {
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (!EntityFox.this.isFullyCrouched()) {
                return false;
            }
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            if (livingEntity != null && livingEntity.func_70089_S()) {
                boolean bl = EntityFox.canJumpChase(EntityFox.this, livingEntity);
                if (!bl) {
                    EntityFox.this.func_70661_as().func_75497_a((Entity)livingEntity, 0.0);
                    EntityFox.this.setCrouching(false);
                    EntityFox.this.setRollingHead(false);
                }
                return bl;
            }
            return false;
        }

        public boolean func_75253_b() {
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            if (livingEntity != null && livingEntity.func_70089_S()) {
                double d = EntityFox.this.field_70181_x;
                return (d * d >= 0.05 || Math.abs(EntityFox.this.field_70125_A) >= 15.0f || !EntityFox.this.field_70122_E) && !EntityFox.this.isWalking();
            }
            return false;
        }

        public boolean func_75252_g() {
            return false;
        }

        public void func_75249_e() {
            EntityFox.this.func_70637_d(true);
            EntityFox.this.setChasing(true);
            EntityFox.this.setRollingHead(false);
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            EntityFox.this.func_70671_ap().func_75651_a((Entity)livingEntity, 60.0f, 30.0f);
            Vec3 vec3d = Vec3.func_72443_a((double)(livingEntity.field_70165_t - EntityFox.this.field_70165_t), (double)(livingEntity.field_70163_u - EntityFox.this.field_70163_u), (double)(livingEntity.field_70161_v - EntityFox.this.field_70161_v)).func_72432_b();
            EntityFox.this.field_70159_w += vec3d.field_72450_a * 0.8;
            EntityFox.this.field_70181_x += 0.9;
            EntityFox.this.field_70179_y += vec3d.field_72449_c * 0.8;
            EntityFox.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            EntityFox.this.setCrouching(false);
            EntityFox.this.extraRollingHeight = 0.0f;
            EntityFox.this.lastExtraRollingHeight = 0.0f;
            EntityFox.this.setRollingHead(false);
            EntityFox.this.setChasing(false);
        }

        public void func_75246_d() {
            EntityLivingBase livingEntity = EntityFox.this.func_70638_az();
            if (livingEntity != null) {
                EntityFox.this.func_70671_ap().func_75651_a((Entity)livingEntity, 60.0f, 30.0f);
            }
            if (!EntityFox.this.isWalking()) {
                Vec3 vec3d = Vec3.func_72443_a((double)EntityFox.this.field_70159_w, (double)EntityFox.this.field_70181_x, (double)EntityFox.this.field_70179_y);
                if (vec3d.field_72448_b * vec3d.field_72448_b < 0.03 && EntityFox.this.field_70125_A != 0.0f) {
                    EntityFox.this.field_70125_A = AIJumpChase.lerpAngle(EntityFox.this.field_70125_A, 0.0f, 0.2f);
                } else {
                    double d = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                    double e = Math.signum(-vec3d.field_72448_b) * Math.acos(d / vec3d.func_72433_c()) * 57.2957763671875;
                    EntityFox.this.field_70125_A = (float)e;
                }
            }
            if (livingEntity != null && EntityFox.this.func_70032_d((Entity)livingEntity) <= 2.0f) {
                EntityFox.this.func_70652_k((Entity)livingEntity);
            } else if (EntityFox.this.field_70125_A > 0.0f && EntityFox.this.field_70122_E && (float)EntityFox.this.field_70181_x != 0.0f && EntityFox.this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)EntityFox.this.field_70165_t), MathHelper.func_76128_c((double)EntityFox.this.field_70163_u), MathHelper.func_76128_c((double)EntityFox.this.field_70161_v)) == Blocks.field_150431_aC) {
                EntityFox.this.field_70125_A = 60.0f;
                EntityFox.this.func_70624_b(null);
                EntityFox.this.setWalking(true);
            }
        }

        private static float lerpAngle(float start, float end, float delta) {
            float f;
            for (f = end - start; f < -180.0f; f += 360.0f) {
            }
            while (f >= 180.0f) {
                f -= 360.0f;
            }
            return start + delta * f;
        }
    }

    private class AIMate
    extends EntityAIMate {
        public AIMate(double chance) {
            super((EntityAnimal)EntityFox.this, chance);
        }

        public void func_75249_e() {
            EntityFox.this.stopActions();
            ((EntityFox)this.field_75391_e).stopActions();
            super.func_75249_e();
        }

        protected void func_75388_i() {
            EntityFox babyFox = EntityFox.this.createChild((EntityAgeable)this.field_75391_e);
            if (babyFox != null) {
                EntityPlayer serverPlayerEntity = EntityFox.this.func_146083_cb();
                EntityPlayer serverPlayerEntity2 = this.field_75391_e.func_146083_cb();
                EntityPlayer serverPlayerEntity3 = serverPlayerEntity;
                if (serverPlayerEntity != null) {
                    babyFox.addTrustedUuid(serverPlayerEntity.func_110124_au());
                } else {
                    serverPlayerEntity3 = serverPlayerEntity2;
                }
                if (serverPlayerEntity2 != null && serverPlayerEntity != serverPlayerEntity2) {
                    babyFox.addTrustedUuid(serverPlayerEntity2.func_110124_au());
                }
                if (serverPlayerEntity3 != null) {
                    serverPlayerEntity3.func_71029_a(StatList.field_151186_x);
                }
                EntityFox.this.func_70873_a(6000);
                this.field_75391_e.func_70873_a(6000);
                EntityFox.this.func_70875_t();
                this.field_75391_e.func_70875_t();
                babyFox.func_70873_a(-24000);
                babyFox.func_70012_b(EntityFox.this.field_70165_t, EntityFox.this.field_70163_u, EntityFox.this.field_70161_v, 0.0f, 0.0f);
                EntityFox.this.field_70170_p.func_72838_d((Entity)babyFox);
                EntityFox.this.field_70170_p.func_72960_a((Entity)EntityFox.this, (byte)18);
                if (EntityFox.this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    EntityFox.this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(EntityFox.this.field_70170_p, EntityFox.this.field_70165_t, EntityFox.this.field_70163_u, EntityFox.this.field_70161_v, EntityFox.this.field_70146_Z.nextInt(7) + 1));
                }
            }
        }
    }

    private class AIAvoidDaylight
    extends EntityAIFleeSunExtended {
        private int timer;

        public AIAvoidDaylight(double speed) {
            super((EntityCreature)EntityFox.this, speed);
            this.timer = 100;
        }

        @Override
        public boolean func_75250_a() {
            if (!EntityFox.this.func_70608_bn() && EntityFox.this.func_70638_az() == null) {
                if (EntityFox.this.field_70170_p.func_72911_I()) {
                    return EntityFox.this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)EntityFox.this.field_70165_t), MathHelper.func_76128_c((double)EntityFox.this.field_70163_u), MathHelper.func_76128_c((double)EntityFox.this.field_70161_v)) && this.targetShadedPos();
                }
                if (this.timer > 0) {
                    --this.timer;
                    return false;
                }
                this.timer = 100;
                return EntityFox.this.field_70170_p.func_72935_r() && EntityFox.this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)EntityFox.this.field_70165_t), MathHelper.func_76128_c((double)EntityFox.this.field_70163_u), MathHelper.func_76128_c((double)EntityFox.this.field_70161_v)) && this.targetShadedPos();
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            EntityFox.this.stopActions();
            super.func_75249_e();
        }
    }

    private class AIAttack
    extends EntityAIAttackOnCollide {
        public AIAttack(double speed, boolean pauseWhenIdle) {
            super((EntityCreature)EntityFox.this, speed, pauseWhenIdle);
        }

        public void func_75249_e() {
            EntityFox.this.setRollingHead(false);
            super.func_75249_e();
        }

        public void func_75246_d() {
            this.field_75437_f = true;
            super.func_75246_d();
        }

        public boolean func_75250_a() {
            return !EntityFox.this.isSitting() && !EntityFox.this.func_70608_bn() && !EntityFox.this.isInSneakingPose() && !EntityFox.this.isWalking() && super.func_75250_a();
        }
    }

    private class AIDelayedCalmDown
    extends AICalmDown {
        private int timer;

        public AIDelayedCalmDown() {
            super(null);
            this.timer = EntityFox.this.field_70146_Z.nextInt(140);
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            if (EntityFox.this.field_70702_br == 0.0f && EntityFox.this.field_70122_E && EntityFox.this.field_70701_bs == 0.0f) {
                return this.canCalmDown() || EntityFox.this.func_70608_bn();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.canCalmDown();
        }

        private boolean canCalmDown() {
            if (this.timer > 0) {
                --this.timer;
                return false;
            }
            return EntityFox.this.field_70170_p.func_72935_r() && this.isAtFavoredLocation() && !this.canNotCalmDown();
        }

        public void func_75251_c() {
            this.timer = EntityFox.this.field_70146_Z.nextInt(140);
            EntityFox.this.stopActions();
        }

        public void func_75249_e() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setCrouching(false);
            EntityFox.this.setRollingHead(false);
            EntityFox.this.func_70637_d(false);
            EntityFox.this.setSleeping(true);
            EntityFox.this.func_70661_as().func_75499_g();
            EntityFox.this.func_70605_aq().func_75642_a(EntityFox.this.field_70165_t, EntityFox.this.field_70163_u, EntityFox.this.field_70161_v, 0.0);
        }
    }

    private static class AIFollowParent
    extends EntityAIFollowParent {
        private final EntityFox fox;

        public AIFollowParent(EntityFox fox, double speed) {
            super((EntityAnimal)fox, speed);
            this.fox = fox;
        }

        public boolean func_75250_a() {
            return !this.fox.isAggressive() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.fox.isAggressive() && super.func_75253_b();
        }

        public void func_75249_e() {
            this.fox.stopActions();
            super.func_75249_e();
        }
    }

    private class AIEatSweetBerries
    extends EntityAIBase {
        public final double speed;
        protected int cooldown;
        protected int tryingTime;
        private int safeWaitingTime;
        protected BlockPos targetPos = BlockPos.ORIGIN;
        private boolean reached;
        private final int range;
        private final int maxYDifference;
        protected int lowestY;
        protected int timer;

        public AIEatSweetBerries(double speed, int range, int maxYDifference) {
            this.speed = speed;
            this.range = range;
            this.lowestY = 0;
            this.maxYDifference = maxYDifference;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (EntityFox.this.func_70608_bn()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.getInterval((EntityCreature)EntityFox.this);
            return this.findTargetPos();
        }

        private int getInterval(EntityCreature mob) {
            return 200 + mob.func_70681_au().nextInt(200);
        }

        public boolean func_75253_b() {
            return this.tryingTime >= -this.safeWaitingTime && this.tryingTime <= 1200 && this.isTargetPos(EntityFox.this.field_70170_p, this.targetPos);
        }

        public void func_75249_e() {
            this.timer = 0;
            EntityFox.this.setSitting(false);
            this.startMovingToTarget();
            this.tryingTime = 0;
            this.safeWaitingTime = EntityFox.this.func_70681_au().nextInt(EntityFox.this.func_70681_au().nextInt(1200) + 1200) + 1200;
        }

        private void startMovingToTarget() {
            EntityFox.this.func_70661_as().func_75492_a((double)this.targetPos.getX() + 0.5, (double)(this.targetPos.getY() + 1), (double)this.targetPos.getZ() + 0.5, this.speed);
        }

        private double getDesiredSquaredDistanceToTarget() {
            return 2.0;
        }

        private BlockPos getTargetPos() {
            return this.targetPos.up();
        }

        public void func_75246_d() {
            if (this.hasReached()) {
                if (this.timer >= 40) {
                    this.eatSweetBerry();
                } else {
                    ++this.timer;
                }
            } else if (!this.hasReached() && EntityFox.this.field_70146_Z.nextFloat() < 0.05f) {
                EntityFox.this.func_85030_a("minecraft_1.21:entity.fox.sniff", 1.0f, 1.0f);
            }
            BlockPos blockPos = this.getTargetPos();
            if (EntityFox.this.func_70092_e(blockPos.getX(), blockPos.getY(), blockPos.getZ()) >= Math.pow(this.getDesiredSquaredDistanceToTarget(), 2.0)) {
                this.reached = false;
                ++this.tryingTime;
                if (this.shouldResetPath()) {
                    EntityFox.this.func_70661_as().func_75492_a((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, this.speed);
                }
            } else {
                this.reached = true;
                --this.tryingTime;
            }
        }

        private boolean shouldResetPath() {
            return this.tryingTime % 100 == 0;
        }

        private boolean hasReached() {
            return this.reached;
        }

        protected boolean findTargetPos() {
            int mobX = MathHelper.func_76128_c((double)EntityFox.this.field_70165_t);
            int mobY = MathHelper.func_76128_c((double)EntityFox.this.field_70163_u);
            int mobZ = MathHelper.func_76128_c((double)EntityFox.this.field_70161_v);
            int k = this.lowestY;
            while (k <= this.maxYDifference) {
                for (int l = 0; l < this.range; ++l) {
                    int m = 0;
                    while (m <= l) {
                        int n;
                        int n2 = n = m < l && m > -l ? l : 0;
                        while (n <= l) {
                            int bx = mobX + m;
                            int by = mobY + k - 1;
                            int bz = mobZ + n;
                            if (EntityFox.this.func_110176_b(bx, by, bz) && this.isTargetPos(EntityFox.this.field_70170_p, bx, by, bz)) {
                                this.targetPos = new BlockPos(bx, by, bz);
                                return true;
                            }
                            n = n > 0 ? -n : 1 - n;
                        }
                        m = m > 0 ? -m : 1 - m;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return false;
        }

        private boolean isTargetPos(World world, BlockPos pos) {
            return this.isTargetPos(world, pos.getX(), pos.getY(), pos.getZ());
        }

        private boolean isTargetPos(World world, int bx, int by, int bz) {
            Block block = world.func_147439_a(bx, by, bz);
            if (block instanceof BlockBerryBush) {
                return world.func_72805_g(bx, by, bz) >= 2;
            }
            return false;
        }

        private void eatSweetBerry() {
            int z;
            int y;
            int x;
            Block block;
            if (EntityFox.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && (block = EntityFox.this.field_70170_p.func_147439_a(x = this.targetPos.getX(), y = this.targetPos.getY(), z = this.targetPos.getZ())) instanceof BlockBerryBush) {
                int i = EntityFox.this.field_70170_p.func_72805_g(x, y, z);
                int j = 1 + EntityFox.this.field_70170_p.field_73012_v.nextInt(2) + (i == 3 ? 1 : 0);
                ItemStack itemStack = EntityFox.this.func_70694_bm();
                if (itemStack == null) {
                    EntityFox.this.func_70062_b(0, ModItems.SWEET_BERRIES.newItemStack());
                    --j;
                }
                if (j > 0 && !EntityFox.this.field_70170_p.field_72995_K) {
                    float f = 0.7f;
                    double d0 = (double)(EntityFox.this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(EntityFox.this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(EntityFox.this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(EntityFox.this.field_70170_p, (double)x + d0, (double)y + d1, (double)z + d2, ModItems.SWEET_BERRIES.newItemStack(j));
                    entityitem.field_145804_b = 10;
                    EntityFox.this.field_70170_p.func_72838_d((Entity)entityitem);
                }
                EntityFox.this.func_85030_a("minecraft_1.21:block.sweet_berry_bush.pick_berries", 1.0f, 1.0f);
                EntityFox.this.field_70170_p.func_72921_c(x, y, z, 1, 2);
            }
        }
    }

    private class AIPickupItem
    extends EntityAIBase {
        public AIPickupItem() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityFox.this.func_70694_bm() != null) {
                return false;
            }
            if (EntityFox.this.func_70638_az() == null && EntityFox.this.func_70643_av() == null) {
                if (!EntityFox.this.wantsToPickupItem()) {
                    return false;
                }
                if (EntityFox.this.field_70146_Z.nextInt(10) != 0) {
                    return false;
                }
                return this.canPickUpNearbyItemStack();
            }
            return false;
        }

        public void func_75246_d() {
            this.moveToNearbyItemStack(true);
        }

        public void func_75249_e() {
            this.moveToNearbyItemStack(false);
        }

        protected double getFetchSpeed() {
            return 1.2;
        }

        protected List<EntityItem> getNearbyItemStacks() {
            return EntityFox.this.field_70170_p.func_82733_a(EntityItem.class, EntityFox.this.field_70121_D.func_72314_b(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
        }

        protected void moveToNearbyItemStack(boolean onlyIfNotHoldingItem) {
            List<EntityItem> list = this.getNearbyItemStacks();
            if (!list.isEmpty()) {
                EntityItem ei = list.get(0);
                if (!onlyIfNotHoldingItem || EntityFox.this.func_70694_bm() == null) {
                    EntityFox.this.func_70661_as().func_75497_a((Entity)ei, this.getFetchSpeed());
                }
            }
        }

        protected boolean canPickUpNearbyItemStack() {
            List<EntityItem> nearbyItemStacks = this.getNearbyItemStacks();
            return !nearbyItemStacks.isEmpty() && EntityFox.this.canPickupItem(nearbyItemStacks.get(0).func_92059_d());
        }
    }

    private class AILookAtEntity
    extends EntityAIWatchClosest {
        public AILookAtEntity(EntityLiving fox, Class<? extends Entity> targetType, float range) {
            super(fox, targetType, range);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !EntityFox.this.isWalking() && !EntityFox.this.isRollingHead();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !EntityFox.this.isWalking() && !EntityFox.this.isRollingHead();
        }
    }

    private class AISitDownAndLookAround
    extends AICalmDown {
        private double lookX;
        private double lookZ;
        private int timer;
        private int counter;

        public AISitDownAndLookAround() {
            super(null);
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.isIdle() && EntityFox.this.field_70146_Z.nextFloat() < 0.02f;
        }

        private boolean isIdle() {
            return EntityFox.this.func_70777_m() == null && !EntityFox.this.func_70608_bn() && EntityFox.this.func_70638_az() == null && EntityFox.this.func_70661_as().func_75500_f() && !EntityFox.this.isChasing() && !EntityFox.this.isInSneakingPose() && EntityFox.this.func_110143_aJ() > EntityFox.this.func_110138_aP() / 4.0f && !this.canNotCalmDown();
        }

        public boolean func_75253_b() {
            return this.counter > 0 && this.isIdle();
        }

        public void func_75249_e() {
            this.chooseNewAngle();
            this.counter = 2 + EntityFox.this.field_70146_Z.nextInt(3);
            EntityFox.this.setSitting(true);
            EntityFox.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            EntityFox.this.setSitting(false);
        }

        public void func_75246_d() {
            --this.timer;
            if (this.timer <= 0) {
                --this.counter;
                this.chooseNewAngle();
            }
            EntityFox.this.func_70671_ap().func_75650_a(EntityFox.this.field_70165_t + this.lookX, EntityFox.this.field_70163_u + (double)EntityFox.this.func_70047_e(), EntityFox.this.field_70161_v + this.lookZ, (float)EntityFox.this.getBodyYawSpeed(), (float)EntityFox.this.getLookPitchSpeed());
        }

        private void chooseNewAngle() {
            double d = Math.PI * 2 * EntityFox.this.field_70146_Z.nextDouble();
            this.lookX = Math.cos(d);
            this.lookZ = Math.sin(d);
            this.timer = 80 + EntityFox.this.field_70146_Z.nextInt(20);
        }
    }

    private class AIDefendFriend
    extends EntityAICustomNearestAttackableTarget {
        private EntityLivingBase offender;
        private int lastAttackedTime;
        TargetPredicate targetPredicate;

        public AIDefendFriend(Class<? extends Entity> targetEntityClass, boolean checkVisibility, boolean checkCanNavigate, Predicate<EntityLivingBase> targetPredicate) {
            super((EntityCreature)EntityFox.this, targetEntityClass, 10, checkVisibility, checkCanNavigate, entity -> {
                EntityLivingBase livingBase;
                return entity instanceof EntityLivingBase && targetPredicate.test(livingBase = (EntityLivingBase)entity);
            });
            this.targetPredicate = new TargetPredicate().setBaseMaxDistance(this.func_111175_f()).setPredicate(targetPredicate);
            if (!checkVisibility) {
                this.targetPredicate.includeHidden();
            }
        }

        public boolean func_75250_a() {
            if (this.field_75308_c <= 0 || EntityFox.this.func_70681_au().nextInt(this.field_75308_c) == 0) {
                for (UUID uUID : EntityFox.this.getTrustedUuids()) {
                    EntityPlayer player;
                    if (uUID == null || !(EntityFox.this.field_70170_p instanceof WorldServer) || (player = EntityFox.this.field_70170_p.func_152378_a(uUID)) == null) continue;
                    EntityFox.this.friend = (EntityLivingBase)player;
                    this.offender = player.func_70643_av();
                    int i = player.func_142015_aE();
                    return i != this.lastAttackedTime && this.canTrack(this.offender, this.targetPredicate);
                }
            }
            return false;
        }

        private boolean canTrack(EntityLivingBase target, TargetPredicate targetPredicate) {
            if (target == null) {
                return false;
            }
            if (!targetPredicate.test((EntityLiving)EntityFox.this, target)) {
                return false;
            }
            if (!EntityFox.this.func_110176_b(MathHelper.func_76128_c((double)target.field_70165_t), MathHelper.func_76128_c((double)target.field_70163_u), MathHelper.func_76128_c((double)target.field_70161_v))) {
                return false;
            }
            if (this.field_75303_a) {
                if (--this.field_75302_c <= 0) {
                    this.field_75301_b = 0;
                }
                if (this.field_75301_b == 0) {
                    this.field_75301_b = this.func_75295_a(target) ? 1 : 2;
                }
                return this.field_75301_b != 2;
            }
            return true;
        }

        public void func_75249_e() {
            this.field_75309_a = this.offender;
            if (EntityFox.this.friend != null) {
                this.lastAttackedTime = EntityFox.this.friend.func_142013_aG();
            }
            EntityFox.this.func_85030_a("minecraft_1.21:entity.fox.aggro", 1.0f, 1.0f);
            EntityFox.this.setAggressive(true);
            EntityFox.this.stopSleeping();
            super.func_75249_e();
        }

        public void func_75251_c() {
            EntityFox.this.friend = null;
            super.func_75251_c();
        }
    }

    public static enum Type {
        RED(0, "red"),
        SNOW(1, "snow");

        private final int id;
        private final String key;

        private Type(int id, String key) {
            this.id = id;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String name) {
            if (Type.SNOW.key.equals(name)) {
                return SNOW;
            }
            return RED;
        }

        public static Type fromId(int id) {
            if (id == Type.SNOW.id) {
                return SNOW;
            }
            return RED;
        }

        public static Type fromBiome(BiomeGenBase bgb) {
            return bgb != null && BiomeDictionary.isBiomeOfType((BiomeGenBase)bgb, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) ? SNOW : RED;
        }
    }

    public static class FoxData
    implements IEntityLivingData {
        public final Type type;
        private int spawnCount;
        private final boolean babyAllowed;
        private final float babyChance;

        public FoxData(Type type) {
            this.type = type;
            this.babyAllowed = false;
            this.babyChance = 0.05f;
        }

        public int getSpawnedCount() {
            return this.spawnCount;
        }

        public void countSpawned() {
            ++this.spawnCount;
        }

        public boolean canSpawnBaby() {
            return this.babyAllowed;
        }

        public float getBabyChance() {
            return this.babyChance;
        }
    }

    private class WorriableEntityFilter
    implements Predicate<EntityLivingBase> {
        private WorriableEntityFilter() {
        }

        @Override
        public boolean test(EntityLivingBase livingEntity) {
            if (livingEntity instanceof EntityFox) {
                return false;
            }
            if (!(livingEntity instanceof EntityChicken || livingEntity instanceof EntityRabbit || livingEntity instanceof EntityMob)) {
                EntityPlayer player;
                if (livingEntity instanceof EntityTameable) {
                    return !((EntityTameable)livingEntity).func_70909_n();
                }
                if (livingEntity instanceof EntityPlayer && (SpectatorMode.isSpectator(player = (EntityPlayer)livingEntity) || player.field_71075_bZ.field_75098_d)) {
                    return false;
                }
                if (EntityFox.this.canTrust(livingEntity.func_110124_au())) {
                    return false;
                }
                return !livingEntity.func_70608_bn() && !livingEntity.func_70093_af();
            }
            return true;
        }
    }

    private abstract class AICalmDown
    extends EntityAIBase {
        private final TargetPredicate WORRIABLE_ENTITY_PREDICATE;

        private AICalmDown() {
            TargetPredicate targetPredicate = new TargetPredicate().setBaseMaxDistance(12.0).includeHidden();
            EntityFox entityFox2 = EntityFox.this;
            Objects.requireNonNull(entityFox2);
            this.WORRIABLE_ENTITY_PREDICATE = targetPredicate.setPredicate(entityFox2.new WorriableEntityFilter());
        }

        protected boolean isAtFavoredLocation() {
            BlockPos blockPos = new BlockPos(EntityFox.this.field_70165_t, EntityFox.this.field_70121_D.field_72337_e, EntityFox.this.field_70161_v);
            return !EntityFox.this.field_70170_p.func_72937_j(blockPos.getX(), blockPos.getY(), blockPos.getZ()) && EntityFox.this.func_70783_a(blockPos.getX(), blockPos.getY(), blockPos.getZ()) >= 0.0f;
        }

        protected boolean canNotCalmDown() {
            List list = EntityFox.this.field_70170_p.func_82733_a(EntityLivingBase.class, EntityFox.this.field_70121_D.func_72314_b(12.0, 6.0, 12.0), null);
            ArrayList<EntityLivingBase> list2 = new ArrayList<EntityLivingBase>();
            for (EntityLivingBase entityLivingBase : list) {
                if (!this.WORRIABLE_ENTITY_PREDICATE.test((EntityLiving)EntityFox.this, entityLivingBase)) continue;
                list2.add(entityLivingBase);
            }
            return !list2.isEmpty();
        }

        AICalmDown(Object arg) {
            this();
        }
    }
}

