/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ganymedes01.etfuturum.EtFuturumLootTables;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.CompostingRegistry;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import org.lwjgl.opengl.GL11;

public class ComposterHandler
extends TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public final PositionedStack composter = new PositionedStack((Object)new ItemStack(ModBlocks.COMPOSTER.get()), 75, 78, false);
    public final List<PositionedStack> outputs = new ArrayList<PositionedStack>();
    public final ItemStackMap<TableProps> props = new ItemStackMap();

    private void composeRecipeMap(ItemStack predicate) {
        int y;
        int x;
        int i;
        int size;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(CompostingRegistry.getComposts().keySet());
        WeightedRandomChestContent[] tables = EtFuturumLootTables.COMPOSTER_LOOT.getItems(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v);
        if (!(this.itemCheck(predicate, inputs) || this.tableCheck(predicate, tables) || this.composter.contains(predicate))) {
            return;
        }
        this.arecipes.clear();
        this.outputs.clear();
        this.props.clear();
        ArrayList in = new ArrayList();
        for (i = inputs.size(); i > 0; i -= size) {
            ArrayList<PositionedStack> slots = new ArrayList<PositionedStack>();
            size = Math.min(i, 36);
            x = 3;
            y = 3;
            int n = 0;
            while (n < size) {
                slots.add(this.resolveIngredient((ItemStack)inputs.remove(0), x, y));
                x += 18;
                if (++n % 9 != 0) continue;
                x = 3;
                y += 18;
            }
            in.add(slots);
        }
        int max = tables.length;
        i = 0;
        x = 168 - 18 * Math.min(max, 9) >> 1;
        y = 210 - max / 9 * 18 >> 1;
        for (WeightedRandomChestContent table : tables) {
            this.outputs.add(new PositionedStack((Object)table.field_76297_b, x, y, false));
            this.props.put(table.field_76297_b, new TableProps(table.field_76295_d, table.field_76296_e, table.field_76292_a));
            x += 18;
            if (++i != 9) continue;
            x = 168 - 18 * Math.min(max -= 9, 9) >> 1;
            y += 18;
            i = 0;
        }
        for (List list : in) {
            this.arecipes.add(new CompostedRecipe(list));
        }
    }

    private PositionedStack resolveIngredient(ItemStack stack, int x, int y) {
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            ArrayList stacks = new ArrayList();
            Item item = stack.func_77973_b();
            for (CreativeTabs tab : item.getCreativeTabs()) {
                item.func_150895_a(item, tab, stacks);
            }
            return new PositionedStack(stacks, x, y, true);
        }
        return new PositionedStack((Object)stack, x, y, false);
    }

    private boolean itemCheck(ItemStack stack, Collection<ItemStack> inputs) {
        for (ItemStack input : inputs) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)input, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean tableCheck(ItemStack stack, WeightedRandomChestContent[] table) {
        for (WeightedRandomChestContent cont : table) {
            if (!NEIClientUtils.areStacksSameType((ItemStack)cont.field_76297_b, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.composeRecipeMap(null);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (WeightedRandomChestContent item : EtFuturumLootTables.COMPOSTER_LOOT.getItems(Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v)) {
            if (!NEIClientUtils.areStacksSameType((ItemStack)item.field_76297_b, (ItemStack)result)) continue;
            this.composeRecipeMap(result);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length > 0 && ingredients[0] instanceof ItemStack) {
            if (inputId.equals(this.getOverlayIdentifier())) {
                this.composeRecipeMap(null);
            } else {
                this.loadUsageRecipes((ItemStack)ingredients[0]);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (this.itemCheck(ingredient, CompostingRegistry.getComposts().keySet()) || this.composter.contains(ingredient)) {
            this.composeRecipeMap(ingredient);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)100);
    }

    public void drawExtras(int recipe) {
        CompostedRecipe cached = (CompostedRecipe)((Object)this.arecipes.get(recipe));
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (PositionedStack stack : cached.getIngredients()) {
            int chance = CompostingRegistry.getCompostChance(stack.items[0]);
            String str = chance + "%";
            GuiDraw.drawString((String)str, (int)(stack.relx + 16 - (GuiDraw.fontRenderer.func_78256_a(str) >> 1) << 1), (int)(stack.rely + 12 << 1), (int)0xFFFFFF, (boolean)true);
        }
        GL11.glPopMatrix();
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack != null && this.props.containsKey(stack)) {
            TableProps props = this.props.get(stack);
            currenttip.add(currenttip.size() - 1, "\u00a79" + I18n.func_135052_a((String)"efr.nei.amount", (Object[])new Object[0]) + ":\u00a76 " + props.minSize + "\u00a77~\u00a76" + props.maxSize);
            currenttip.add(currenttip.size() - 1, "\u00a79" + I18n.func_135052_a((String)"efr.nei.weight", (Object[])new Object[0]) + ":\u00a76 " + props.wt);
        }
        return super.handleItemTooltip(gui, stack, currenttip, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return "etfuturum.composter";
    }

    public String getGuiTexture() {
        return "etfuturum:textures/gui/nei/board.png";
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"efr.nei.composter", (Object[])new Object[0]);
    }

    public static class TableProps {
        public final int minSize;
        public final int maxSize;
        public final int wt;

        public TableProps(int minSize, int maxSize, int wt) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.wt = wt;
        }
    }

    public class CompostedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final List<PositionedStack> inputs;

        public CompostedRecipe(List<PositionedStack> inputs) {
            super((TemplateRecipeHandler)ComposterHandler.this);
            this.inputs = inputs;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ComposterHandler.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return ComposterHandler.this.composter;
        }

        public List<PositionedStack> getOtherStacks() {
            return ComposterHandler.this.outputs;
        }
    }
}

