/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ISturdyTrackExtendable;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSturdyRail
extends BlockRail
implements ISturdyTrackExtendable {
    public IIcon straight;
    public IIcon curved;

    public BlockSturdyRail() {
        this.func_149647_a(CatwalkMod.catwalkTab);
        this.func_149672_a(CatwalkMod.catwalkSounds);
        this.func_149663_c("sturdy_rail");
        this.func_149711_c(0.7f);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (CatwalkUtil.isHoldingWrench(player) && player.func_70093_af()) {
            ArrayList drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ForgeDirection d = ForgeDirection.NORTH;
        switch (l) {
            case 0: {
                d = ForgeDirection.SOUTH;
                break;
            }
            case 1: {
                d = ForgeDirection.WEST;
                break;
            }
            case 2: {
                d = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                d = ForgeDirection.EAST;
            }
        }
        ItemStack held = player.func_71045_bC();
        if (blockSide == ForgeDirection.UP.ordinal() && held != null && held.func_77973_b() instanceof ItemBlock && ((ItemBlock)held.func_77973_b()).field_150939_a instanceof ISturdyTrackExtendable) {
            ItemBlock ib;
            if (this.func_149742_c(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ) && (ib = (ItemBlock)held.func_77973_b()).placeBlockAt(held, player, world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite().ordinal(), d.offsetX > 0 ? 1.0f : 0.5f, 0.03125f, d.offsetZ > 0 ? 1.0f : 0.5f, held.func_77960_j()) && !player.field_71075_bZ.field_75098_d) {
                --held.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, int y, int x, int z) {
        return !this.field_150053_a;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && !(world.func_147439_a(x, y - 1, z) instanceof BlockRailBase);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, int y, int x, int z) {
        return super.getRailMaxSpeed(world, cart, y, x, z);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "catwalks:blocks/sturdy_rail/normal";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta >= 6 ? this.curved : this.straight;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.straight = reg.func_94245_a("catwalks:sturdy_rail/normal");
        this.curved = reg.func_94245_a("catwalks:sturdy_rail/turned");
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            int l;
            int i1 = l = world.func_72805_g(x, y, z);
            if (this.field_150053_a) {
                i1 = l & 7;
            }
            this.func_150048_a(world, x, y, z, l, i1, block);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB blockBounds, List list, Entity entity) {
        if (entity instanceof EntityMinecart) {
            return;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x + 0), (double)(y + 0), (double)(z + 0), (double)(x + 1), (double)((float)y + 0.0625f), (double)(z + 1));
        if (blockBounds.func_72326_a(aabb)) {
            list.add(aabb);
        }
    }
}

