/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.ItemApi;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.blocks.ItemBlockRarityRare;
import tuhljin.automagy.blocks.ModBlockSpecialRender;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityInventarium;

public class BlockInventarium
extends ModBlockSpecialRender {
    public long nextNoise = 0L;

    public BlockInventarium(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockRarityRare.class);
        this.func_149676_a(0.25f, 0.32f, 0.25f, 0.75f, 0.9f, 0.75f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityInventarium();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return TileEntityInventarium.checkValidity((IBlockAccess)world, x, y, z, true);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList drops = super.getDrops(world, x, y, z, metadata, fortune);
        for (int i = 0; i < 6; ++i) {
            ItemStack shard = ItemApi.getItem((String)"itemShard", (int)4);
            drops.add(shard);
        }
        return drops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int p_149749_6_) {
        world.func_72908_a((double)x, (double)y, (double)z, "thaumcraft:craftfail", 0.75f, 1.0f);
        TileEntityInventarium te = null;
        try {
            te = (TileEntityInventarium)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null) {
            te.breakAllLinks();
        }
        super.func_149749_a(world, x, y, z, p_149749_5_, p_149749_6_);
        world.func_147459_d(x - 2, y - 1, z - 1, (Block)this);
        world.func_147459_d(x - 2, y - 1, z + 1, (Block)this);
        world.func_147459_d(x + 2, y - 1, z - 1, (Block)this);
        world.func_147459_d(x + 2, y - 1, z + 1, (Block)this);
        world.func_147459_d(x - 1, y - 1, z - 2, (Block)this);
        world.func_147459_d(x + 1, y - 1, z - 2, (Block)this);
        world.func_147459_d(x - 1, y - 1, z + 2, (Block)this);
        world.func_147459_d(x + 1, y - 1, z + 2, (Block)this);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            TileEntityInventarium te = null;
            try {
                te = (TileEntityInventarium)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                te.beginPlacementProcess();
            }
            world.func_147459_d(x - 2, y - 1, z - 1, (Block)this);
            world.func_147459_d(x - 2, y - 1, z + 1, (Block)this);
            world.func_147459_d(x + 2, y - 1, z - 1, (Block)this);
            world.func_147459_d(x + 2, y - 1, z + 1, (Block)this);
            world.func_147459_d(x - 1, y - 1, z - 2, (Block)this);
            world.func_147459_d(x + 1, y - 1, z - 2, (Block)this);
            world.func_147459_d(x - 1, y - 1, z + 2, (Block)this);
            world.func_147459_d(x + 1, y - 1, z + 2, (Block)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (rand.nextBoolean()) {
            Thaumcraft.proxy.blockRunes(world, (double)x, (double)y, (double)z, 1.1f, 0.51f, 1.0f, 12, 0.02f);
        }
        TileEntityInventarium te = (TileEntityInventarium)world.func_147438_o(x, y, z);
        for (int i = 0; i <= te.maxMemoryUsers; ++i) {
            if (rand.nextInt(6) != 0) continue;
            Thaumcraft.proxy.sparkle((float)x + rand.nextFloat(), (float)y - 1.2f, (float)z + rand.nextFloat(), rand.nextFloat() + 0.5f, 4, -0.25f);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.nextNoise) {
            this.nextNoise = currentTime + 25000L + (long)rand.nextInt(20000);
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:brain", 0.05f, world.field_73012_v.nextFloat() * 0.5f + 0.2f, false);
        }
        if (rand.nextInt(3) < 2) {
            ArrayList<BlockCoord> list = new ArrayList<BlockCoord>();
            for (int l = x - 3; l <= x + 3; ++l) {
                block2: for (int i1 = z - 3; i1 <= z + 3; ++i1) {
                    if (rand.nextInt(40) != 0) continue;
                    for (int j1 = y - 3; j1 <= y + 3; ++j1) {
                        if (!TileEntityInventarium.blockIsBookshelf((IBlockAccess)world, l, j1, i1)) continue;
                        if (!world.func_147437_c((l - x) / 2 + x, j1, (i1 - z) / 2 + z)) continue block2;
                        list.add(new BlockCoord(l, j1, i1));
                    }
                }
            }
            if (list.size() > 0) {
                Collections.shuffle(list);
                int max = rand.nextInt(1) + 1;
                int num = 1;
                for (BlockCoord bc : list) {
                    world.func_72869_a("enchantmenttable", (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, (double)((float)(bc.x - x) + rand.nextFloat()) - 0.5, (double)((float)(bc.y - y) - rand.nextFloat() - 1.0f), (double)((float)(bc.z - z) + rand.nextFloat()) - 0.5);
                    if (++num <= max) continue;
                    break;
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (ThaumcraftExtension.playerHasWandEquipped(player)) {
            if (!world.field_72995_K) {
                TileEntityInventarium te = (TileEntityInventarium)world.func_147438_o(x, y, z);
                if (TileEntityInventarium.checkValidity((IBlockAccess)world, x, y, z, false)) {
                    te.checkMaxes();
                    te.getItemList();
                    te.verifyMemoryUsers();
                    TjUtil.sendFormattedChatToPlayer(player, "Automagy.chat.inventarium.statusSlots", te.usedSlots, te.maxSlotsRead);
                    if (te.maxMemoryUsers > 0 || ThaumcraftExtension.isResearchComplete(player, "INVENTARIUM_DELIVERY")) {
                        TjUtil.sendFormattedChatToPlayer(player, "Automagy.chat.inventarium.statusNodes", te.getNumScribes(), te.maxInvNodes, te.getNumMemoryUsers(), te.maxMemoryUsers);
                    } else {
                        TjUtil.sendFormattedChatToPlayer(player, "Automagy.chat.inventarium.statusScribes", te.getNumScribes(), te.maxInvNodes);
                    }
                    te.markAsPreferredLink();
                }
            }
            return true;
        }
        return false;
    }
}

