/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.ISlotItemFilter;
import shedar.mods.ic2.nuclearcontrol.crossmod.ic2.IC2Type;

public class TileEntityAverageCounter
extends TileEntity
implements IEnergyConductor,
IWrenchable,
INetworkClientTileEntityEventListener,
IInventory,
ISlotItemFilter,
INetworkDataProvider,
INetworkUpdateListener {
    private static final int BASE_PACKET_SIZE = 32;
    protected static final int DATA_POINTS = 220;
    private boolean init;
    private ItemStack[] inventory = new ItemStack[1];
    private byte prevPowerType;
    public byte powerType = 0;
    private short prevFacing = 0;
    public short facing = 0;
    protected double[] data = new double[220];
    protected int index = 0;
    protected int updateTicker = this.tickRate = 20;
    protected int tickRate;
    protected short prevPeriod = 1;
    public short period = 1;
    protected int clientAverage = -1;
    private double lastReceivedPower = 0.0;
    public int packetSize = 32;
    private boolean addedToEnergyNet = false;

    protected void initData() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.init = true;
    }

    public short getFacing() {
        return (short)Facing.field_71588_a[this.facing];
    }

    public void setFacing(short f) {
        EnergyTileUnloadEvent event;
        if (this.addedToEnergyNet) {
            event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        this.setSide((short)Facing.field_71588_a[f]);
        this.addedToEnergyNet = false;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.addedToEnergyNet = true;
        }
    }

    private void setSide(short f) {
        this.facing = f;
        if (this.init && this.prevFacing != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = f;
    }

    private void setPeriod(short p) {
        this.period = p;
        if (this.prevPeriod != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "period");
        }
        this.prevPeriod = p;
    }

    public void setPowerType(byte p) {
        this.powerType = p;
        if (this.prevPowerType != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "powerType");
        }
        this.prevPowerType = p;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.initData();
            this.func_70296_d();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToEnergyNet) {
                EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnergyNet = true;
            }
            this.index = (this.index + 1) % 220;
            this.data[this.index] = 0.0;
            this.getAverage();
            double total = EnergyNet.instance.getTotalEnergyEmitted((TileEntity)this);
            if (IC2NuclearControl.instance.crossIc2.getType() == IC2Type.SPEIGER) {
                double realTotal = total - this.lastReceivedPower;
                this.lastReceivedPower = total;
                this.data[this.index] = realTotal;
            } else {
                this.data[this.index] = total;
            }
            this.setPowerType((byte)0);
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.facing = nbttagcompound.func_74765_d("facing");
        this.index = nbttagcompound.func_74762_e("dataIndex");
        this.updateTicker = nbttagcompound.func_74762_e("updateTicker");
        this.prevPeriod = this.period = nbttagcompound.func_74765_d("period");
        this.powerType = nbttagcompound.func_74771_c("powerType");
        for (int i = 0; i < 220; ++i) {
            this.data[i] = nbttagcompound.func_74763_f("point-" + i);
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound compound = nbttaglist.func_150305_b(i);
            byte slotNum = compound.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.inventory.length) continue;
            this.inventory[slotNum] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.func_70296_d();
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("facing") && this.prevFacing != this.facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevFacing = this.facing;
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            EnergyTileUnloadEvent event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.addedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74768_a("dataIndex", this.index);
        nbttagcompound.func_74768_a("updateTicker", this.updateTicker);
        nbttagcompound.func_74777_a("period", this.period);
        nbttagcompound.func_74774_a("powerType", this.powerType);
        for (int i = 0; i < 220; ++i) {
            nbttagcompound.func_74772_a("point-" + i, (long)this.data[i]);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(compound);
            nbttaglist.func_74742_a((NBTBase)compound);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotNum) {
        return this.inventory[slotNum];
    }

    public ItemStack func_70298_a(int slotNum, int amount) {
        if (this.inventory[slotNum] != null) {
            if (this.inventory[slotNum].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slotNum];
                this.inventory[slotNum] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack taken = this.inventory[slotNum].func_77979_a(amount);
            if (this.inventory[slotNum].field_77994_a == 0) {
                this.inventory[slotNum] = null;
            }
            this.func_70296_d();
            return taken;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        this.inventory[slotNum] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "block.RemoteThermo";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        super.func_70296_d();
        int upgradeCountTransormer = 0;
        ItemStack itemStack = this.inventory[0];
        if (itemStack != null && itemStack.func_77969_a(IC2Items.getItem((String)"transformerUpgrade"))) {
            upgradeCountTransormer = itemStack.field_77994_a;
        }
        upgradeCountTransormer = Math.min(upgradeCountTransormer, 4);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            EnergyTileUnloadEvent event;
            this.packetSize = 32 * (int)Math.pow(4.0, upgradeCountTransormer);
            if (this.addedToEnergyNet) {
                event = new EnergyTileUnloadEvent((IEnergyTile)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.addedToEnergyNet = false;
            event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.addedToEnergyNet = true;
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return direction.ordinal() != this.getFacing();
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        return itemstack.func_77969_a(IC2Items.getItem((String)"transformerUpgrade"));
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int face) {
        return this.getFacing() != face;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public List<String> getNetworkedFields() {
        Vector<String> vector = new Vector<String>(3);
        vector.add("facing");
        vector.add("period");
        vector.add("powerType");
        return vector;
    }

    public void setClientAverage(int value) {
        this.clientAverage = value;
    }

    public int getClientAverage() {
        if (this.clientAverage == -1) {
            return this.getAverage();
        }
        return this.clientAverage;
    }

    protected int getAverage() {
        int start = 220 + this.index - this.period * 20;
        double sum = 0.0;
        for (int i = 0; i < this.period * 20; ++i) {
            sum += this.data[(start + i) % 220];
        }
        this.clientAverage = (int)Math.round(sum / (double)this.period / 20.0);
        return this.clientAverage;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            for (int i = 0; i < 220; ++i) {
                this.data[i] = 0.0;
            }
            this.updateTicker = this.tickRate;
            this.index = 0;
        } else {
            this.setPeriod((short)event);
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 7);
    }

    public double getConductionLoss() {
        return 0.025;
    }

    public double getInsulationEnergyAbsorption() {
        return 16384.0;
    }

    public double getInsulationBreakdownEnergy() {
        return this.packetSize + 1;
    }

    public double getConductorBreakdownEnergy() {
        return this.packetSize + 1;
    }

    public void removeInsulation() {
    }

    public void removeConductor() {
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a, 0, 3);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 0.8f, false);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.isItemValid(slot, itemstack);
    }
}

