/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;
import org.apache.logging.log4j.Level;

public class ChunkManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static ChunkManager instance;

    public static ChunkManager getInstance() {
        if (instance == null) {
            instance = new ChunkManager();
        }
        return instance;
    }

    @SubscribeEvent
    public void entityEnteredChunk(EntityEvent.EnteringChunk event) {
        Entity entity = event.entity;
        if (entity instanceof EntityCartAnchor) {
            if (Game.isHost(entity.field_70170_p)) {
                ((EntityCartAnchor)entity).forceChunkLoading(event.newChunkX, event.newChunkZ);
            } else {
                ((EntityCartAnchor)entity).setupChunks(event.newChunkX, event.newChunkZ);
            }
        }
    }

    public Set<ChunkCoordIntPair> getChunksBetween(int xChunkA, int zChunkA, int xChunkB, int zChunkB, int max) {
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        if (xChunkA != xChunkB && zChunkA != zChunkB) {
            return chunkList;
        }
        int xStart = Math.min(xChunkA, xChunkB);
        int xEnd = Math.max(xChunkA, xChunkB);
        int zStart = Math.min(zChunkA, zChunkB);
        int zEnd = Math.max(zChunkA, zChunkB);
        for (int xx = xStart; xx <= xEnd; ++xx) {
            for (int zz = zStart; zz <= zEnd; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
                if (chunkList.size() < max) continue;
                return chunkList;
            }
        }
        return chunkList;
    }

    public Set<ChunkCoordIntPair> getChunksAround(int xChunk, int zChunk, int radius) {
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        for (int xx = xChunk - radius; xx <= xChunk + radius; ++xx) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        return chunkList;
    }

    public Set<ChunkCoordIntPair> getBufferAround(int xWorld, int zWorld, int radius) {
        int minX = xWorld - radius >> 4;
        int maxX = xWorld + radius >> 4;
        int minZ = zWorld - radius >> 4;
        int maxZ = zWorld + radius >> 4;
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        return chunkList;
    }

    private void printAnchor(String type, int x, int y, int z) {
        if (RailcraftConfig.printAnchorLocations()) {
            Game.log(Level.INFO, "{0} found at [{1}-{2}-{3}]", type, x, y, z);
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket.isPlayerTicket()) continue;
            Entity entity = ticket.getEntity();
            if (entity == null) {
                TileEntity tile;
                int x = ticket.getModData().func_74762_e("xCoord");
                int y = ticket.getModData().func_74762_e("yCoord");
                int z = ticket.getModData().func_74762_e("zCoord");
                if (y < 0 || !((tile = world.func_147438_o(x, y, z)) instanceof TileAnchorWorld)) continue;
                TileAnchorWorld anchor = (TileAnchorWorld)tile;
                anchor.forceChunkLoading(ticket);
                this.printAnchor(anchor.getName(), x, y, z);
                continue;
            }
            if (!(entity instanceof EntityCartAnchor)) continue;
            EntityCartAnchor anchor = (EntityCartAnchor)entity;
            anchor.setChunkTicket(ticket);
            anchor.forceChunkLoading(anchor.field_70176_ah, anchor.field_70164_aj);
            this.printAnchor(anchor.func_70005_c_(), (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
        }
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        HashSet<ForgeChunkManager.Ticket> adminTickets = new HashSet<ForgeChunkManager.Ticket>();
        HashSet<ForgeChunkManager.Ticket> worldTickets = new HashSet<ForgeChunkManager.Ticket>();
        HashSet<ForgeChunkManager.Ticket> cartTickets = new HashSet<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            Entity entity = ticket.getEntity();
            if (entity == null) {
                int x = ticket.getModData().func_74762_e("xCoord");
                int y = ticket.getModData().func_74762_e("yCoord");
                int z = ticket.getModData().func_74762_e("zCoord");
                String type = ticket.getModData().func_74779_i("type");
                if (y < 0) continue;
                if (type.equals(EnumMachineAlpha.ADMIN_ANCHOR.getTag())) {
                    adminTickets.add(ticket);
                    continue;
                }
                if (type.equals(EnumMachineAlpha.WORLD_ANCHOR.getTag())) {
                    worldTickets.add(ticket);
                    continue;
                }
                if (!type.isEmpty()) continue;
                worldTickets.add(ticket);
                continue;
            }
            if (!(entity instanceof EntityCartAnchor)) continue;
            cartTickets.add(ticket);
        }
        LinkedList<ForgeChunkManager.Ticket> claimedTickets = new LinkedList<ForgeChunkManager.Ticket>();
        claimedTickets.addAll(cartTickets);
        claimedTickets.addAll(adminTickets);
        claimedTickets.addAll(worldTickets);
        return claimedTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        if (RailcraftConfig.printAnchorLocations()) {
            for (ForgeChunkManager.Ticket ticket : tickets.values()) {
                Entity entity = ticket.getEntity();
                if (entity != null) continue;
                int x = ticket.getModData().func_74762_e("xCoord");
                int y = ticket.getModData().func_74762_e("yCoord");
                int z = ticket.getModData().func_74762_e("zCoord");
                String type = ticket.getModData().func_74779_i("type");
                if (y < 0) continue;
                this.printAnchor(LocalizationPlugin.translate(type + ".name"), x, y, z);
            }
        }
        return LinkedListMultimap.create();
    }
}

