/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemChargable;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSerum;
import binnie.genetics.item.ItemSerumArray;
import net.minecraft.item.ItemStack;

public class Engineering {
    public static boolean isGeneAcceptor(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IItemSerum) {
            return ((IItemSerum)stack.func_77973_b()).getCharges(stack) == 0;
        }
        return stack.func_77973_b() == Genetics.itemGenetics && (stack.func_77960_j() == GeneticsItems.EmptySerum.ordinal() || stack.func_77960_j() == GeneticsItems.EmptyGenome.ordinal());
    }

    public static boolean canAcceptGene(ItemStack stack, IGene gene) {
        if (stack.func_77973_b() instanceof ItemSerum) {
            return true;
        }
        if (stack.func_77973_b() instanceof IItemSerum) {
            return ((IItemSerum)stack.func_77973_b()).getSpeciesRoot(stack) == gene.getSpeciesRoot();
        }
        return Engineering.isGeneAcceptor(stack);
    }

    public static IGene getGene(ItemStack stack, int chromosome) {
        if (stack.func_77973_b() instanceof IItemSerum) {
            return ((IItemSerum)stack.func_77973_b()).getGene(stack, chromosome);
        }
        return null;
    }

    public static ItemStack addGene(ItemStack stack, IGene gene) {
        if (stack.func_77973_b() instanceof IItemSerum) {
            ((IItemSerum)stack.func_77973_b()).addGene(stack, gene);
        }
        if (stack.func_77973_b() == Genetics.itemGenetics && stack.func_77960_j() == GeneticsItems.EmptySerum.ordinal()) {
            return ItemSerum.create(gene);
        }
        if (stack.func_77973_b() == Genetics.itemGenetics && stack.func_77960_j() == GeneticsItems.EmptyGenome.ordinal()) {
            return ItemSerumArray.create(gene);
        }
        return stack;
    }

    public static IGene[] getGenes(ItemStack serum) {
        if (serum.func_77973_b() instanceof IItemSerum) {
            return ((IItemSerum)serum.func_77973_b()).getGenes(serum);
        }
        if (serum.func_77973_b() == Genetics.itemSequencer) {
            return new IGene[]{new SequencerItem((ItemStack)serum).gene};
        }
        return new IGene[0];
    }

    public static int getCharges(ItemStack serum) {
        return ((IItemChargable)serum.func_77973_b()).getCharges(serum);
    }
}

