/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.config;

import eu.usrv.yamcore.YAMCore;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public abstract class ConfigManager {
    private File _mainconfigDir = null;
    private File _blocksconfigDir = null;
    private String _mModCollection = "";
    private String _mModID = "";
    protected Configuration _mainConfig = null;
    protected File _mConfigBaseDirectory;
    public boolean DoDebugMessages = false;

    protected abstract void PreInit();

    protected abstract void Init();

    protected abstract void PostInit();

    public ConfigManager(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        this._mModCollection = pModCollectionDirectory;
        this._mModID = pModID;
        this._mConfigBaseDirectory = pConfigBaseDirectory;
    }

    public boolean LoadConfig() {
        try {
            this.InitConfigDirs();
            if (this._mainConfig == null) {
                return false;
            }
            this.PreInit();
            this._mainConfig.load();
            this.Init();
            this.DoDebugMessages = this._mainConfig.getBoolean("DoDebugMessages", "Debug", false, "Enable debug output to fml-client-latest.log");
            YAMCore.instance.getLogger().setDebugOutput(this.DoDebugMessages);
            this._mainConfig.save();
            this.PostInit();
            return true;
        }
        catch (Exception e) {
            YAMCore.instance.getLogger().error("Unable to init config file");
            YAMCore.instance.getLogger().DumpStack(e);
            return false;
        }
    }

    private void InitConfigDirs() {
        YAMCore.instance.getLogger().info("Checking/creating config folders");
        this._mainconfigDir = new File(String.format("%s%s%s", this._mConfigBaseDirectory, File.separator, this._mModCollection));
        if (!this._mainconfigDir.exists()) {
            YAMCore.instance.getLogger().info("Config folder not found. Creating...");
            this._mainconfigDir.mkdir();
        }
        File tRealConfigFile = new File(String.format("%s%s%s%s", this._mainconfigDir, File.separator, this._mModID, ".cfg"));
        this._mainConfig = new Configuration(tRealConfigFile);
    }
}

