/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.ConditionHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public abstract class BlockConditionHandler
extends ConditionHandler {
    public static final String PROPERTY_BLOCK = "block";
    public static final String PROPERTY_META = "meta";
    protected final Multimap<BlockMeta, String> conditions = HashMultimap.create();

    @Override
    public void parse(String id, JsonObject json) {
        int meta = ConfigHandler.getIntegerProperty(json, PROPERTY_META, Short.MAX_VALUE);
        if (meta < 0 || meta > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal meta value (" + meta + ")!");
        }
        String registryName = ConfigHandler.getStringProperty(json, PROPERTY_BLOCK, id);
        Block block = (Block)GameData.getBlockRegistry().getRaw(registryName);
        if (block == null) {
            throw new IllegalArgumentException("Could not find block " + registryName + " for condition of \"" + id + "\"!");
        }
        this.conditions.put((Object)new BlockMeta(block, meta), (Object)id);
    }

    @Override
    protected boolean isForgeEventHandler() {
        return !this.conditions.isEmpty();
    }

    protected void handleEvent(EntityPlayer player, Block block, int meta) {
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        for (String id : this.conditions.get((Object)new BlockMeta(block, meta))) {
            this.getListener().accept(id, player);
        }
        for (String id : this.conditions.get((Object)new BlockMeta(block, Short.MAX_VALUE))) {
            this.getListener().accept(id, player);
        }
    }

    public static class Interact
    extends BlockConditionHandler {
        public static final String ID = "block.interact";

        @Override
        public String getID() {
            return ID;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onInteract(PlayerInteractEvent event) {
            if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            Block block = event.world.func_147439_a(event.x, event.y, event.z);
            int meta = event.world.func_72805_g(event.x, event.y, event.z);
            this.handleEvent(event.entityPlayer, block, meta);
        }
    }

    public static class Place
    extends BlockConditionHandler {
        public static final String ID = "block.place";

        @Override
        public String getID() {
            return ID;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onBlockPlace(BlockEvent.PlaceEvent event) {
            this.handleEvent(event.player, event.block, event.blockMetadata);
        }
    }

    public static class Break
    extends BlockConditionHandler {
        public static final String ID = "block.break";

        @Override
        public String getID() {
            return ID;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onBlockBreak(BlockEvent.BreakEvent event) {
            this.handleEvent(event.getPlayer(), event.block, event.blockMetadata);
        }
    }
}

