/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.structurenbt;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.structurenbt.BlockStateConverter;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class EFRBlockStateConverter
extends BlockStateConverter {
    public static final BlockStateConverter INSTANCE = new EFRBlockStateConverter();

    @Override
    public int getMetaFromState(String blockName, Map<String, String> blockStates, ForgeDirection dir) {
        if (blockName.equals("minecraft:bone_block") && ConfigWorld.fossilBlock != null && ConfigWorld.fossilBlock.getObject() == Blocks.field_150371_ca && ConfigWorld.fossilBlock.getMeta() == 2) {
            return super.getMetaFromState("minecraft:quartz_pillar", blockStates, dir);
        }
        return super.getMetaFromState(blockName, blockStates, dir);
    }

    @Override
    public int getMetaFromStateWithSubtypeAdditions(String blockName, Map<String, String> blockStates, ForgeDirection dir) {
        String truncatedName;
        int meta = this.getMetaFromState(blockName, blockStates, dir);
        switch (truncatedName = blockName.substring(blockName.indexOf(":") + 1)) {
            case "bone_block": {
                if (ConfigWorld.fossilBlock == null) break;
                if (ConfigWorld.fossilBlock.getObject() == Blocks.field_150371_ca && ConfigWorld.fossilBlock.getMeta() == 2) {
                    return meta;
                }
                return meta + ConfigWorld.fossilBlock.getMeta();
            }
        }
        return super.getMetaFromStateWithSubtypeAdditions(blockName, blockStates, dir);
    }

    @Override
    public Block getBlockFromNamespace(String blockName, Map<String, String> blockStates) {
        String truncatedName;
        String nameToFind = truncatedName = blockName.substring(blockName.indexOf(":") + 1);
        switch (truncatedName) {
            case "dragon_head": 
            case "dragon_wall_head": {
                return Blocks.field_150350_a;
            }
        }
        switch (truncatedName) {
            case "stone": {
                return Blocks.field_150348_b;
            }
            case "bone_block": {
                if (ConfigWorld.fossilBlock == null) break;
                return ConfigWorld.fossilBlock.getObject();
            }
            case "end_stone_bricks": {
                nameToFind = "end_bricks";
                break;
            }
            case "white_banner": 
            case "orange_banner": 
            case "magenta_banner": 
            case "light_blue_banner": 
            case "yellow_banner": 
            case "lime_banner": 
            case "pink_banner": 
            case "gray_banner": 
            case "light_gray_banner": 
            case "cyan_banner": 
            case "purple_banner": 
            case "blue_banner": 
            case "brown_banner": 
            case "green_banner": 
            case "red_banner": 
            case "black_banner": 
            case "white_wall_banner": 
            case "orange_wall_banner": 
            case "magenta_wall_banner": 
            case "light_blue_wall_banner": 
            case "yellow_wall_banner": 
            case "lime_wall_banner": 
            case "pink_wall_banner": 
            case "gray_wall_banner": 
            case "light_gray_wall_banner": 
            case "cyan_wall_banner": 
            case "purple_wall_banner": 
            case "blue_wall_banner": 
            case "brown_wall_banner": 
            case "green_wall_banner": 
            case "red_wall_banner": 
            case "black_wall_banner": {
                nameToFind = "banner";
            }
        }
        Block efrBlock = GameRegistry.findBlock((String)"etfuturum", (String)nameToFind);
        if (efrBlock != null) {
            return efrBlock;
        }
        return super.getBlockFromNamespace(blockName, blockStates);
    }
}

