/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive, Category.FilterPrimitive}, anyOf={})
public final class Filter
extends ContainerNode {
    private static final boolean DEBUG = false;
    public static final String TAG = "filter";
    private static final Length DEFAULT_FILTER_COORDINATE = Unit.PERCENTAGE.valueOf(-10.0f);
    private static final Length DEFAULT_FILTER_SIZE = Unit.PERCENTAGE.valueOf(120.0f);
    private Length x;
    private Length y;
    private Length width;
    private Length height;
    private UnitType filterUnits;
    private UnitType filterPrimitiveUnits;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public boolean hasEffect() {
        return !this.children().isEmpty();
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.x = attributeNode.getLength("x", DEFAULT_FILTER_COORDINATE);
        this.y = attributeNode.getLength("y", DEFAULT_FILTER_COORDINATE);
        this.width = attributeNode.getLength("width", DEFAULT_FILTER_SIZE);
        this.height = attributeNode.getLength("height", DEFAULT_FILTER_SIZE);
        this.filterUnits = attributeNode.getEnum("filterUnits", UnitType.ObjectBoundingBox);
        this.filterPrimitiveUnits = attributeNode.getEnum("primitiveUnits", UnitType.UserSpaceOnUse);
    }

    @NotNull
    public FilterInfo createFilterInfo(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull Rectangle2D elementBounds) {
        MeasureContext measure = context.measureContext();
        Rectangle2D.Double imageBounds = this.filterUnits.computeViewBounds(measure, elementBounds, this.x, this.y, this.width, this.height);
        if (this.filterUnits == UnitType.ObjectBoundingBox) {
            imageBounds.x += elementBounds.getX();
            imageBounds.y += elementBounds.getY();
        }
        BufferedImage image = ImageUtil.createCompatibleTransparentImage(g, imageBounds.getWidth(), imageBounds.getHeight());
        Rectangle2D.Double filterRegion = new Rectangle2D.Double(-imageBounds.getX(), -imageBounds.getY(), elementBounds.getWidth(), elementBounds.getHeight());
        return new FilterInfo(g, image, imageBounds, filterRegion, elementBounds);
    }

    public void applyFilter(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull FilterInfo filterInfo) {
        ImageProducer producer = filterInfo.image.getSource();
        FilterContext filterContext = new FilterContext(filterInfo);
        ImageProducerChannel sourceChannel = new ImageProducerChannel(producer);
        filterContext.addResult(DefaultFilterChannel.SourceGraphic, (Channel)sourceChannel);
        filterContext.addResult(DefaultFilterChannel.LastResult, (Channel)sourceChannel);
        for (SVGNode sVGNode : this.children()) {
            FilterPrimitive filterPrimitive = (FilterPrimitive)sVGNode;
            Rectangle2D.Double filterPrimitiveRegion = this.filterPrimitiveUnits.computeViewBounds(context.measureContext(), filterInfo.elementBounds, filterPrimitive.x, filterPrimitive.y, filterPrimitive.width, filterPrimitive.height);
            filterInfo.imageGraphics.dispose();
            if (this.filterPrimitiveUnits == UnitType.ObjectBoundingBox) {
                filterPrimitiveRegion.x += filterInfo.elementBounds.getX();
                filterPrimitiveRegion.y += filterInfo.elementBounds.getY();
            }
            Rectangle2D.intersect(filterPrimitiveRegion, filterInfo.imageBounds, filterPrimitiveRegion);
            filterPrimitive.applyFilter(g, context, filterContext);
        }
        filterInfo.producer = Objects.requireNonNull(filterContext.getChannel((Object)DefaultFilterChannel.LastResult)).producer();
    }

    @Override
    protected boolean acceptChild(@Nullable String id, @NotNull SVGNode node) {
        return node instanceof FilterPrimitive && super.acceptChild(id, node);
    }

    public static class FilterInfo {
        @NotNull
        public final Rectangle2D imageBounds;
        public final int imageWidth;
        public final int imageHeight;
        @NotNull
        private final Rectangle2D elementBounds;
        @NotNull
        private final Graphics2D imageGraphics;
        @NotNull
        private final BufferedImage image;
        private ImageProducer producer;

        private FilterInfo(@NotNull Graphics2D g, @NotNull BufferedImage image, @NotNull Rectangle2D imageBounds, @NotNull Rectangle2D filterRegion, @NotNull Rectangle2D elementBounds) {
            this.image = image;
            this.imageBounds = imageBounds;
            this.elementBounds = elementBounds;
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
            this.imageGraphics = image.createGraphics();
            this.imageGraphics.setRenderingHints(g.getRenderingHints());
            this.imageGraphics.scale((double)image.getWidth() / imageBounds.getWidth(), (double)image.getHeight() / imageBounds.getHeight());
            this.imageGraphics.translate(filterRegion.getX(), filterRegion.getY());
        }

        @NotNull
        public Graphics2D graphics() {
            return this.imageGraphics;
        }

        @NotNull
        public Rectangle2D tile() {
            return new Rectangle2D.Double(this.imageBounds.getX() - this.elementBounds.getX(), this.imageBounds.getY() - this.elementBounds.getY(), this.imageBounds.getWidth(), this.imageBounds.getHeight());
        }

        public void blitImage(@NotNull Graphics2D g, @NotNull RenderContext context) {
            g.translate(this.imageBounds.getX(), this.imageBounds.getY());
            g.scale(this.imageBounds.getWidth() / (double)this.image.getWidth(), this.imageBounds.getHeight() / (double)this.image.getHeight());
            Image image = context.createImage(this.producer);
            g.drawImage(image, 0, 0, context.targetComponent());
        }
    }
}

