/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.delegate.TableCellRendererDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.TableConstants;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DarkTableCellRendererDelegate
extends TableCellRendererDelegate
implements TableConstants {
    private final TableCellRenderer booleanCellRenderer;

    public TableCellRenderer getBooleanCellRenderer() {
        return this.booleanCellRenderer;
    }

    public DarkTableCellRendererDelegate(TableCellRenderer renderer, TableCellRenderer booleanCellRenderer) {
        super(renderer);
        this.booleanCellRenderer = booleanCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        boolean columnLeadSelection;
        boolean booleanRenderer = this.useBooleanRenderer(table, value, column);
        boolean isRowFocus = DarkTableCellFocusBorder.isRowFocusBorder(table) && table.getSelectionModel().getLeadSelectionIndex() == row;
        boolean rowLeadSelection = table.getSelectionModel().getLeadSelectionIndex() == row;
        boolean bl = columnLeadSelection = table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == column;
        if (rowLeadSelection && !columnLeadSelection && PropertyUtil.getBooleanProperty(table, "JTable.rowFocusBorder")) {
            columnLeadSelection = true;
        }
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && rowLeadSelection && columnLeadSelection;
        boolean paintSelected = isSelected && !isLeadSelectionCell;
        Component delegateComp = this.getDelegate().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (booleanRenderer) {
            Component booleanComp = this.getBooleanRenderer().getTableCellRendererComponent(table, value, paintSelected, hasFocus, row, column);
            booleanComp.setForeground(delegateComp.getForeground());
            booleanComp.setBackground(delegateComp.getBackground());
            booleanComp.setFont(delegateComp.getFont());
            component = booleanComp;
        } else {
            component = delegateComp;
        }
        if (component instanceof JComponent) {
            this.setupBorderStyle(table, row, column, (JComponent)component, isLeadSelectionCell, isRowFocus);
        }
        CellUtil.setupTableForeground(component, table, paintSelected, row);
        CellUtil.setupTableBackground(component, table, paintSelected, row);
        return component;
    }

    public TableCellRenderer getBooleanRenderer() {
        return this.booleanCellRenderer;
    }

    protected boolean useBooleanRenderer(JTable table, Object value, int column) {
        return TableConstants.useBooleanEditorForValue(value, table, column);
    }

    public void setupBorderStyle(JTable table, int row, int column, JComponent component, boolean isLeadSelectionCell, boolean isRowFocus) {
        Border focusBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
        if ((isRowFocus || isLeadSelectionCell) && !table.isEditing()) {
            PropertyUtil.installBorder(component, focusBorder);
            if (isRowFocus) {
                component.putClientProperty("JTable.rowFocusBorder", true);
                JTableHeader header = table.getTableHeader();
                TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
                boolean forceLeft = false;
                boolean forceRight = false;
                if (draggedColumn != null) {
                    int index = DarkTableUI.viewIndexForColumn(draggedColumn, table);
                    forceLeft = column == index + 1 || column == index;
                    forceRight = column == index - 1 || column == index;
                }
                component.putClientProperty("JTable.forcePaintRight", forceRight);
                component.putClientProperty("JTable.forcePaintLeft", forceLeft);
            } else {
                component.putClientProperty("JTable.rowFocusBorder", false);
            }
        } else if (component.getBorder() == focusBorder || focusBorder.getClass().isInstance(component.getBorder())) {
            component.setBorder(UIManager.getBorder("Table.cellNoFocusBorder"));
        }
    }
}

