/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.UIManager;

public class InternalFrameMenuBar
extends JComponent {
    protected Color borderColor;
    protected JMenuBar menuBar;

    public InternalFrameMenuBar() {
        this.setBackground(UIManager.getColor("InternalFrameMenuBar.background"));
        this.borderColor = UIManager.getColor("InternalFrameMenuBar.borderColor");
    }

    public void setActiveJMenuBar(JMenuBar menuBar) {
        if (menuBar != null) {
            this.add(menuBar);
        } else if (this.menuBar != null) {
            this.remove(this.menuBar);
        }
        this.menuBar = menuBar;
        this.getParent().doLayout();
        this.doLayout();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.menuBar != null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.borderColor);
            g.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return DarkUIUtil.getPreferredSize(this.menuBar);
    }

    @Override
    public void doLayout() {
        if (this.menuBar != null) {
            this.menuBar.setBounds(0, 0, DarkUIUtil.getPreferredSize((JComponent)this.menuBar).width, this.getHeight());
            this.menuBar.doLayout();
        }
    }
}

