/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.List;
import logisticspipes.pipes.PipeFluidInsertion;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidExtractor
extends PipeFluidInsertion {
    private int[] liquidToExtract = new int[6];
    private static final int flowRate = 500;
    private static final int energyPerFlow = 5;

    public PipeFluidExtractor(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this.isNthTick(10)) {
            return;
        }
        List<AdjacentTile> connected = this.getConnectedEntities();
        for (AdjacentTile tile : connected) {
            if (!(tile.tile instanceof IFluidHandler) || !SimpleServiceLocator.pipeInformationManager.isNotAPipe(tile.tile)) continue;
            this.extractFrom((IFluidHandler)tile.tile, tile.orientation);
        }
    }

    private void extractFrom(IFluidHandler container, ForgeDirection side) {
        int i = side.ordinal();
        FluidStack contained = ((PipeFluidTransportLogistics)this.transport).getTankInfo((ForgeDirection)side)[0].fluid;
        int amountMissing = ((PipeFluidTransportLogistics)this.transport).getSideCapacity() - (contained != null ? contained.amount : 0);
        if (this.liquidToExtract[i] < Math.min(500, amountMissing) && this.useEnergy(5)) {
            int n = i;
            this.liquidToExtract[n] = this.liquidToExtract[n] + Math.min(500, amountMissing);
        }
        FluidStack extracted = container.drain(side.getOpposite(), Math.min(this.liquidToExtract[i], 500), false);
        int inserted = 0;
        if (extracted != null) {
            inserted = ((PipeFluidTransportLogistics)this.transport).fill(side, extracted, true);
            container.drain(side.getOpposite(), inserted, true);
        }
        int n = i;
        this.liquidToExtract[n] = this.liquidToExtract[n] - inserted;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("liquidToExtract", this.liquidToExtract);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.liquidToExtract = nbttagcompound.func_74759_k("liquidToExtract");
        if (this.liquidToExtract.length < 6) {
            this.liquidToExtract = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_EXTRACTOR;
    }
}

