/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.core.libmc.PRLib;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BundledUtils {
    static byte[] signal = new byte[16];

    public static byte[] getAllSignals(TMultiPart part, int side) {
        return BundledUtils.getAllSignals(part, side, 3);
    }

    public static byte[] getAllSignals(TMultiPart part, int side, int connectionMask) {
        BundledUtils.clearSignal(signal);
        for (int r = 0; r <= 3; ++r) {
            if ((connectionMask & 1 << r) == 0) continue;
            BundledUtils.addSignal(signal, BundledUtils.getCornerSignal(part, side, r));
            BundledUtils.addSignal(signal, BundledUtils.getStraightSignal(part, side, r));
            BundledUtils.addSignal(signal, BundledUtils.getInternalSignal(part, side, r));
        }
        BundledUtils.addSignal(signal, BundledUtils.getCenterSignal(part, side));
        return signal;
    }

    public static void clearSignal(byte[] sig) {
        for (int i = 0; i <= 15; ++i) {
            sig[i] = 0;
        }
    }

    public static void addSignal(byte[] dst, byte[] src) {
        if (src != null) {
            for (int i = 0; i <= 15; ++i) {
                if ((dst[i] & 0xFF) >= (src[i] & 0xFF)) continue;
                dst[i] = src[i];
            }
        }
    }

    public static byte[] getCornerSignal(TMultiPart part, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)part.tile()).offset(absDir).offset(side);
        TileMultipart t = PRLib.getMultipartTile((IBlockAccess)part.world(), (BlockCoord)pos);
        if (t != null) {
            return BundledUtils.getBundledPartSignal(t.partMap(absDir ^ 1), Rotation.rotationTo((int)(absDir ^ 1), (int)(side ^ 1)));
        }
        return null;
    }

    public static byte[] getStraightSignal(TMultiPart part, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        BlockCoord pos = new BlockCoord((TileEntity)part.tile()).offset(absDir);
        TileEntity t = part.world().func_147438_o(pos.x, pos.y, pos.z);
        if (t instanceof IBundledEmitter) {
            return BundledUtils.getBundledPartSignal(t, absDir ^ 1);
        }
        if (t instanceof TileMultipart) {
            return BundledUtils.getBundledPartSignal(((TileMultipart)t).partMap(side), (r + 2) % 4);
        }
        return null;
    }

    public static byte[] getInternalSignal(TMultiPart part, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        TMultiPart tp = part.tile().partMap(absDir);
        return BundledUtils.getBundledPartSignal(tp, Rotation.rotationTo((int)absDir, (int)side));
    }

    public static byte[] getCenterSignal(TMultiPart part, int side) {
        TMultiPart center = part.tile().partMap(6);
        if (center != part) {
            return BundledUtils.getBundledPartSignal(center, side);
        }
        return null;
    }

    public static byte[] getBundledPartSignal(Object part, int r) {
        if (part instanceof IBundledEmitter) {
            return ((IBundledEmitter)part).getBundledSignal(r);
        }
        return null;
    }
}

