/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.recipes.ResolverResult;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.EntityGrowingCrystal;
import appeng.entity.EntityIds;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemCrystalSeed
extends AEBaseItem
implements IGrowableCrystal {
    private static final int LEVEL_OFFSET = 200;
    private static final int SINGLE_OFFSET = 600;
    public static final int CERTUS = 0;
    public static final int NETHER = 600;
    public static final int FLUIX = 1200;
    public static final int FINAL_STAGE = 1800;
    private final IIcon[] certus = new IIcon[3];
    private final IIcon[] fluix = new IIcon[3];
    private final IIcon[] nether = new IIcon[3];

    public ItemCrystalSeed() {
        this.func_77627_a(true);
        this.setFeature(EnumSet.of(AEFeature.Core));
        EntityRegistry.registerModEntity(EntityGrowingCrystal.class, (String)EntityGrowingCrystal.class.getSimpleName(), (int)EntityIds.get(EntityGrowingCrystal.class), (Object)AppEng.instance(), (int)16, (int)4, (boolean)true);
    }

    @Nullable
    public static ResolverResult getResolver(int certus2) {
        ResolverResult resolver = null;
        for (ItemStack crystalSeedStack : AEApi.instance().definitions().items().crystalSeed().maybeStack(1).asSet()) {
            crystalSeedStack.func_77964_b(certus2);
            crystalSeedStack = ItemCrystalSeed.newStyle(crystalSeedStack);
            resolver = new ResolverResult("ItemCrystalSeed", crystalSeedStack.func_77960_j(), crystalSeedStack.func_77978_p());
        }
        return resolver;
    }

    private static ItemStack newStyle(ItemStack itemStack) {
        ((ItemCrystalSeed)itemStack.func_77973_b()).getProgress(itemStack);
        return itemStack;
    }

    private int getProgress(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p().func_74762_e("progress");
        }
        NBTTagCompound comp = Platform.openNbtData(is);
        int progress = is.func_77960_j();
        comp.func_74768_a("progress", progress);
        is.func_77964_b(is.func_77960_j() / 600 * 600);
        return progress;
    }

    @Override
    @Nullable
    public ItemStack triggerGrowth(ItemStack is) {
        Iterator iterator;
        int newDamage = this.getProgress(is) + 1;
        IMaterials materials = AEApi.instance().definitions().materials();
        int size = is.field_77994_a;
        if (newDamage == 600 && (iterator = materials.purifiedCertusQuartzCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)iterator.next();
            return quartzStack;
        }
        if (newDamage == 1200 && (iterator = materials.purifiedNetherQuartzCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)iterator.next();
            return quartzStack;
        }
        if (newDamage == 1800 && (iterator = materials.purifiedFluixCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)iterator.next();
            return quartzStack;
        }
        if (newDamage > 1800) {
            return null;
        }
        this.setProgress(is, newDamage);
        return is;
    }

    private void setProgress(ItemStack is, int newDamage) {
        NBTTagCompound comp = Platform.openNbtData(is);
        comp.func_74768_a("progress", newDamage);
        is.func_77964_b(is.func_77960_j() / 200 * 200);
    }

    @Override
    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(ButtonToolTips.DoesntDespawn.getLocal());
        int progress = this.getProgress(stack) % 600;
        lines.add(Math.floor((float)progress / 6.0f) + "%");
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public String func_77667_c(ItemStack is) {
        int damage = this.getProgress(is);
        if (damage < 600) {
            return this.func_77658_a() + ".Certus";
        }
        if (damage < 1200) {
            return this.func_77658_a() + ".Nether";
        }
        if (damage < 1800) {
            return this.func_77658_a() + ".Fluix";
        }
        return this.func_77658_a();
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1800;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        IIcon[] list = null;
        int damage = this.getProgress(stack);
        if (damage < 600) {
            list = this.certus;
        } else if (damage < 1200) {
            damage -= 600;
            list = this.nether;
        } else if (damage < 1800) {
            damage -= 1200;
            list = this.fluix;
        }
        if (list == null) {
            return Items.field_151045_i.func_77617_a(0);
        }
        if (damage < 200) {
            return list[0];
        }
        if (damage < 400) {
            return list[1];
        }
        return list[2];
    }

    public void func_94581_a(IIconRegister ir) {
        String preFix = "appliedenergistics2:ItemCrystalSeed.";
        this.certus[0] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Certus");
        this.certus[1] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Certus2");
        this.certus[2] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Certus3");
        this.nether[0] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Nether");
        this.nether[1] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Nether2");
        this.nether[2] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Nether3");
        this.fluix[0] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Fluix");
        this.fluix[1] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Fluix2");
        this.fluix[2] = ir.func_94245_a("appliedenergistics2:ItemCrystalSeed.Fluix3");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityGrowingCrystal egc = new EntityGrowingCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        egc.field_70159_w = location.field_70159_w;
        egc.field_70181_x = location.field_70181_x;
        egc.field_70179_y = location.field_70179_y;
        if (location instanceof EntityItem) {
            egc.field_145804_b = ((EntityItem)location).field_145804_b;
        }
        return egc;
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 0)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 600)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1200)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 200)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 800)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1400)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 400)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1000)));
        itemStacks.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1600)));
    }
}

