/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.implementations.ContainerLevelEmitter;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.parts.automation.PartLevelEmitter;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiLevelEmitter
extends GuiUpgradeable {
    private MEGuiTextField amountTextField;
    private boolean isValidText;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GuiButton setButton;
    private GuiImgButton levelMode;
    private GuiImgButton craftingMode;

    public GuiLevelEmitter(InventoryPlayer inventoryPlayer, PartLevelEmitter te) {
        super(new ContainerLevelEmitter(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.amountTextField = new MEGuiTextField(90, 12);
        this.amountTextField.x = this.field_147003_i + 39;
        this.amountTextField.y = this.field_147009_r + 44;
        this.amountTextField.setFocused(true);
        ((ContainerLevelEmitter)this.field_147002_h).setTextField(this.amountTextField);
        this.validateText();
    }

    @Override
    protected void addButtons() {
        this.levelMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.redstoneMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftingMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        int a = AEConfig.instance.levelByStackAmounts(0);
        int b = AEConfig.instance.levelByStackAmounts(1);
        int c = AEConfig.instance.levelByStackAmounts(2);
        int d = AEConfig.instance.levelByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 17, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 17, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 17, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 17, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 63, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 63, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 63, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 63, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.setButton = new GuiButton(0, this.field_147003_i + 134, this.field_147009_r + 40, 28, 20, GuiText.Set.getLocal());
        this.field_146292_n.add(this.setButton);
        this.field_146292_n.add(this.levelMode);
        this.field_146292_n.add(this.redstoneMode);
        this.field_146292_n.add(this.fuzzyMode);
        this.field_146292_n.add(this.craftingMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        boolean notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        this.amountTextField.setEnabled(notCraftingMode);
        this.setButton.field_146124_l = notCraftingMode && this.isValidText;
        this.plus1.field_146124_l = notCraftingMode;
        this.plus10.field_146124_l = notCraftingMode;
        this.plus100.field_146124_l = notCraftingMode;
        this.plus1000.field_146124_l = notCraftingMode;
        this.minus1.field_146124_l = notCraftingMode;
        this.minus10.field_146124_l = notCraftingMode;
        this.minus100.field_146124_l = notCraftingMode;
        this.minus1000.field_146124_l = notCraftingMode;
        this.levelMode.field_146124_l = notCraftingMode;
        this.redstoneMode.field_146124_l = notCraftingMode;
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        if (this.craftingMode != null) {
            this.craftingMode.set(this.cvb.getCraftingMode());
        }
        if (this.levelMode != null) {
            this.levelMode.set(((ContainerLevelEmitter)this.cvb).getLevelMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.amountTextField.drawTextBox();
    }

    @Override
    protected void handleButtonVisibility() {
        this.craftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
    }

    @Override
    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    @Override
    protected GuiText getName() {
        return GuiText.LevelEmitter;
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.setButton && this.setButton.field_146124_l) {
            try {
                String amountString = Long.toString(this.getAmountLong());
                this.amountTextField.setText(amountString);
                NetworkHandler.instance.sendToServer(new PacketValueConfig("LevelEmitter.Value", amountString));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        } else if (btn == this.craftingMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.craftingMode.getSetting(), backwards));
        } else if (btn == this.levelMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.levelMode.getSetting(), backwards));
        } else {
            boolean isMinus;
            boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
            boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
            if (isPlus || isMinus) {
                long result = this.addOrderAmount(this.getQty(btn));
                this.amountTextField.setText(Long.toString(result));
            }
        }
    }

    private long addOrderAmount(int i) {
        long resultL = this.getAmountLong();
        if (resultL == 1L && i > 1) {
            resultL = 0L;
        }
        if ((resultL += (long)i) < 1L) {
            resultL = 1L;
        }
        return resultL;
    }

    private long getAmountLong() {
        String out = this.amountTextField.getText();
        double resultD = Calculator.conversion(out);
        if (resultD <= 0.0 || Double.isNaN(resultD)) {
            return 0L;
        }
        return (long)ArithHelper.round(resultD, 0);
    }

    private void validateText() {
        String text = this.amountTextField.getText();
        double resultD = Calculator.conversion(text);
        this.isValidText = !Double.isNaN(resultD);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        boolean notCraftingMode;
        boolean bl = notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        if (notCraftingMode) {
            this.amountTextField.mouseClicked(xCoord, yCoord, btn);
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.setButton);
            } else {
                boolean typedTextbox = this.amountTextField.textboxKeyTyped(character, key);
                if (typedTextbox) {
                    this.validateText();
                } else {
                    super.func_73869_a(character, key);
                }
            }
        }
    }
}

