/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEEnergyBuffer
extends MTETieredMachineBlock {
    protected static final byte DEFAULT_OUTPUT_AMPERAGE = 4;
    protected byte aCurrentOutputAmperage = (byte)4;

    public MTEEnergyBuffer(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public MTEEnergyBuffer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Defaults 4A In/Out", "Change output Amperage with a screwdriver", "Now Portable!", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        if (side != this.getBaseMetaTileEntity().getFrontFacing()) {
            return true;
        }
        return super.allowCoverOnSide(side, coverItem);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_4A[this.mTier + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Screen_Logo)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_4A[this.mTier + 1]};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Screen_Logo)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of(TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEEnergyBuffer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 2L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 250000L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return this.aCurrentOutputAmperage;
    }

    @Override
    public long maxAmperesOut() {
        return this.aCurrentOutputAmperage;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("aCurrentOutputAmperage", this.aCurrentOutputAmperage);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("aCurrentOutputAmperage")) {
            this.aCurrentOutputAmperage = aNBT.func_74771_c("aCurrentOutputAmperage");
        }
        if (aNBT.func_74764_b("aStoredEU")) {
            this.setEUVar(aNBT.func_74763_f("aStoredEU"));
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        Logger.WARNING("Right Click on MTE by Player");
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        Logger.WARNING("MTE is Client-side");
        this.showEnergy(aPlayer.func_130014_f_(), aPlayer);
        return true;
    }

    protected void showEnergy(World worldIn, EntityPlayer playerIn) {
        long tempStorage = this.getBaseMetaTileEntity().getStoredEU();
        double c = (double)tempStorage / (double)this.maxEUStore() * 100.0;
        double roundOff = (double)Math.round(c * 100.0) / 100.0;
        GTUtility.sendChatToPlayer(playerIn, "Energy: " + GTUtility.formatNumbers(tempStorage) + " EU at " + GTValues.V[this.mTier] + "v (" + roundOff + "%)");
        GTUtility.sendChatToPlayer(playerIn, "Amperage: " + GTUtility.formatNumbers(this.maxAmperesOut()) + "A");
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String cur = GTUtility.formatNumbers(this.getBaseMetaTileEntity().getStoredEU());
        String max = GTUtility.formatNumbers(this.getBaseMetaTileEntity().getEUCapacity());
        String fmt = String.format("%%%ds", max.length());
        cur = String.format(fmt, cur);
        return new String[]{StatCollector.func_74837_a((String)"gtpp.infodata.energy_buffer.eu_stored", (Object[])new Object[]{cur}), StatCollector.func_74837_a((String)"gtpp.infodata.energy_buffer.eu_capacity", (Object[])new Object[]{max})};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return GTValues.emptyIntArray;
    }

    @Override
    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    @Override
    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    @Override
    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    @Override
    public String func_145825_b() {
        return super.func_145825_b();
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    @Override
    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        long aEU;
        if (this.aCurrentOutputAmperage != 4) {
            aNBT.func_74774_a("aCurrentOutputAmperage", this.aCurrentOutputAmperage);
        }
        if ((aEU = this.getBaseMetaTileEntity().getStoredEU()) > 0L) {
            aNBT.func_74772_a("aStoredEU", aEU);
            if (aNBT.func_74764_b("aStoredEU")) {
                Logger.WARNING("Set aStoredEU to NBT.");
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        byte aTest = (byte)(this.aCurrentOutputAmperage + 1);
        if (aTest > 16 || aTest <= 0) {
            aTest = 1;
        }
        this.aCurrentOutputAmperage = aTest;
        GTUtility.sendChatToPlayer(aPlayer, "Now handling " + this.aCurrentOutputAmperage + " Amps.");
    }
}

