/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.api.enums.Element;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.client.CustomTextureSet;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.base.foil.BaseItemFoil;
import gtPlusPlus.core.item.base.wire.BaseItemFineWire;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MaterialUtils {
    private static final Map<String, Material> mGeneratedMaterialMap = new HashMap<String, Material>();

    public static List<?> oreDictValuesForEntry(String oredictName) {
        if (OreDictionary.doesOreNameExist((String)oredictName)) {
            ArrayList oredictItemNames = OreDictionary.getOres((String)oredictName);
            return oredictItemNames;
        }
        return null;
    }

    public static Material generateMaterialFromGtENUM(Materials material) {
        return MaterialUtils.generateMaterialFromGtENUM(material, null, null);
    }

    public static Material generateMaterialFromGtENUM(Materials material, TextureSet aCustomTextures) {
        return MaterialUtils.generateMaterialFromGtENUM(material, null, aCustomTextures);
    }

    public static Material generateMaterialFromGtENUM(Materials material, short[] customRGB) {
        return MaterialUtils.generateMaterialFromGtENUM(material, customRGB, null);
    }

    public static Material generateMaterialFromGtENUM(Materials material, short[] customRGB, TextureSet aCustomTextures) {
        String aMaterialKey = MaterialUtils.getMaterialName(material).toLowerCase();
        if (mGeneratedMaterialMap.containsKey(aMaterialKey)) {
            return mGeneratedMaterialMap.get(aMaterialKey);
        }
        try {
            MaterialState materialState;
            ItemStack aDustStack;
            String name = material.mName;
            short[] rgba = customRGB == null ? material.mRGBa : customRGB;
            int melting = material.mMeltingPoint;
            short boiling = material.mBlastFurnaceTemp;
            long protons = material.getProtons();
            long neutrons = material.getNeutrons();
            boolean blastFurnace = material.mBlastFurnaceRequired;
            int radioactivity = 0;
            if (material.isRadioactive() && (radioactivity = GTUtility.getRadioactivityLevel(aDustStack = ItemUtils.getOrePrefixStack(OrePrefixes.dust, material, 1))) == 0) {
                long aProtons = material.getProtons();
                radioactivity = (int)Math.min(Math.max(aProtons / 30L, 1L), 9L);
            }
            Logger.MATERIALS("[Debug] Calculated Radiation level to be " + radioactivity + ".");
            TextureSet iconSet = null;
            iconSet = aCustomTextures == null ? (material.isRadioactive() ? CustomTextureSet.TextureSets.NUCLEAR.get() : material.mIconSet) : aCustomTextures;
            if (iconSet == null || iconSet.mSetName.toLowerCase().contains("fluid")) {
                iconSet = TextureSet.SET_METALLIC;
            }
            Logger.MATERIALS("[Debug] Calculated Texture Set to be " + iconSet.mSetName + ".");
            int durability = material.mDurability;
            boolean mGenerateCell = false;
            boolean mGenerateFluid = true;
            String chemicalFormula = StringUtils.subscript(StringUtils.sanitizeString(material.mChemicalFormula));
            Element element = material.mElement;
            if (material.mElement == Element.Pb || material.mElement == Element.Na || material.mElement == Element.Ar) {
                chemicalFormula = StringUtils.subscript(StringUtils.sanitizeString(material.mElement.name()));
            }
            Logger.MATERIALS("[Debug] Setting State of GT generated material. " + material.mDefaultLocalName);
            if (material.getMolten(1L) != null || material.getSolid(1L) != null) {
                materialState = MaterialState.SOLID;
                Logger.MATERIALS("[Debug] Molten or Solid was not null.");
                if (material.getMolten(1L) == null && material.getSolid(1L) != null) {
                    Logger.MATERIALS("[Debug] Molten is Null, Solid is not. Enabling cell generation.");
                    mGenerateCell = true;
                } else if (material.getMolten(1L) != null && material.getSolid(1L) == null) {
                    Logger.MATERIALS("[Debug] Molten is not Null, Solid is null. Not enabling cell generation.");
                }
                Logger.MATERIALS("[Debug] State set as solid.");
            } else if (material.getFluid(1L) != null) {
                Logger.MATERIALS("[Debug] State set as liquid.");
                materialState = MaterialState.LIQUID;
            } else if (material.getGas(1L) != null) {
                Logger.MATERIALS("[Debug] State set as gas.");
                materialState = MaterialState.GAS;
            } else {
                Logger.MATERIALS("[Debug] State set as solid. This material has no alternative states, so for safety we wont generate anything.");
                materialState = MaterialState.SOLID;
                mGenerateFluid = false;
            }
            if (name.toLowerCase().contains("infused")) {
                String tempname = name.substring(7);
                name = "Infused " + tempname;
            }
            if (MaterialUtils.hasValidRGBA(rgba) || element == Element.H || material == Materials.InfusedAir || material == Materials.InfusedFire || material == Materials.InfusedEarth || material == Materials.InfusedWater) {
                Material M = new Material(name, materialState, iconSet, (long)durability, rgba, melting, (int)boiling, protons, neutrons, blastFurnace, chemicalFormula, radioactivity, mGenerateCell, mGenerateFluid, new MaterialStack[0]);
                mGeneratedMaterialMap.put(aMaterialKey, M);
                return M;
            }
            Logger.DEBUG_MATERIALS("Failed to generate GT++ material instance for " + material.mName + " | Valid RGB? " + MaterialUtils.hasValidRGBA(rgba));
        }
        catch (Throwable t) {
            Logger.DEBUG_MATERIALS("Failed to generate GT++ material instance for " + material.mName);
            t.printStackTrace();
        }
        return null;
    }

    public static Material generateQuickMaterial(String materialName, MaterialState defaultState, short[] colour, int sRadioactivity) {
        String aMaterialKey = materialName.toLowerCase();
        if (mGeneratedMaterialMap.containsKey(aMaterialKey)) {
            return mGeneratedMaterialMap.get(aMaterialKey);
        }
        Material temp = new Material(materialName, defaultState, colour, 1000, 3000, 50L, 50L, false, "", sRadioactivity, new MaterialStack[0]);
        mGeneratedMaterialMap.put(aMaterialKey, temp);
        return temp;
    }

    public static boolean hasValidRGBA(short[] rgba) {
        return rgba != null && rgba.length >= 3 && rgba.length <= 4;
    }

    public static int getTierOfMaterial(double aMeltingPoint) {
        return aMeltingPoint < 1000.0 ? 0 : MathUtils.roundToClosestInt(aMeltingPoint / 1000.0);
    }

    @Deprecated
    public static int getVoltageForTier(int aTier) {
        int n;
        switch (aTier) {
            case 0: {
                n = 16;
                break;
            }
            case 1: {
                n = 30;
                break;
            }
            case 2: {
                n = 120;
                break;
            }
            case 3: {
                n = 480;
                break;
            }
            case 4: {
                n = 1920;
                break;
            }
            case 5: {
                n = 7680;
                break;
            }
            case 6: {
                n = 30720;
                break;
            }
            case 7: {
                n = 122880;
                break;
            }
            case 8: {
                n = 491520;
                break;
            }
            case 9: {
                n = 0x1E0000;
                break;
            }
            case 10: {
                n = 0x780000;
                break;
            }
            case 11: {
                n = 0x1E00000;
                break;
            }
            case 12: {
                n = 0x7800000;
                break;
            }
            case 13: {
                n = 0x1E000000;
                break;
            }
            case 14: {
                n = 0x78000000;
                break;
            }
            default: {
                n = Integer.MAX_VALUE;
            }
        }
        return n;
    }

    private static Materials getMaterialByName(String materialName) {
        for (Materials m : Materials.values()) {
            if (!MaterialUtils.getMaterialName(m).equalsIgnoreCase(materialName)) continue;
            return m;
        }
        return null;
    }

    public static String getMaterialName(Materials mat) {
        String mName = mat.mDefaultLocalName;
        if (mName == null || mName.isEmpty()) {
            mName = mat.mName;
        }
        return mName;
    }

    public static TextureSet getMostCommonTextureSet(List<Material> list) {
        Object2IntOpenHashMap counter = new Object2IntOpenHashMap();
        for (Material m : list) {
            TextureSet t = m.getTextureSet();
            if (t == null) {
                t = Materials.Gold.mIconSet;
            }
            if (t == null) continue;
            counter.put((Object)t, counter.getInt((Object)t) + 1);
        }
        return counter.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey).orElse(Materials.Gold.mIconSet);
    }

    public static Materials getMaterial(String aMaterialName, String aFallbackMaterialName) {
        Materials g = MaterialUtils.getMaterial(aMaterialName);
        if (g == null) {
            g = MaterialUtils.getMaterial(aFallbackMaterialName);
        }
        if (g == null) {
            Logger.INFO("Failed finding material '" + aMaterialName + "' & fallback '" + aFallbackMaterialName + "', returning _NULL.");
            throw new IllegalStateException();
        }
        return g;
    }

    public static Materials getMaterial(String aMaterialName) {
        Materials m = Materials.get(aMaterialName);
        if (m == Materials._NULL) {
            m = MaterialUtils.getMaterialByName(aMaterialName);
        }
        if (m == null) {
            Logger.INFO("Failed finding material '" + aMaterialName + "', returning _NULL.");
            m = Materials._NULL;
        }
        return m;
    }

    public static ArrayList<Material> getCompoundMaterialsRecursively(Material aMat) {
        return MaterialUtils.getCompoundMaterialsRecursively_Speiger(aMat);
    }

    public static ArrayList<Material> getCompoundMaterialsRecursively_Speiger(Material toSearch) {
        ArrayList<Material> resultList = new ArrayList<Material>();
        if (toSearch.getComposites().isEmpty()) {
            resultList.add(toSearch);
            return resultList;
        }
        int HARD_LIMIT = 1000;
        LinkedList<Material> toCheck = new LinkedList<Material>();
        toCheck.add(toSearch);
        for (int processed = 0; !toCheck.isEmpty() && processed < 1000; ++processed) {
            Material current = (Material)toCheck.remove();
            if (current.getComposites().isEmpty()) {
                resultList.add(current);
                continue;
            }
            for (MaterialStack entry : current.getComposites()) {
                toCheck.add(entry.getStackMaterial());
            }
        }
        return resultList;
    }

    public static void generateComponentAndAssignToAMaterial(BaseItemComponent.ComponentTypes aType, Material aMaterial) {
        MaterialUtils.generateComponentAndAssignToAMaterial(aType, aMaterial, true);
    }

    public static void generateComponentAndAssignToAMaterial(BaseItemComponent.ComponentTypes aType, Material aMaterial, boolean generateRecipes) {
        BaseItemComponent aGC = aType == BaseItemComponent.ComponentTypes.FINEWIRE ? new BaseItemFineWire(aMaterial) : (aType == BaseItemComponent.ComponentTypes.FOIL ? new BaseItemFoil(aMaterial) : new BaseItemComponent(aMaterial, aType));
        String aFormattedLangName = aType.getName();
        if (!aFormattedLangName.startsWith(" ") && aFormattedLangName.contains("@")) {
            String[] aSplit = aFormattedLangName.split("@");
            aFormattedLangName = aSplit[0] + " " + aMaterial.getLocalizedName() + " " + aSplit[1];
        }
        if (aFormattedLangName.equals(aType.getName())) {
            aFormattedLangName = aMaterial.getLocalizedName() + aFormattedLangName;
        }
        Logger.MATERIALS("[Lang] " + aGC.func_77658_a() + ".name=" + aFormattedLangName);
        aMaterial.registerComponentForMaterial(aType, new ItemStack((Item)aGC));
    }

    public static void generateSpecialDustAndAssignToAMaterial(Material aMaterial, boolean generateMixerRecipes) {
        Item[] aDusts = ItemUtils.generateSpecialUseDusts(aMaterial, false, !generateMixerRecipes);
        if (aDusts.length > 0) {
            aMaterial.registerComponentForMaterial(OrePrefixes.dust, new ItemStack(aDusts[0]));
            aMaterial.registerComponentForMaterial(OrePrefixes.dustSmall, new ItemStack(aDusts[1]));
            aMaterial.registerComponentForMaterial(OrePrefixes.dustTiny, new ItemStack(aDusts[2]));
        }
    }

    public static boolean isNullGregtechMaterial(Materials aGregtechMaterial) {
        return aGregtechMaterial == Materials._NULL || aGregtechMaterial.equals(Materials._NULL) || aGregtechMaterial.mName.equals(Materials._NULL.mName);
    }
}

