/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import bartworks.system.material.CircuitGeneration.BWMetaItems;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.config.Option;
import codechicken.nei.event.NEIRegisterHandlerInfosEvent;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.common.items.MetaGeneratedItem01;
import gregtech.common.items.MetaGeneratedItem02;
import gregtech.common.items.MetaGeneratedItem03;
import gregtech.nei.GTNEIDefaultHandler;
import gregtech.nei.GTNEIImprintHandler;
import gregtech.nei.dumper.BatchModeSupportDumper;
import gregtech.nei.dumper.InputSeparationSupportDumper;
import gregtech.nei.dumper.MaterialDumper;
import gregtech.nei.dumper.MetaItemDumper;
import gregtech.nei.dumper.MetaTileEntityDumper;
import gregtech.nei.dumper.RecipeLockingSupportDumper;
import gregtech.nei.dumper.VoidProtectionSupportDumper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class NEIGTConfig
implements IConfigureNEI {
    private static final ImmutableMap<RecipeMap<?>, Integer> RECIPE_MAP_ORDERING = ImmutableMap.builder().put(RecipeMaps.assemblylineVisualRecipes, (Object)1).put(RecipeMaps.scannerFakeRecipes, (Object)2).build();
    private static final Comparator<GTNEIDefaultHandler> RECIPE_MAP_HANDLER_COMPARATOR = Comparator.comparingInt(handler -> (Integer)RECIPE_MAP_ORDERING.getOrDefault(handler.getRecipeMap(), (Object)0));
    private static ListMultimap<RecipeCategory, RecipeMapWorkable> RECIPE_CATALYST_INDEX;
    private static GTNEIImprintHandler CAL_IMPRINT_HANDLER;
    public static boolean sIsAdded;

    private static void addHandler(TemplateRecipeHandler handler) {
        FMLInterModComms.sendRuntimeMessage((Object)GTMod.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtech@" + handler.getRecipeName() + "@" + handler.getOverlayIdentifier()));
        GuiCraftingRecipe.craftinghandlers.add(handler);
        GuiUsageRecipe.usagehandlers.add(handler);
    }

    public void loadConfig() {
        sIsAdded = false;
        this.registerHandlers();
        this.registerCatalysts();
        this.registerItemEntries();
        this.registerDumpers();
        sIsAdded = true;
    }

    private void registerHandlers() {
        RecipeCategory.ALL_RECIPE_CATEGORIES.values().stream().filter(recipeCategory -> recipeCategory.recipeMap.getFrontend().getNEIProperties().registerNEI).map(GTNEIDefaultHandler::new).sorted(RECIPE_MAP_HANDLER_COMPARATOR).forEach(NEIGTConfig::addHandler);
        GuiCraftingRecipe.craftinghandlers.add(CAL_IMPRINT_HANDLER);
        GuiUsageRecipe.usagehandlers.add(CAL_IMPRINT_HANDLER);
    }

    private void registerCatalysts() {
        for (Map.Entry entry : RECIPE_CATALYST_INDEX.asMap().entrySet()) {
            ((Collection)entry.getValue()).forEach(recipeMapWorkable -> API.addRecipeCatalyst((ItemStack)recipeMapWorkable.getStackForm(1L), (String)((RecipeCategory)entry.getKey()).unlocalizedName, (int)recipeMapWorkable.getRecipeCatalystPriority()));
        }
        API.addRecipeCatalyst((ItemStack)GTModHandler.getIC2Item("nuclearReactor", 1L, null), (String)RecipeMaps.ic2NuclearFakeRecipes.unlocalizedName);
    }

    private void registerItemEntries() {
        API.addItemListEntry((ItemStack)ItemList.VOLUMETRIC_FLASK.get(1L, new Object[0]));
    }

    private void registerDumpers() {
        API.addOption((Option)new MetaTileEntityDumper());
        API.addOption((Option)new MaterialDumper());
        API.addOption((Option)new MetaItemDumper(MetaGeneratedItem01.INSTANCE, "metaitem01"));
        API.addOption((Option)new MetaItemDumper(MetaGeneratedItem02.INSTANCE, "metaitem02"));
        API.addOption((Option)new MetaItemDumper(MetaGeneratedItem03.INSTANCE, "metaitem03"));
        API.addOption((Option)new VoidProtectionSupportDumper());
        API.addOption((Option)new InputSeparationSupportDumper());
        API.addOption((Option)new BatchModeSupportDumper());
        API.addOption((Option)new RecipeLockingSupportDumper());
    }

    @SubscribeEvent
    public void registerHandlerInfo(NEIRegisterHandlerInfosEvent event) {
        if (RECIPE_CATALYST_INDEX == null) {
            NEIGTConfig.generateRecipeCatalystIndex();
        }
        RecipeCategory.ALL_RECIPE_CATEGORIES.values().forEach(recipeCategory -> {
            HandlerInfo handlerInfo;
            HandlerInfo.Builder builder = this.createHandlerInfoBuilderTemplate((RecipeCategory)recipeCategory);
            if (recipeCategory.handlerInfoCreator != null) {
                handlerInfo = ((HandlerInfo.Builder)recipeCategory.handlerInfoCreator.apply(builder)).build();
            } else {
                RECIPE_CATALYST_INDEX.get(recipeCategory).stream().findFirst().ifPresent(catalyst -> builder.setDisplayStack(catalyst.getStackForm(1L)));
                handlerInfo = builder.build();
            }
            event.registerHandlerInfo(handlerInfo);
        });
        event.registerHandlerInfo(new HandlerInfo.Builder(CAL_IMPRINT_HANDLER.getOverlayIdentifier(), "GregTech", "gregtech").setMaxRecipesPerPage(100).setDisplayStack(BWMetaItems.getCircuitParts().getStack(0)).build());
    }

    private HandlerInfo.Builder createHandlerInfoBuilderTemplate(RecipeCategory recipeCategory) {
        return new HandlerInfo.Builder(recipeCategory.unlocalizedName, recipeCategory.ownerMod.getName(), recipeCategory.ownerMod.getModId()).setShiftY(6).setHeight(135).setMaxRecipesPerPage(2);
    }

    private static void generateRecipeCatalystIndex() {
        ImmutableListMultimap.Builder builder = new ImmutableListMultimap.Builder();
        builder.orderValuesBy(Comparator.comparing(recipeMapWorkable -> -recipeMapWorkable.getRecipeCatalystPriority()));
        for (int i = 1; i < GregTechAPI.METATILEENTITIES.length; ++i) {
            IMetaTileEntity mte = GregTechAPI.METATILEENTITIES[i];
            if (!(mte instanceof RecipeMapWorkable)) continue;
            RecipeMapWorkable recipeMapWorkable2 = (RecipeMapWorkable)((Object)mte);
            for (RecipeMap<?> recipeMap : recipeMapWorkable2.getAvailableRecipeMaps()) {
                for (RecipeCategory recipeCategory : recipeMap.getAssociatedCategories()) {
                    builder.put((Object)recipeCategory, (Object)recipeMapWorkable2);
                }
            }
        }
        RECIPE_CATALYST_INDEX = builder.build();
    }

    public String getName() {
        return "GregTech NEI Plugin";
    }

    public String getVersion() {
        return "(5.03a)";
    }

    static {
        CAL_IMPRINT_HANDLER = new GTNEIImprintHandler();
        sIsAdded = true;
    }
}

