/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.items.contents.CellConfig;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.ItemHandlerHelper;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IMEConnectable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchOutputBusME
extends MTEHatchOutputBus
implements IPowerChannelState,
IMEConnectable {
    protected static final long DEFAULT_CAPACITY = 1600L;
    protected long baseCapacity = 1600L;
    public static final String COPIED_DATA_IDENTIFIER = "outputBusME";
    protected BaseActionSource requestSource = null;
    @Nullable
    protected AENetworkProxy gridProxy = null;
    final IItemList<IAEItemStack> itemCache = AEApi.instance().storage().createItemList();
    long lastOutputTick = 0L;
    long lastInputTick = 0L;
    long tickCounter = 0L;
    boolean additionalConnection = false;
    EntityPlayer lastClickedPlayer = null;
    List<ItemStack> lockedItems = new ArrayList<ItemStack>();
    boolean hadCell = false;

    public MTEHatchOutputBusME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 3, new String[]{"Item Output for Multiblocks", "Stores directly into ME", "Can cache 1600 items by default", "Change cache size by inserting a storage cell", "Change ME connection behavior by right-clicking with wire cutter", "Partition the inserted Storage Cell to filter accepted outputs"}, 1);
    }

    public MTEHatchOutputBusME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    public List<ItemStack> getLockedItems() {
        return this.lockedItems;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchOutputBusME(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public boolean storePartial(ItemStack stack, boolean simulate) {
        if (!this.lockedItems.isEmpty()) {
            boolean isOk = false;
            for (ItemStack lockedItem : this.lockedItems) {
                if (!lockedItem.func_77969_a(stack)) continue;
                isOk = true;
                break;
            }
            if (!isOk) {
                return false;
            }
        }
        if (this.canAcceptItem() || this.lastInputTick == this.tickCounter) {
            if (!simulate) {
                this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(stack));
                this.lastInputTick = this.tickCounter;
            }
            stack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    protected long getCachedAmount() {
        long itemAmount = 0L;
        for (IAEItemStack item : this.itemCache) {
            itemAmount += item.getStackSize();
        }
        return itemAmount;
    }

    protected long getCacheCapacity() {
        ItemStack upgradeItemStack = this.mInventory[0];
        if (upgradeItemStack != null && upgradeItemStack.func_77973_b() instanceof ItemBasicStorageCell) {
            return ((ItemBasicStorageCell)upgradeItemStack.func_77973_b()).getBytesLong(upgradeItemStack) * 8L;
        }
        return this.baseCapacity;
    }

    public boolean canAcceptItem() {
        return this.getCachedAmount() < this.getCacheCapacity();
    }

    protected BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    protected void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    @Override
    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.lastClickedPlayer = aPlayer;
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).isGUIClickable()) {
            return;
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    @Override
    public boolean connectsToAllSides() {
        return this.additionalConnection;
    }

    @Override
    public void setConnectsToAllSides(boolean connects) {
        this.additionalConnection = connects;
        this.updateValidGridProxySides();
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    protected void flushCachedStack() {
        if (!this.isActive() || this.itemCache.isEmpty()) {
            return;
        }
        AENetworkProxy proxy = this.getProxy();
        try {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            for (IAEItemStack s : this.itemCache) {
                if (s.getStackSize() == 0L) continue;
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)s, (BaseActionSource)this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    s.setStackSize(rest.getStackSize());
                    continue;
                }
                s.setStackSize(0L);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.lastOutputTick = this.tickCounter;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean pushOutputInventory() {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.checkItemLock();
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.tickCounter = aTick;
            if (this.tickCounter > this.lastOutputTick + 40L) {
                this.flushCachedStack();
            }
            if (this.tickCounter % 20L == 0L) {
                this.getBaseMetaTileEntity().setActive(this.isActive());
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.updateAE2ProxyColor();
    }

    public void updateAE2ProxyColor() {
        AENetworkProxy proxy = this.getProxy();
        byte color = this.getColor();
        if (color == -1) {
            proxy.setColor(AEColor.Transparent);
        } else {
            proxy.setColor(AEColor.values()[Dyes.transformDyeIndex(color)]);
        }
        if (proxy.getNode() != null) {
            proxy.getNode().updateState();
        }
    }

    @Override
    public boolean isLocked() {
        return !this.lockedItems.isEmpty();
    }

    private void checkItemLock() {
        ItemStack upgradeItemStack = this.mInventory[0];
        if (this.hadCell && upgradeItemStack != null || !this.hadCell && upgradeItemStack == null) {
            return;
        }
        if (upgradeItemStack != null && upgradeItemStack.func_77973_b() instanceof ItemBasicStorageCell) {
            CellConfig cfg;
            this.hadCell = true;
            if (this.lockedItems.isEmpty() && !(cfg = (CellConfig)((ItemBasicStorageCell)upgradeItemStack.func_77973_b()).getConfigInventory(upgradeItemStack)).isEmpty()) {
                StringBuilder builder = new StringBuilder();
                boolean hadFilters = false;
                boolean isFirst = true;
                for (int i = 0; i < cfg.func_70302_i_(); ++i) {
                    ItemStack stack = cfg.func_70301_a(i);
                    if (stack == null) continue;
                    hadFilters = true;
                    this.lockedItems.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    if (isFirst) {
                        builder.append(stack.func_82833_r());
                        isFirst = false;
                        continue;
                    }
                    builder.append(", ").append(stack.func_82833_r());
                }
                if (hadFilters) {
                    if (this.lastClickedPlayer != null) {
                        GTUtility.sendChatToPlayer(this.lastClickedPlayer, StatCollector.func_74837_a((String)"GT5U.hatch.item.filter.enable", (Object[])new Object[]{builder}));
                    }
                    this.func_70296_d();
                }
            }
        } else {
            this.hadCell = false;
            if (!this.lockedItems.isEmpty()) {
                this.lockedItems.clear();
                this.func_70296_d();
                GTUtility.sendChatToPlayer(this.lastClickedPlayer, StatCollector.func_74838_a((String)"GT5U.hatch.item.filter.disable"));
            }
        }
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("baseCapacity")) {
            tooltip.add("Current cache capacity: " + EnumChatFormatting.YELLOW + ReadableNumberConverter.INSTANCE.toWideReadableForm(stack.field_77990_d.func_74763_f("baseCapacity")));
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.baseCapacity != 1600L) {
            aNBT.func_74772_a("baseCapacity", this.baseCapacity);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList lockedItemsTag = new NBTTagList();
        for (ItemStack stack : this.lockedItems) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            lockedItemsTag.func_74742_a((NBTBase)stackTag);
        }
        aNBT.func_74782_a("lockedItems", (NBTBase)lockedItemsTag);
        NBTTagList items = new NBTTagList();
        for (IAEItemStack s : this.itemCache) {
            if (s.getStackSize() == 0L) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("itemStack", (NBTBase)GTUtility.saveItem(s.getItemStack()));
            tag.func_74772_a("size", s.getStackSize());
            items.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        aNBT.func_74782_a("cachedItems", (NBTBase)items);
        aNBT.func_74772_a("baseCapacity", this.baseCapacity);
        aNBT.func_74757_a("hadCell", this.hadCell);
        this.getProxy().writeToNBT(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        NBTBase t;
        super.loadNBTData(aNBT);
        NBTBase lockedItemsTag = aNBT.func_74781_a("lockedItems");
        if (lockedItemsTag instanceof NBTTagList) {
            NBTTagList lockedItemsList = (NBTTagList)lockedItemsTag;
            for (int i = 0; i < lockedItemsList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = lockedItemsList.func_150305_b(i);
                this.lockedItems.add(GTUtility.loadItem(stackTag));
            }
        }
        if ((t = aNBT.func_74781_a("cachedStack")) instanceof NBTTagCompound) {
            this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GTUtility.loadItem((NBTTagCompound)t)));
        }
        if ((t = aNBT.func_74781_a("cachedItems")) instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)t;
            for (int i = 0; i < l.func_74745_c(); ++i) {
                NBTTagCompound tag = l.func_150305_b(i);
                if (!tag.func_74764_b("itemStack")) {
                    this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GTUtility.loadItem(l.func_150305_b(i))));
                    continue;
                }
                NBTTagCompound tagItemStack = tag.func_74775_l("itemStack");
                IAEItemStack s = AEApi.instance().storage().createItemStack(GTUtility.loadItem(tagItemStack));
                if (s != null) {
                    s.setStackSize(tag.func_74763_f("size"));
                    this.itemCache.add((IAEStack)s);
                    continue;
                }
                GTMod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Output Bus. This item has been voided: " + tagItemStack);
            }
        }
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        this.baseCapacity = aNBT.func_74763_f("baseCapacity");
        if (this.baseCapacity == 0L) {
            this.baseCapacity = 1600L;
        }
        this.hadCell = aNBT.func_74767_n("hadCell");
        this.getProxy().readFromNBT(aNBT);
        this.updateAE2ProxyColor();
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return COPIED_DATA_IDENTIFIER;
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", COPIED_DATA_IDENTIFIER);
        tag.func_74757_a("additionalConnection", this.additionalConnection);
        tag.func_74774_a("color", this.getColor());
        return tag;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        if (nbt == null || !COPIED_DATA_IDENTIFIER.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        this.additionalConnection = nbt.func_74767_n("additionalConnection");
        this.updateValidGridProxySides();
        byte color = nbt.func_74771_c("color");
        this.getBaseMetaTileEntity().setColorization(color);
        return true;
    }

    @Override
    public NBTTagCompound getDescriptionData() {
        NBTTagCompound tag = super.getDescriptionData();
        tag.func_74772_a("baseCapacity", this.baseCapacity);
        return tag;
    }

    @Override
    public void onDescriptionPacket(NBTTagCompound data) {
        super.onDescriptionPacket(data);
        this.baseCapacity = data.func_74763_f("baseCapacity");
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("cacheCapacity", this.getCacheCapacity());
        tag.func_74768_a("stackCount", this.itemCache.size());
        IAEItemStack[] stacks = (IAEItemStack[])this.itemCache.toArray((IAEStack[])new IAEItemStack[0]);
        Arrays.sort(stacks, Comparator.comparingLong(IAEStack::getStackSize).reversed());
        if (stacks.length > 10) {
            stacks = Arrays.copyOf(stacks, 10);
        }
        NBTTagList tagList = new NBTTagList();
        tag.func_74782_a("stacks", (NBTBase)tagList);
        for (IAEItemStack stack : stacks) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.writeToNBT(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getWailaBody(ItemStack itemStack, List<String> ss, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, ss, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        ss.add(String.format("Item cache capacity: %s%s%s", EnumChatFormatting.GOLD, GTUtility.formatNumbers(tag.func_74763_f("cacheCapacity")), EnumChatFormatting.RESET));
        if (!GuiScreen.func_146272_n()) {
            ss.add("Hold Shift for more info");
            return;
        }
        NBTTagList stacks = tag.func_150295_c("stacks", 10);
        int stackCount = tag.func_74762_e("stackCount");
        if (stackCount == 0) {
            ss.add("This bus has no cached stacks");
        } else {
            ss.add(String.format("The bus contains %s%d%s cached stack%s: ", EnumChatFormatting.GOLD, stackCount, EnumChatFormatting.RESET, stackCount > 1 ? "s" : ""));
            for (int i = 0; i < stacks.func_74745_c(); ++i) {
                IAEItemStack stack = AEItemStack.loadItemStackFromNBT((NBTTagCompound)stacks.func_150305_b(i));
                ss.add(String.format("%s: %s%s%s", stack.getItemStack().func_82833_r(), EnumChatFormatting.GOLD, GTUtility.formatNumbers(stack.getStackSize()), EnumChatFormatting.RESET));
            }
            if (stackCount > stacks.func_74745_c()) {
                ss.add(EnumChatFormatting.ITALIC + "And " + (stackCount - stacks.func_74745_c()) + " more...");
            }
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(this.getProxy() != null && this.getProxy().isActive() ? StatCollector.func_74838_a((String)"GT5U.infodata.hatch.crafting_input_me.bus.online") : StatCollector.func_74837_a((String)"GT5U.infodata.hatch.crafting_input_me.bus.offline", (Object[])new Object[]{this.getAEDiagnostics()}));
        ss.add(StatCollector.func_74837_a((String)"GT5U.infodata.hatch.output_bus_me.cache_capacity", (Object[])new Object[]{EnumChatFormatting.GOLD + GTUtility.formatNumbers(this.getCacheCapacity()) + EnumChatFormatting.RESET}));
        if (this.itemCache.isEmpty()) {
            ss.add(StatCollector.func_74838_a((String)"GT5U.infodata.hatch.output_bus_me.empty"));
        } else {
            ss.add(StatCollector.func_74837_a((String)"GT5U.infodata.hatch.output_bus_me.contains", (Object[])new Object[]{this.itemCache.size()}));
            int counter = 0;
            for (IAEItemStack s : this.itemCache) {
                ss.add(s.getItem().func_77653_i(s.getItemStack()) + ": " + EnumChatFormatting.GOLD + GTUtility.formatNumbers(s.getStackSize()) + EnumChatFormatting.RESET);
                if (++counter <= 100) continue;
                break;
            }
        }
        return ss.toArray(new String[this.itemCache.size() + 2]);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
    }

    @Override
    public boolean acceptsItemLock() {
        return false;
    }
}

