/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import bartworks.util.log.DebugLog;
import bwcrossmod.thaumcraft.util.ThaumcraftHandler;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TCAspects;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class AspectLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!Mods.Thaumcraft.isModLoaded()) {
            return;
        }
        for (OrePrefixes enabledOrePrefixes : WerkstoffLoader.ENABLED_ORE_PREFIXES) {
            if (!werkstoff.hasItemType(enabledOrePrefixes)) continue;
            if (enabledOrePrefixes.mMaterialAmount >= 3628800L || enabledOrePrefixes == OrePrefixes.ore) {
                DebugLog.log("OrePrefix: " + enabledOrePrefixes.name() + " mMaterialAmount: " + enabledOrePrefixes.mMaterialAmount / 3628800L);
                if (!Objects.nonNull(WerkstoffLoader.items.get((Object)enabledOrePrefixes))) continue;
                ThaumcraftHandler.AspectAdder.addAspectViaBW(werkstoff.get(enabledOrePrefixes), werkstoff.getTCAspects(enabledOrePrefixes == OrePrefixes.ore ? 1 : (int)(enabledOrePrefixes.mMaterialAmount / 3628800L)));
                continue;
            }
            if (enabledOrePrefixes.mMaterialAmount < 0L || !Objects.nonNull(WerkstoffLoader.items.get((Object)enabledOrePrefixes))) continue;
            ThaumcraftHandler.AspectAdder.addAspectViaBW(werkstoff.get(enabledOrePrefixes), Pair.of((Object)TCAspects.PERDITIO.mAspect, (Object)1));
        }
    }
}

