/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import codechicken.multipart.MultipartHelper;
import codechicken.multipart.TileMultipart;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.AbstractBuildable;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMConfig;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import com.recursive_pineapple.matter_manipulator.mixin.BlockCaptureDrops;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IIC2Enet;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;

public class PendingMove
extends AbstractBuildable {
    private List<Pair<Location, Location>> moves = null;

    public PendingMove(EntityPlayer player, MMState state, ItemMatterManipulator.ManipulatorTier tier) {
        super(player, state, tier);
    }

    @Override
    public void tryPlaceBlocks(ItemStack stack, EntityPlayer player) {
        this.resetWarnings();
        this.refillPower(stack);
        if (this.moves == null) {
            this.initMoves();
        }
        World world = player.field_70170_p;
        BlockSpec source = new BlockSpec();
        BlockSpec target = new BlockSpec();
        int ops = 0;
        ListIterator<Pair<Location, Location>> iter = this.moves.listIterator(this.moves.size());
        ArrayList<Pair<Location, Location>> shuffled = new ArrayList<Pair<Location, Location>>();
        while (ops < this.tier.placeSpeed && iter.hasPrevious()) {
            Pair<Location, Location> move = iter.previous();
            Location s = (Location)move.left();
            Location d = (Location)move.right();
            if (!this.isEditable(world, s.x, s.y, s.z) || !this.isEditable(world, d.x, d.y, d.z)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_protected_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            BlockSpec.fromBlock(source, world, s.x, s.y, s.z);
            if (source.isAir()) {
                iter.remove();
                continue;
            }
            if (source.getBlock().func_149712_f(world, s.x, s.y, s.z) < 0.0f) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_invulnerable_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            BlockSpec.fromBlock(target, world, d.x, d.y, d.z);
            switch (this.state.config.removeMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    boolean bl = target.getBlock().isAir((IBlockAccess)world, d.x, d.y, d.z);
                    break;
                }
                case REPLACEABLE: {
                    boolean bl = target.getBlock().isReplaceable((IBlockAccess)world, d.x, d.y, d.z);
                    break;
                }
                case ALL: {
                    boolean canPlace;
                    boolean bl = canPlace = true;
                }
            }
            if (!(canPlace &= target.getBlock().func_149712_f(world, d.x, d.y, d.z) >= 0.0f)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_blocked_block", (Object[])new Object[]{d.x, d.y, d.z, source.getDisplayName()}));
                iter.remove();
                continue;
            }
            if (!target.getBlock().isAir((IBlockAccess)world, d.x, d.y, d.z)) {
                if (!this.tryConsumePower(stack, world, d.x, d.y, d.z, target)) {
                    MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                    break;
                }
                this.removeBlock(world, d.x, d.y, d.z, target);
            }
            if (!source.getBlock().func_149742_c(world, d.x, d.y, d.z)) {
                shuffled.add(move);
                iter.remove();
                continue;
            }
            if (!this.tryConsumePower(stack, world, s.x, s.y, s.z, source)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                break;
            }
            if (!PendingMove.moveBlock(world, s, source, d, target)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_move_block", (Object[])new Object[]{s.x, s.y, s.z, source.getDisplayName()}));
            }
            this.playSound(world, s.x, s.y, s.z, SoundResource.MOB_ENDERMEN_PORTAL);
            this.playSound(world, d.x, d.y, d.z, SoundResource.MOB_ENDERMEN_PORTAL);
            iter.remove();
            ++ops;
        }
        this.moves.addAll(shuffled);
        this.playSounds();
        this.actuallyGivePlayerStuff();
        if (ops > 0) {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.process_move", (Object[])new Object[]{ops, this.moves.size()}));
        } else {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.finished_move"));
        }
    }

    @Override
    public void onStopped() {
    }

    private void initMoves() {
        this.moves = new ArrayList<Pair<Location, Location>>();
        Location startA = this.state.config.coordA;
        Location startB = this.state.config.coordB;
        Location dest = this.state.config.coordC;
        MMConfig.VoxelAABB cut = new MMConfig.VoxelAABB(startA.toVec(), startB.toVec());
        MMConfig.VoxelAABB paste = cut.clone().moveOrigin(dest.toVec());
        if (cut.toBoundingBox().func_72326_a(paste.toBoundingBox())) {
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74838_a((String)"mm.info.error.move_overlapping"));
            return;
        }
        int x1 = startA.x;
        int y1 = startA.y;
        int z1 = startA.z;
        int x2 = startB.x;
        int y2 = startB.y;
        int z2 = startB.z;
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        int worldId = startA.worldId;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int dX = x - x1;
                    int dY = y - y1;
                    int dZ = z - z1;
                    this.moves.add((Pair<Location, Location>)Pair.of((Object)new Location(worldId, x, y, z), (Object)new Location(worldId, dest.x + dX, dest.y + dY, dest.z + dZ)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveBlock(World world, Location s, BlockSpec spec1, Location d, BlockSpec spec2) {
        World worldS = world.field_73011_w.field_76574_g == s.worldId ? world : s.getWorld();
        int sx = s.x;
        int sy = s.y;
        int sz = s.z;
        World worldD = world.field_73011_w.field_76574_g == d.worldId ? world : d.getWorld();
        int dx = d.x;
        int dy = d.y;
        int dz = d.z;
        Block blockS = worldS.func_147439_a(sx, sy, sz);
        Block blockD = worldD.func_147439_a(dx, dy, dz);
        if (blockS.equals(Blocks.field_150350_a) && blockD.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (Mods.BloodMagic.isModLoaded() && !PendingMove.allowTelepose(worldS, worldD, s, spec1, d, spec2)) {
            return false;
        }
        BlockMover<?> source = PendingMove.getBlockMover(worldS, sx, sy, sz);
        BlockMover<?> dest = PendingMove.getBlockMover(worldD, dx, dy, dz);
        try {
            BlockCaptureDrops.captureDrops(worldS);
            if (worldS != worldD) {
                BlockCaptureDrops.captureDrops(worldD);
            }
            Object sourceState = source.remove(worldS, sx, sy, sz);
            Object destState = dest.remove(worldD, dx, dy, dz);
            source.place(worldD, dx, dy, dz, sourceState);
            dest.place(worldS, sx, sy, sz, destState);
        }
        finally {
            BlockCaptureDrops.stopCapturingDrops(worldS);
            if (worldS != worldD) {
                BlockCaptureDrops.stopCapturingDrops(worldD);
            }
        }
        return true;
    }

    @Optional(value={"AWWayofTime"})
    private static boolean allowTelepose(World worldI, World worldF, Location s, BlockSpec spec1, Location d, BlockSpec spec2) {
        TeleposeEvent evt = new TeleposeEvent(worldI, s.x, s.y, s.z, spec1.getBlock(), spec2.getBlockMeta(), worldF, d.x, d.y, d.z, spec2.getBlock(), spec2.getBlockMeta());
        return !MinecraftForge.EVENT_BUS.post((Event)evt);
    }

    private static BlockMover<?> getBlockMover(World world, int x, int y, int z) {
        for (BlockMovers blockMover : BlockMovers.values()) {
            if (!blockMover.blockMover.canMove(world, x, y, z)) continue;
            return blockMover.blockMover;
        }
        throw new IllegalStateException();
    }

    static interface BlockMover<State> {
        public boolean canMove(World var1, int var2, int var3, int var4);

        public State remove(World var1, int var2, int var3, int var4);

        public void place(World var1, int var2, int var3, int var4, State var5);
    }

    private static enum BlockMovers {
        FMP(FMPBlockMover.INSTANCE),
        GT(GTBlockMover.INSTANCE),
        Standard(StandardBlockMover.INSTANCE);

        public final BlockMover<?> blockMover;

        private BlockMovers(BlockMover<?> blockMover) {
            this.blockMover = blockMover;
        }
    }

    private static class FMPBlockMover
    implements BlockMover<FMPBlock> {
        public static final FMPBlockMover INSTANCE = new FMPBlockMover();

        private FMPBlockMover() {
        }

        @Override
        public boolean canMove(World world, int x, int y, int z) {
            return world.func_147438_o(x, y, z) instanceof TileMultipart;
        }

        @Override
        public FMPBlock remove(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            TileMultipart te = (TileMultipart)world.func_147438_o(x, y, z);
            world.func_147455_a(x, y, z, null);
            world.func_147468_f(x, y, z);
            return new FMPBlock(block, meta, te);
        }

        @Override
        public void place(World world, int x, int y, int z, FMPBlock fmpBlock) {
            world.func_147465_d(x, y, z, fmpBlock.block, fmpBlock.meta, 3);
            ((FMPBlock)fmpBlock).tile.field_145851_c = x;
            ((FMPBlock)fmpBlock).tile.field_145848_d = y;
            ((FMPBlock)fmpBlock).tile.field_145849_e = z;
            fmpBlock.tile.func_145829_t();
            world.func_147455_a(x, y, z, (TileEntity)fmpBlock.tile);
            fmpBlock.tile.onMoved();
            world.func_147471_g(x, y, z);
            world.func_147451_t(x, y, z);
            fmpBlock.tile.func_70296_d();
            fmpBlock.tile.markRender();
            MultipartHelper.sendDescPacket((World)world, (TileEntity)fmpBlock.tile);
        }
    }

    private static final class FMPBlock {
        private final Block block;
        private final int meta;
        private final TileMultipart tile;

        private FMPBlock(Block block, int meta, TileMultipart tile) {
            this.block = block;
            this.meta = meta;
            this.tile = tile;
        }

        public String toString() {
            return "FMPBlock[" + "block=" + this.block + "," + "meta=" + this.meta + "," + "tile=" + this.tile + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
            result = 31 * result + this.meta;
            result = 31 * result + (this.tile != null ? this.tile.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((FMPBlock)arg0).block, this.block)) {
                return false;
            }
            if (((FMPBlock)arg0).meta != this.meta) {
                return false;
            }
            return Objects.equals(((FMPBlock)arg0).tile, this.tile);
            {
            }
        }

        public Block block() {
            return this.block;
        }

        public int meta() {
            return this.meta;
        }

        public TileMultipart tile() {
            return this.tile;
        }
    }

    private static class GTBlockMover
    extends StandardBlockMover {
        public static final GTBlockMover INSTANCE = new GTBlockMover();

        private GTBlockMover() {
        }

        @Override
        public boolean canMove(World world, int x, int y, int z) {
            return world.func_147438_o(x, y, z) instanceof IGregTechTileEntity;
        }

        @Override
        public StandardBlock remove(World world, int x, int y, int z) {
            world.func_147439_a(x, y, z).getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            return super.remove(world, x, y, z);
        }

        @Override
        public void place(World world, int x, int y, int z, StandardBlock standardBlock) {
            super.place(world, x, y, z, standardBlock);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IGregTechTileEntity) {
                IMetaTileEntity imte;
                IGregTechTileEntity igte = (IGregTechTileEntity)te;
                if (igte instanceof BaseMetaTileEntity) {
                    BaseMetaTileEntity bmte = (BaseMetaTileEntity)igte;
                    bmte.setCableUpdateDelay(100);
                }
                if ((imte = igte.getMetaTileEntity()) instanceof MTEPipeLaser) {
                    MTEPipeLaser laserPipe = (MTEPipeLaser)imte;
                    laserPipe.updateNeighboringNetworks();
                }
                if (imte instanceof MTEPipeData) {
                    MTEPipeData dataPipe = (MTEPipeData)imte;
                    dataPipe.updateNeighboringNetworks();
                }
            }
            if (te instanceof IIC2Enet) {
                IIC2Enet enet = (IIC2Enet)te;
                enet.doEnetUpdate();
            }
        }
    }

    private static class StandardBlockMover
    implements BlockMover<StandardBlock> {
        public static final StandardBlockMover INSTANCE = new StandardBlockMover();

        private StandardBlockMover() {
        }

        @Override
        public boolean canMove(World world, int x, int y, int z) {
            return true;
        }

        @Override
        public StandardBlock remove(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            NBTTagCompound tag = null;
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null) {
                tag = new NBTTagCompound();
                te.func_145841_b(tag);
            }
            world.func_147455_a(x, y, z, null);
            world.func_147468_f(x, y, z);
            return new StandardBlock(block, meta, tag);
        }

        @Override
        public void place(World world, int x, int y, int z, StandardBlock standardBlock) {
            world.func_147465_d(x, y, z, standardBlock.block, standardBlock.meta, 3);
            if (standardBlock.tileData != null) {
                TileEntity te = TileEntity.func_145827_c((NBTTagCompound)standardBlock.tileData);
                te.field_145851_c = x;
                te.field_145848_d = y;
                te.field_145849_e = z;
                world.func_147455_a(x, y, z, te);
            }
        }
    }

    private static final class StandardBlock {
        private final Block block;
        private final int meta;
        private final NBTTagCompound tileData;

        private StandardBlock(Block block, int meta, NBTTagCompound tileData) {
            this.block = block;
            this.meta = meta;
            this.tileData = tileData;
        }

        public String toString() {
            return "StandardBlock[" + "block=" + this.block + "," + "meta=" + this.meta + "," + "tileData=" + this.tileData + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
            result = 31 * result + this.meta;
            result = 31 * result + (this.tileData != null ? this.tileData.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((StandardBlock)arg0).block, this.block)) {
                return false;
            }
            if (((StandardBlock)arg0).meta != this.meta) {
                return false;
            }
            return Objects.equals(((StandardBlock)arg0).tileData, this.tileData);
            {
            }
        }

        public Block block() {
            return this.block;
        }

        public int meta() {
            return this.meta;
        }

        public NBTTagCompound tileData() {
            return this.tileData;
        }
    }
}

