/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.container.slot;

import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.gui.GuiHandler;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.event.container.ContainerControlEvent;
import com.creativemd.creativecore.common.packet.ContainerControlUpdatePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ContainerControl {
    public SubContainer parent;
    private int id = -1;
    @SideOnly(value=Side.CLIENT)
    public GuiControl guiControl;
    private static HashMap<String, Class<? extends ContainerControl>> controls = new HashMap();

    public void setID(int id) {
        if (this.id == -1) {
            this.id = id;
        }
    }

    public int getID() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public void init() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.guiControl = this.createGuiControl();
            this.guiControl.isContainerControl = true;
        }
    }

    public void detectChange() {
    }

    public void updateEqualContainers() {
        for (int i = 0; i < GuiHandler.openContainers.size(); ++i) {
            if (!GuiHandler.openContainers.get((int)i).coord.equals((Object)this.parent.container.coord)) continue;
            for (int j = 0; j < GuiHandler.openContainers.get((int)i).layers.size(); ++j) {
                GuiHandler.openContainers.get((int)i).layers.get(j).onGuiOpened();
            }
        }
    }

    public void sendNBTUpdate(int type, NBTTagCompound nbt) {
        nbt.func_74768_a("type", type);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            PacketHandler.sendPacketToServer(new ContainerControlUpdatePacket(this.parent.getLayerID(), this.id, nbt));
        } else {
            PacketHandler.sendPacketToPlayer(new ContainerControlUpdatePacket(this.parent.getLayerID(), this.id, nbt), (EntityPlayerMP)this.parent.player);
        }
    }

    public void sendUpdate() {
        this.updateEqualContainers();
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        this.sendNBTUpdate(0, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract GuiControl createGuiControl();

    public void onGuiClose() {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public boolean raiseEvent(ContainerControlEvent event) {
        return this.parent.raiseEvent(event);
    }

    public static void registerControl(String id, Class<? extends ContainerControl> ControlClass) {
        if (ContainerControl.containsID(id)) {
            throw new IllegalArgumentException("ID=" + id + " is already taken!");
        }
        if (ContainerControl.containsClass(ControlClass)) {
            throw new IllegalArgumentException("Class=" + ControlClass.getName() + " is already registered!");
        }
        controls.put(id, ControlClass);
    }

    public static Class<? extends ContainerControl> getClassByID(String id) {
        return controls.get(id);
    }

    public static String getIDbyCkass(Class<? extends ContainerControl> ControlClass) {
        for (Map.Entry<String, Class<? extends ContainerControl>> entry : controls.entrySet()) {
            if (ControlClass != entry.getValue()) continue;
            return entry.getKey();
        }
        return "";
    }

    public static boolean containsClass(Class<? extends ContainerControl> ControlClass) {
        return controls.containsValue(ControlClass);
    }

    public static boolean containsID(String id) {
        return controls.containsKey(id);
    }
}

