/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.ColourAndCoords;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import WayofTime.alchemicalWizardry.common.tileEntity.TEOrientable;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPedestal;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPlinth;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import WayofTime.alchemicalWizardry.common.tileEntity.TESocket;
import WayofTime.alchemicalWizardry.common.tileEntity.TETeleposer;
import WayofTime.alchemicalWizardry.common.tileEntity.TEWritingTable;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public enum NewPacketHandler {
    INSTANCE;

    private final EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("BloodMagic", new ChannelHandler[]{new TEAltarCodec()});

    private NewPacketHandler() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addClientHandler();
        }
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            System.out.println("Server sided~");
            this.addServerHandler();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addClientHandler() {
        FMLEmbeddedChannel clientChannel = this.channels.get(Side.CLIENT);
        String tileAltarCodec = clientChannel.findChannelHandlerNameForType(TEAltarCodec.class);
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEAltarHandler", (ChannelHandler)new TEAltarMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEOrientableHandler", (ChannelHandler)new TEOrientableMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEPedestalHandler", (ChannelHandler)new TEPedestalMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEPlinthHandler", (ChannelHandler)new TEPlinthMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TESocketHandler", (ChannelHandler)new TESocketMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TETeleposerHandler", (ChannelHandler)new TETeleposerMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEWritingTableHandler", (ChannelHandler)new TEWritingTableMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "ParticleHandler", (ChannelHandler)new ParticleMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "VelocityHandler", (ChannelHandler)new VelocityMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEMasterStoneHandler", (ChannelHandler)new TEMasterStoneMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "TEReagentConduitHandler", (ChannelHandler)new TEReagentConduitMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "CurrentLPMessageHandler", (ChannelHandler)new CurrentLPMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "CurrentReagentBarMessageHandler", (ChannelHandler)new CurrentReagentBarMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "CurrentAddedHPMessageHandler", (ChannelHandler)new CurrentAddedHPMessageHandler());
        clientChannel.pipeline().addAfter(tileAltarCodec, "GaiaBiomeChangeHandler", (ChannelHandler)new GaiaBiomeChangeMessageHandler());
    }

    @SideOnly(value=Side.SERVER)
    private void addServerHandler() {
        FMLEmbeddedChannel serverChannel = this.channels.get(Side.SERVER);
        String messageCodec = serverChannel.findChannelHandlerNameForType(TEAltarCodec.class);
        serverChannel.pipeline().addAfter(messageCodec, "KeyboardMessageHandler", (ChannelHandler)new KeyboardMessageHandler());
    }

    public static Packet getPacket(TEAltar tileAltar) {
        TEAltarMessage msg = new TEAltarMessage();
        msg.index = 0;
        msg.x = tileAltar.field_145851_c;
        msg.y = tileAltar.field_145848_d;
        msg.z = tileAltar.field_145849_e;
        msg.items = tileAltar.buildIntDataList();
        msg.fluids = tileAltar.buildFluidList();
        msg.capacity = tileAltar.getCapacity();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEOrientable tileOrientable) {
        TEOrientableMessage msg = new TEOrientableMessage();
        msg.index = 1;
        msg.x = tileOrientable.field_145851_c;
        msg.y = tileOrientable.field_145848_d;
        msg.z = tileOrientable.field_145849_e;
        msg.input = TEOrientable.getIntForForgeDirection(tileOrientable.getInputDirection());
        msg.output = TEOrientable.getIntForForgeDirection(tileOrientable.getOutputDirection());
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEPedestal tilePedestal) {
        TEPedestalMessage msg = new TEPedestalMessage();
        msg.index = 2;
        msg.x = tilePedestal.field_145851_c;
        msg.y = tilePedestal.field_145848_d;
        msg.z = tilePedestal.field_145849_e;
        msg.items = tilePedestal.buildIntDataList();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEPlinth tilePlinth) {
        TEPlinthMessage msg = new TEPlinthMessage();
        msg.index = 3;
        msg.x = tilePlinth.field_145851_c;
        msg.y = tilePlinth.field_145848_d;
        msg.z = tilePlinth.field_145849_e;
        msg.items = tilePlinth.buildIntDataList();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TESocket tileSocket) {
        TESocketMessage msg = new TESocketMessage();
        msg.index = 4;
        msg.x = tileSocket.field_145851_c;
        msg.y = tileSocket.field_145848_d;
        msg.z = tileSocket.field_145849_e;
        msg.items = tileSocket.buildIntDataList();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TETeleposer tileTeleposer) {
        TETeleposerMessage msg = new TETeleposerMessage();
        msg.index = 5;
        msg.x = tileTeleposer.field_145851_c;
        msg.y = tileTeleposer.field_145848_d;
        msg.z = tileTeleposer.field_145849_e;
        msg.items = tileTeleposer.buildIntDataList();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEWritingTable tileWritingTable) {
        TEWritingTableMessage msg = new TEWritingTableMessage();
        msg.index = 6;
        msg.x = tileWritingTable.field_145851_c;
        msg.y = tileWritingTable.field_145848_d;
        msg.z = tileWritingTable.field_145849_e;
        msg.items = tileWritingTable.buildIntDataList();
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getParticlePacket(String str, double xCoord, double yCoord, double zCoord, double xVel, double yVel, double zVel) {
        ParticleMessage msg = new ParticleMessage();
        msg.index = 7;
        msg.particle = str;
        msg.xCoord = xCoord;
        msg.yCoord = yCoord;
        msg.zCoord = zCoord;
        msg.xVel = xVel;
        msg.yVel = yVel;
        msg.zVel = zVel;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getVelSettingPacket(double xVel, double yVel, double zVel) {
        VelocityMessage msg = new VelocityMessage();
        msg.index = 8;
        msg.xVel = xVel;
        msg.yVel = yVel;
        msg.zVel = zVel;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEMasterStone tile) {
        TEMasterStoneMessage msg = new TEMasterStoneMessage();
        msg.index = 9;
        msg.x = tile.field_145851_c;
        msg.y = tile.field_145848_d;
        msg.z = tile.field_145849_e;
        msg.ritual = tile.getCurrentRitual();
        msg.isRunning = tile.isRunning;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getPacket(TEReagentConduit tile) {
        TEReagentConduitMessage msg = new TEReagentConduitMessage();
        msg.index = 10;
        msg.x = tile.field_145851_c;
        msg.y = tile.field_145848_d;
        msg.z = tile.field_145849_e;
        msg.destinationList = tile.destinationList;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getLPPacket(int curLP, int maxLP) {
        CurrentLPMessage msg = new CurrentLPMessage();
        msg.index = 11;
        msg.currentLP = curLP;
        msg.maxLP = maxLP;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getReagentBarPacket(Reagent reagent, float curAR, float maxAR) {
        CurrentReagentBarMessage msg = new CurrentReagentBarMessage();
        msg.index = 12;
        msg.reagent = ReagentRegistry.getKeyForReagent(reagent);
        msg.currentAR = curAR;
        msg.maxAR = maxAR;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getAddedHPPacket(float health, float maxHP) {
        CurrentAddedHPMessage msg = new CurrentAddedHPMessage();
        msg.index = 13;
        msg.currentHP = health;
        msg.maxHP = maxHP;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public static Packet getKeyboardPressPacket(byte bt) {
        KeyboardMessage msg = new KeyboardMessage();
        msg.index = 14;
        msg.keyPressed = bt;
        return NewPacketHandler.INSTANCE.channels.get(Side.CLIENT).generatePacketFrom((Object)msg);
    }

    public static Packet getGaiaBiomeChangePacket(int x, int z, byte biome, BitSet mask) {
        GaiaBiomeChangeMessage msg = new GaiaBiomeChangeMessage();
        msg.index = 15;
        msg.chunkX = x;
        msg.chunkZ = z;
        msg.biome = biome;
        msg.mask = mask;
        return NewPacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    public void sendTo(Packet message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(Packet message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(Packet message, Integer dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private static class TEAltarCodec
    extends FMLIndexedMessageToMessageCodec<BMMessage> {
        public TEAltarCodec() {
            this.addDiscriminator(0, TEAltarMessage.class);
            this.addDiscriminator(1, TEOrientableMessage.class);
            this.addDiscriminator(2, TEPedestalMessage.class);
            this.addDiscriminator(3, TEPlinthMessage.class);
            this.addDiscriminator(4, TESocketMessage.class);
            this.addDiscriminator(5, TETeleposerMessage.class);
            this.addDiscriminator(6, TEWritingTableMessage.class);
            this.addDiscriminator(7, ParticleMessage.class);
            this.addDiscriminator(8, VelocityMessage.class);
            this.addDiscriminator(9, TEMasterStoneMessage.class);
            this.addDiscriminator(10, TEReagentConduitMessage.class);
            this.addDiscriminator(11, CurrentLPMessage.class);
            this.addDiscriminator(12, CurrentReagentBarMessage.class);
            this.addDiscriminator(13, CurrentAddedHPMessage.class);
            this.addDiscriminator(14, KeyboardMessage.class);
            this.addDiscriminator(15, GaiaBiomeChangeMessage.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, BMMessage msg, ByteBuf target) {
            target.writeInt(msg.index);
            switch (msg.index) {
                case 0: {
                    TEAltarMessage m = (TEAltarMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items != null) {
                        int[] items = m.items;
                        Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    }
                    target.writeBoolean(m.fluids != null);
                    if (m.fluids != null) {
                        int[] fluids = m.fluids;
                        Arrays.stream(fluids).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    }
                    target.writeInt(m.capacity);
                    break;
                }
                case 1: {
                    TEOrientableMessage m = (TEOrientableMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeInt(m.input);
                    target.writeInt(m.output);
                    break;
                }
                case 2: {
                    TEPedestalMessage m = (TEPedestalMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items == null) break;
                    int[] items = m.items;
                    Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    break;
                }
                case 3: {
                    TEPlinthMessage m = (TEPlinthMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items == null) break;
                    int[] items = m.items;
                    Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    break;
                }
                case 4: {
                    TESocketMessage m = (TESocketMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items == null) break;
                    int[] items = m.items;
                    Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    break;
                }
                case 5: {
                    TETeleposerMessage m = (TETeleposerMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items == null) break;
                    int[] items = m.items;
                    Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    break;
                }
                case 6: {
                    TEWritingTableMessage m = (TEWritingTableMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    target.writeBoolean(m.items != null);
                    if (m.items == null) break;
                    int[] items = m.items;
                    Arrays.stream(items).forEach(arg_0 -> ((ByteBuf)target).writeInt(arg_0));
                    break;
                }
                case 7: {
                    ParticleMessage m = (ParticleMessage)msg;
                    String str = m.particle;
                    target.writeInt(str.length());
                    IntStream.range(0, str.length()).map(str::charAt).forEach(arg_0 -> ((ByteBuf)target).writeChar(arg_0));
                    target.writeDouble(m.xCoord);
                    target.writeDouble(m.yCoord);
                    target.writeDouble(m.zCoord);
                    target.writeDouble(m.xVel);
                    target.writeDouble(m.yVel);
                    target.writeDouble(m.zVel);
                    break;
                }
                case 8: {
                    VelocityMessage m = (VelocityMessage)msg;
                    target.writeDouble(m.xVel);
                    target.writeDouble(m.yVel);
                    target.writeDouble(m.zVel);
                    break;
                }
                case 9: {
                    TEMasterStoneMessage m = (TEMasterStoneMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    String ritual = m.ritual;
                    target.writeInt(ritual.length());
                    IntStream.range(0, ritual.length()).map(ritual::charAt).forEach(arg_0 -> ((ByteBuf)target).writeChar(arg_0));
                    target.writeBoolean(m.isRunning);
                    break;
                }
                case 10: {
                    TEReagentConduitMessage m = (TEReagentConduitMessage)msg;
                    target.writeInt(m.x);
                    target.writeInt(m.y);
                    target.writeInt(m.z);
                    List<ColourAndCoords> list = m.destinationList;
                    target.writeInt(list.size());
                    list.forEach(colourSet -> {
                        target.writeInt(colourSet.colourRed);
                        target.writeInt(colourSet.colourGreen);
                        target.writeInt(colourSet.colourBlue);
                        target.writeInt(colourSet.colourIntensity);
                        target.writeInt(colourSet.xCoord);
                        target.writeInt(colourSet.yCoord);
                        target.writeInt(colourSet.zCoord);
                    });
                    break;
                }
                case 11: {
                    CurrentLPMessage m = (CurrentLPMessage)msg;
                    target.writeInt(m.currentLP);
                    target.writeInt(m.maxLP);
                    break;
                }
                case 12: {
                    CurrentReagentBarMessage m = (CurrentReagentBarMessage)msg;
                    char[] charSet = m.reagent.toCharArray();
                    target.writeInt(charSet.length);
                    for (char cha : charSet) {
                        target.writeChar((int)cha);
                    }
                    target.writeFloat(m.currentAR);
                    target.writeFloat(m.maxAR);
                    break;
                }
                case 13: {
                    CurrentAddedHPMessage m = (CurrentAddedHPMessage)msg;
                    target.writeFloat(m.currentHP);
                    target.writeFloat(m.maxHP);
                    break;
                }
                case 14: {
                    target.writeByte((int)((KeyboardMessage)msg).keyPressed);
                    break;
                }
                case 15: {
                    GaiaBiomeChangeMessage m = (GaiaBiomeChangeMessage)msg;
                    target.writeInt(m.chunkX);
                    target.writeInt(m.chunkZ);
                    target.writeByte((int)m.biome);
                    byte[] arr = Arrays.copyOf(m.mask.toByteArray(), 32);
                    target.writeBytes(arr);
                }
            }
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, BMMessage msg) {
            int index = dat.readInt();
            switch (index) {
                case 0: {
                    TEAltarMessage m = (TEAltarMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[3];
                    if (hasStacks) {
                        m.items = new int[3];
                        IntStream.range(0, m.items.length).forEach(i -> {
                            m.items[i] = dat.readInt();
                        });
                    }
                    boolean hasFluids = dat.readBoolean();
                    m.fluids = new int[6];
                    if (hasFluids) {
                        IntStream.range(0, m.fluids.length).forEach(i -> {
                            m.fluids[i] = dat.readInt();
                        });
                    }
                    m.capacity = dat.readInt();
                    break;
                }
                case 1: {
                    TEOrientableMessage m = (TEOrientableMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    m.input = dat.readInt();
                    m.output = dat.readInt();
                    break;
                }
                case 2: {
                    TEPedestalMessage m = (TEPedestalMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[3];
                    if (!hasStacks) break;
                    m.items = new int[3];
                    IntStream.range(0, m.items.length).forEach(i -> {
                        m.items[i] = dat.readInt();
                    });
                    break;
                }
                case 3: {
                    TEPlinthMessage m = (TEPlinthMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[3];
                    if (!hasStacks) break;
                    m.items = new int[3];
                    IntStream.range(0, m.items.length).forEach(i -> {
                        m.items[i] = dat.readInt();
                    });
                    break;
                }
                case 4: {
                    TESocketMessage m = (TESocketMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[3];
                    if (!hasStacks) break;
                    m.items = new int[3];
                    IntStream.range(0, m.items.length).forEach(i -> {
                        m.items[i] = dat.readInt();
                    });
                    break;
                }
                case 5: {
                    TETeleposerMessage m = (TETeleposerMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[3];
                    if (!hasStacks) break;
                    m.items = new int[3];
                    IntStream.range(0, m.items.length).forEach(i -> {
                        m.items[i] = dat.readInt();
                    });
                    break;
                }
                case 6: {
                    TEWritingTableMessage m = (TEWritingTableMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    boolean hasStacks = dat.readBoolean();
                    m.items = new int[21];
                    if (!hasStacks) break;
                    m.items = new int[21];
                    IntStream.range(0, m.items.length).forEach(i -> {
                        m.items[i] = dat.readInt();
                    });
                    break;
                }
                case 7: {
                    String str = IntStream.range(0, dat.readInt()).mapToObj(i -> String.valueOf(dat.readChar())).collect(Collectors.joining());
                    ParticleMessage m = (ParticleMessage)msg;
                    m.particle = str;
                    m.xCoord = dat.readDouble();
                    m.yCoord = dat.readDouble();
                    m.zCoord = dat.readDouble();
                    m.xVel = dat.readDouble();
                    m.yVel = dat.readDouble();
                    m.zVel = dat.readDouble();
                    break;
                }
                case 8: {
                    VelocityMessage m = (VelocityMessage)msg;
                    m.xVel = dat.readDouble();
                    m.yVel = dat.readDouble();
                    m.zVel = dat.readDouble();
                    break;
                }
                case 9: {
                    TEMasterStoneMessage m = (TEMasterStoneMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    m.ritual = IntStream.range(0, dat.readInt()).mapToObj(i -> String.valueOf(dat.readChar())).collect(Collectors.joining());
                    m.isRunning = dat.readBoolean();
                    break;
                }
                case 10: {
                    TEReagentConduitMessage m = (TEReagentConduitMessage)msg;
                    m.x = dat.readInt();
                    m.y = dat.readInt();
                    m.z = dat.readInt();
                    int listSize = dat.readInt();
                    m.destinationList = IntStream.range(0, listSize).mapToObj(i -> new ColourAndCoords(dat.readInt(), dat.readInt(), dat.readInt(), dat.readInt(), dat.readInt(), dat.readInt(), dat.readInt())).collect(Collectors.toCollection(LinkedList::new));
                    break;
                }
                case 11: {
                    CurrentLPMessage m = (CurrentLPMessage)msg;
                    m.currentLP = dat.readInt();
                    m.maxLP = dat.readInt();
                    break;
                }
                case 12: {
                    CurrentReagentBarMessage m = (CurrentReagentBarMessage)msg;
                    m.reagent = IntStream.range(0, dat.readInt()).mapToObj(i -> String.valueOf(dat.readChar())).collect(Collectors.joining());
                    m.currentAR = dat.readFloat();
                    m.maxAR = dat.readFloat();
                    break;
                }
                case 13: {
                    CurrentAddedHPMessage m = (CurrentAddedHPMessage)msg;
                    m.currentHP = dat.readFloat();
                    m.maxHP = dat.readFloat();
                    break;
                }
                case 14: {
                    ((KeyboardMessage)msg).keyPressed = dat.readByte();
                    break;
                }
                case 15: {
                    GaiaBiomeChangeMessage m = (GaiaBiomeChangeMessage)msg;
                    m.chunkX = dat.readInt();
                    m.chunkZ = dat.readInt();
                    m.biome = dat.readByte();
                    byte[] buffer = new byte[32];
                    dat.readBytes(buffer);
                    m.mask = BitSet.valueOf(buffer);
                }
            }
        }
    }

    private static class TEAltarMessageHandler
    extends SimpleChannelInboundHandler<TEAltarMessage> {
        private TEAltarMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEAltarMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEAltar) {
                TEAltar altar = (TEAltar)te;
                altar.handlePacketData(msg.items, msg.fluids, msg.capacity);
            }
        }
    }

    private static class TEOrientableMessageHandler
    extends SimpleChannelInboundHandler<TEOrientableMessage> {
        private TEOrientableMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEOrientableMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEOrientable) {
                TEOrientable teOrientable = (TEOrientable)te;
                teOrientable.setInputDirection(ForgeDirection.getOrientation((int)msg.input));
                teOrientable.setOutputDirection(ForgeDirection.getOrientation((int)msg.output));
            }
        }
    }

    private static class TEPedestalMessageHandler
    extends SimpleChannelInboundHandler<TEPedestalMessage> {
        private TEPedestalMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEPedestalMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEPedestal) {
                TEPedestal pedestal = (TEPedestal)te;
                pedestal.handlePacketData(msg.items);
            }
        }
    }

    private static class TEPlinthMessageHandler
    extends SimpleChannelInboundHandler<TEPlinthMessage> {
        private TEPlinthMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEPlinthMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEPlinth) {
                TEPlinth Plinth = (TEPlinth)te;
                Plinth.handlePacketData(msg.items);
            }
        }
    }

    private static class TESocketMessageHandler
    extends SimpleChannelInboundHandler<TESocketMessage> {
        private TESocketMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TESocketMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TESocket) {
                TESocket Socket = (TESocket)te;
                Socket.handlePacketData(msg.items);
            }
        }
    }

    private static class TETeleposerMessageHandler
    extends SimpleChannelInboundHandler<TETeleposerMessage> {
        private TETeleposerMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TETeleposerMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TETeleposer) {
                TETeleposer Teleposer = (TETeleposer)te;
                Teleposer.handlePacketData(msg.items);
            }
        }
    }

    private static class TEWritingTableMessageHandler
    extends SimpleChannelInboundHandler<TEWritingTableMessage> {
        private TEWritingTableMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEWritingTableMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEWritingTable) {
                TEWritingTable WritingTable = (TEWritingTable)te;
                WritingTable.handlePacketData(msg.items);
            }
        }
    }

    private static class ParticleMessageHandler
    extends SimpleChannelInboundHandler<ParticleMessage> {
        private ParticleMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ParticleMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            world.func_72869_a(msg.particle, msg.xCoord, msg.yCoord, msg.zCoord, msg.xVel, msg.yVel, msg.zVel);
        }
    }

    private static class VelocityMessageHandler
    extends SimpleChannelInboundHandler<VelocityMessage> {
        private VelocityMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, VelocityMessage msg) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.field_70159_w = msg.xVel;
                player.field_70181_x = msg.yVel;
                player.field_70179_y = msg.zVel;
            }
        }
    }

    private static class TEMasterStoneMessageHandler
    extends SimpleChannelInboundHandler<TEMasterStoneMessage> {
        private TEMasterStoneMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEMasterStoneMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEMasterStone) {
                TEMasterStone masterStone = (TEMasterStone)te;
                masterStone.setCurrentRitual(msg.ritual);
                masterStone.isRunning = msg.isRunning;
            }
        }
    }

    private static class TEReagentConduitMessageHandler
    extends SimpleChannelInboundHandler<TEReagentConduitMessage> {
        private TEReagentConduitMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, TEReagentConduitMessage msg) {
            World world = AlchemicalWizardry.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TEReagentConduit) {
                TEReagentConduit reagentConduit = (TEReagentConduit)te;
                reagentConduit.destinationList = msg.destinationList;
            }
        }
    }

    private static class CurrentLPMessageHandler
    extends SimpleChannelInboundHandler<CurrentLPMessage> {
        private CurrentLPMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CurrentLPMessage msg) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            APISpellHelper.setPlayerLPTag((EntityPlayer)player, msg.currentLP);
            APISpellHelper.setPlayerMaxLPTag((EntityPlayer)player, msg.maxLP);
        }
    }

    private static class CurrentReagentBarMessageHandler
    extends SimpleChannelInboundHandler<CurrentReagentBarMessage> {
        private CurrentReagentBarMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CurrentReagentBarMessage msg) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            APISpellHelper.setPlayerReagentType((EntityPlayer)player, msg.reagent);
            APISpellHelper.setPlayerCurrentReagentAmount((EntityPlayer)player, msg.currentAR);
            APISpellHelper.setPlayerMaxReagentAmount((EntityPlayer)player, msg.maxAR);
        }
    }

    private static class CurrentAddedHPMessageHandler
    extends SimpleChannelInboundHandler<CurrentAddedHPMessage> {
        private CurrentAddedHPMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CurrentAddedHPMessage msg) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            APISpellHelper.setCurrentAdditionalHP((EntityPlayer)player, msg.currentHP);
            APISpellHelper.setCurrentAdditionalMaxHP((EntityPlayer)player, msg.maxHP);
        }
    }

    private static class GaiaBiomeChangeMessageHandler
    extends SimpleChannelInboundHandler<GaiaBiomeChangeMessage> {
        private GaiaBiomeChangeMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, GaiaBiomeChangeMessage msg) {
            Chunk chunk = AlchemicalWizardry.proxy.getClientWorld().func_72964_e(msg.chunkX, msg.chunkZ);
            if (chunk != null) {
                byte[] biomeArray = chunk.func_76605_m();
                for (int i = 0; i < 256; ++i) {
                    if (!msg.mask.get(i)) continue;
                    biomeArray[i] = msg.biome;
                }
                chunk.func_76616_a(biomeArray);
            }
        }
    }

    private static class KeyboardMessageHandler
    extends SimpleChannelInboundHandler<KeyboardMessage> {
        public KeyboardMessageHandler() {
            System.out.println("I am being created");
        }

        protected void channelRead0(ChannelHandlerContext ctx, KeyboardMessage msg) {
            System.out.println("Hmmm");
        }
    }

    public static class TEAltarMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
        int[] fluids;
        int capacity;
    }

    public static class TEOrientableMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int input;
        int output;
    }

    public static class TEPedestalMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
    }

    public static class TEPlinthMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
    }

    public static class TESocketMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
    }

    public static class TETeleposerMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
    }

    public static class TEWritingTableMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        int[] items;
    }

    public static class ParticleMessage
    extends BMMessage {
        String particle;
        double xCoord;
        double yCoord;
        double zCoord;
        double xVel;
        double yVel;
        double zVel;
    }

    public static class VelocityMessage
    extends BMMessage {
        double xVel;
        double yVel;
        double zVel;
    }

    public static class TEMasterStoneMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        String ritual;
        boolean isRunning;
    }

    public static class TEReagentConduitMessage
    extends BMMessage {
        int x;
        int y;
        int z;
        List<ColourAndCoords> destinationList;
    }

    public static class CurrentLPMessage
    extends BMMessage {
        int currentLP;
        int maxLP;
    }

    public static class CurrentReagentBarMessage
    extends BMMessage {
        String reagent;
        float currentAR;
        float maxAR;
    }

    public static class CurrentAddedHPMessage
    extends BMMessage {
        float currentHP;
        float maxHP;
    }

    public static class KeyboardMessage
    extends BMMessage {
        byte keyPressed;
    }

    public static class GaiaBiomeChangeMessage
    extends BMMessage {
        int chunkX;
        int chunkZ;
        byte biome;
        BitSet mask;
        public static final int maskByteCount = 32;
    }

    public static class BMMessage {
        int index;
    }
}

