/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ru.timeconqueror.lootgames.api.minigame.BoardLootGame;
import ru.timeconqueror.lootgames.api.minigame.ILootGameFactory;
import ru.timeconqueror.lootgames.api.minigame.NotifyColor;
import ru.timeconqueror.lootgames.api.task.TaskCreateExplosion;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.api.util.RewardUtils;
import ru.timeconqueror.lootgames.common.config.ConfigMS;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.lootgames.common.packet.game.SPMSFieldChanged;
import ru.timeconqueror.lootgames.common.packet.game.SPMSGenBoard;
import ru.timeconqueror.lootgames.common.packet.game.SPMSResetFlags;
import ru.timeconqueror.lootgames.common.packet.game.SPMSSpawnLevelBeatParticles;
import ru.timeconqueror.lootgames.minigame.minesweeper.MSBoard;
import ru.timeconqueror.lootgames.minigame.minesweeper.Mark;
import ru.timeconqueror.lootgames.minigame.minesweeper.Type;
import ru.timeconqueror.lootgames.registry.LGAchievements;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.registry.LGSounds;
import ru.timeconqueror.lootgames.utils.MouseClickType;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.common.tile.SerializationType;
import ru.timeconqueror.timecore.api.util.NetworkUtils;
import ru.timeconqueror.timecore.api.util.RandHelper;
import ru.timeconqueror.timecore.api.util.Wrapper;

public class GameMineSweeper
extends BoardLootGame<GameMineSweeper> {
    public boolean cIsGenerated;
    private int currentLevel = 1;
    private final MSBoard board = new MSBoard(0, 0);
    private int ticks;
    private int attemptCount = 0;
    private boolean playRevealNeighboursSound = true;
    private ConfigMS.Snapshot configSnapshot = null;

    public void setConfigSnapshot(ConfigMS.Snapshot configSnapshot) {
        this.configSnapshot = configSnapshot;
    }

    @Override
    public void onPlace() {
        this.setupInitialStage(new StageWaiting());
        if (this.isServerSide()) {
            this.configSnapshot = LGConfigs.MINESWEEPER.snapshot();
            this.board.setSize(this.configSnapshot.getStage1().getBoardSize());
            this.board.setBombCount(this.configSnapshot.getStage1().getBombCount());
        }
        super.onPlace();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isClientSide()) {
            this.configSnapshot = ConfigMS.Snapshot.stub();
        }
    }

    public boolean isBoardGenerated() {
        return this.board.isGenerated();
    }

    @Override
    public int getCurrentBoardSize() {
        return this.board.size();
    }

    @Override
    public int getAllocatedBoardSize() {
        return this.configSnapshot.getStage4().getBoardSize();
    }

    private void onLevelSuccessfullyFinished() {
        if (this.currentLevel < 4) {
            this.sendUpdatePacketToNearby(new SPMSSpawnLevelBeatParticles());
            this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.stage_complete", new Object[0]), NotifyColor.SUCCESS);
            WorldExt.playSoundServerly(this.getWorld(), this.getGameCenter(), "random.levelup", 0.75f, 1.0f);
            ConfigMS.Snapshot.StageSnapshot stageSnapshot = this.configSnapshot.getStageByIndex(this.currentLevel + 1);
            this.board.resetBoard(stageSnapshot.getBoardSize(), stageSnapshot.getBombCount());
            ++this.currentLevel;
            this.saveAndSync();
        } else if (this.currentLevel == 4) {
            ++this.currentLevel;
            this.triggerGameWin();
        }
    }

    @Override
    protected void triggerGameWin() {
        super.triggerGameWin();
        List<EntityPlayerMP> players = NetworkUtils.getPlayersNearby(this.getGameCenter(), this.getBroadcastDistance());
        this.genLootChests(players);
    }

    private void genLootChests(List<EntityPlayerMP> players) {
        if (this.currentLevel < 2) {
            throw new RuntimeException("GenLootChests method was called in an appropriate time!");
        }
        BlockPos central = this.getGameCenter();
        if (this.currentLevel > 4) {
            players.forEach(LGAchievements.MS_BEAT_LEVEL4::trigger);
        }
        RewardUtils.spawnFourStagedReward((WorldServer)this.getWorld(), this, central, this.currentLevel - 1, LGConfigs.REWARDS.rewardsMinesweeper);
    }

    @Override
    protected void triggerGameLose() {
        super.triggerGameLose();
        BlockPos expPos = this.getGameCenter();
        WorldExt.explode(this.getWorld(), null, expPos.getX(), (double)expPos.getY() + 1.5, expPos.getZ(), 9.0f, true);
    }

    @Override
    protected void onStageUpdate(BoardLootGame.BoardStage oldStage, BoardLootGame.BoardStage newStage, boolean shouldDelayPacketSending) {
        this.ticks = 0;
        super.onStageUpdate(oldStage, newStage, shouldDelayPacketSending);
    }

    public MSBoard getBoard() {
        return this.board;
    }

    public int getTicks() {
        return this.ticks;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt, SerializationType type) {
        super.writeNBT(nbt, type);
        if (type == SerializationType.SAVE) {
            if (this.isBoardGenerated()) {
                NBTTagCompound boardTag = this.board.writeNBTForSaving();
                nbt.func_74782_a("board", (NBTBase)boardTag);
            }
            nbt.func_74768_a("attempt_count", this.attemptCount);
        } else {
            nbt.func_74757_a("is_generated", this.isBoardGenerated());
            if (this.isBoardGenerated()) {
                NBTTagCompound boardTag = this.board.writeNBTForClient();
                nbt.func_74782_a("board", (NBTBase)boardTag);
            }
        }
        nbt.func_74768_a("bomb_count", this.board.getBombCount());
        nbt.func_74768_a("board_size", this.board.size());
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74768_a("current_level", this.currentLevel);
        nbt.func_74782_a("config_snapshot", (NBTBase)ConfigMS.Snapshot.serialize(this.configSnapshot));
    }

    @Override
    public void readNBT(NBTTagCompound nbt, SerializationType type) {
        super.readNBT(nbt, type);
        if (type == SerializationType.SAVE) {
            if (nbt.func_74764_b("board")) {
                NBTTagCompound boardTag = nbt.func_74775_l("board");
                this.board.readNBTFromSave(boardTag);
            }
            this.attemptCount = nbt.func_74762_e("attempt_count");
        } else {
            this.cIsGenerated = nbt.func_74767_n("is_generated");
            if (nbt.func_74764_b("board")) {
                NBTTagCompound boardTag = nbt.func_74775_l("board");
                this.board.readNBTFromClient(boardTag);
            }
        }
        this.board.setBombCount(nbt.func_74762_e("bomb_count"));
        this.board.setSize(nbt.func_74762_e("board_size"));
        this.ticks = nbt.func_74762_e("ticks");
        this.currentLevel = nbt.func_74762_e("current_level");
        this.configSnapshot = ConfigMS.Snapshot.deserialize(nbt.func_74775_l("config_snapshot"));
    }

    @Override
    public BoardLootGame.BoardStage createStageFromNBT(String id, NBTTagCompound stageNBT, SerializationType serializationType) {
        switch (id) {
            case "waiting": {
                return new StageWaiting();
            }
            case "detonating": {
                return new StageDetonating(stageNBT.func_74762_e("detonation_time"));
            }
            case "exploding": {
                return new StageExploding();
            }
        }
        throw new IllegalArgumentException("Unknown state with id: " + id + "!");
    }

    public class StageExploding
    extends BoardLootGame.BoardStage {
        private static final String ID = "exploding";

        @Override
        public void postInit() {
            int longestDetTime = this.detonateBoard(GameMineSweeper.this.currentLevel + 3, false);
            GameMineSweeper.this.ticks = longestDetTime + 20;
        }

        @Override
        public void onTick() {
            if (GameMineSweeper.this.isServerSide()) {
                GameMineSweeper.this.ticks--;
                if (GameMineSweeper.this.ticks <= 0) {
                    GameMineSweeper.this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.ms.new_attempt", new Object[0]), NotifyColor.NOTIFY);
                    GameMineSweeper.this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.attempt_left", new Object[]{LGConfigs.MINESWEEPER.attemptCount - GameMineSweeper.this.attemptCount}), NotifyColor.GRAVE_NOTIFY);
                    GameMineSweeper.this.switchStage(new StageWaiting());
                    GameMineSweeper.this.board.resetBoard();
                    GameMineSweeper.this.sendUpdatePacketToNearby(new SPMSResetFlags());
                    GameMineSweeper.this.saveAndSync();
                }
            }
        }

        private int detonateBoard(int strength, boolean affectBlocks) {
            Wrapper<Integer> longestDetTime = new Wrapper<Integer>(0);
            GameMineSweeper.this.board.forEach(pos2i -> {
                if (GameMineSweeper.this.board.getType((Pos2i)pos2i) == Type.BOMB) {
                    int detTime = RandHelper.RAND.nextInt(45);
                    if ((Integer)longestDetTime.get() < detTime) {
                        longestDetTime.set(detTime);
                    }
                    GameMineSweeper.this.taskScheduler.addTask(new TaskCreateExplosion(GameMineSweeper.this.convertToBlockPos((Pos2i)pos2i), strength, affectBlocks), detTime);
                }
            });
            return longestDetTime.get();
        }

        @Override
        public String getID() {
            return ID;
        }
    }

    public class StageDetonating
    extends BoardLootGame.BoardStage {
        private static final String ID = "detonating";
        private final int detonationTicks;

        public StageDetonating() {
            this(LGConfigs.MINESWEEPER.detonationTime);
        }

        public StageDetonating(int detonationTicks) {
            this.detonationTicks = detonationTicks;
        }

        @Override
        public void onTick() {
            if (GameMineSweeper.this.isServerSide() && GameMineSweeper.this.ticks >= this.detonationTicks) {
                if (GameMineSweeper.this.attemptCount < LGConfigs.MINESWEEPER.attemptCount) {
                    GameMineSweeper.this.switchStage(new StageExploding());
                } else if (GameMineSweeper.this.currentLevel > 1) {
                    GameMineSweeper.this.triggerGameWin();
                } else {
                    GameMineSweeper.this.triggerGameLose();
                }
            }
            GameMineSweeper.this.ticks++;
        }

        public int getDetonationTicks() {
            return this.detonationTicks;
        }

        @Override
        public String getID() {
            return ID;
        }

        @Override
        public NBTTagCompound serialize(SerializationType serializationType) {
            NBTTagCompound nbt = super.serialize(serializationType);
            nbt.func_74768_a("detonation_time", this.detonationTicks);
            return nbt;
        }
    }

    public class StageWaiting
    extends BoardLootGame.BoardStage {
        private static final String ID = "waiting";

        @Override
        protected void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
            if (GameMineSweeper.this.isServerSide()) {
                EntityPlayerMP sPlayer = (EntityPlayerMP)player;
                WorldExt.playSoundServerly(GameMineSweeper.this.getWorld(), GameMineSweeper.this.convertToBlockPos(pos), "note.harp", 0.6f, 0.8f);
                if (!GameMineSweeper.this.board.isGenerated()) {
                    this.generateBoard(sPlayer, pos);
                } else {
                    GameMineSweeper.this.playRevealNeighboursSound = true;
                    if (type == MouseClickType.LEFT) {
                        if (GameMineSweeper.this.board.getMark(pos) == Mark.NO_MARK) {
                            this.revealField(sPlayer, pos);
                        }
                    } else if (player.func_70093_af()) {
                        this.revealAllNeighbours(sPlayer, pos, false);
                    } else if (GameMineSweeper.this.board.isHidden(pos)) {
                        this.swapFieldMark(pos);
                    }
                }
            }
        }

        public void generateBoard(EntityPlayerMP player, Pos2i clickedPos) {
            GameMineSweeper.this.board.generate(clickedPos);
            GameMineSweeper.this.sendUpdatePacketToNearby(new SPMSGenBoard(GameMineSweeper.this));
            this.revealField(player, clickedPos);
            GameMineSweeper.this.save();
        }

        public void revealField(EntityPlayerMP player, Pos2i pos) {
            if (GameMineSweeper.this.board.isHidden(pos)) {
                GameMineSweeper.this.board.reveal(pos);
                Type type = GameMineSweeper.this.board.getType(pos);
                GameMineSweeper.this.sendUpdatePacketToNearby(new SPMSFieldChanged(pos, GameMineSweeper.this.board.getField(pos)));
                if (type == Type.EMPTY) {
                    if (GameMineSweeper.this.playRevealNeighboursSound) {
                        WorldExt.playSoundServerly(GameMineSweeper.this.getWorld(), GameMineSweeper.this.convertToBlockPos(pos), LGSounds.MS_ON_EMPTY_REVEAL_NEIGHBOURS, 0.6f, 1.0f);
                        GameMineSweeper.this.playRevealNeighboursSound = false;
                    }
                    this.revealAllNeighbours(player, pos, true);
                } else if (type == Type.BOMB) {
                    this.triggerBombs(pos);
                }
                GameMineSweeper.this.save();
                if (!GameMineSweeper.this.board.isGenerated()) {
                    return;
                }
                if (GameMineSweeper.this.board.checkWin()) {
                    GameMineSweeper.this.onLevelSuccessfullyFinished();
                }
            }
        }

        private void revealAllNeighbours(EntityPlayerMP player, Pos2i mainPos, boolean revealMarked) {
            if (!revealMarked) {
                if (GameMineSweeper.this.board.isHidden(mainPos)) {
                    GameMineSweeper.this.sendTo((EntityPlayer)player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.ms.reveal_on_hidden", new Object[0]), NotifyColor.WARN);
                    return;
                }
                int bombsAround = GameMineSweeper.this.board.getType(mainPos).getId();
                int marked = 0;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        Pos2i pos = mainPos.add(x, y);
                        if (!GameMineSweeper.this.board.hasFieldOn(pos) || GameMineSweeper.this.board.getMark(pos) != Mark.FLAG) continue;
                        ++marked;
                    }
                }
                if (marked != bombsAround) {
                    GameMineSweeper.this.sendTo((EntityPlayer)player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.ms.reveal_invalid_mark_count", new Object[0]), NotifyColor.WARN);
                    return;
                }
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0) continue;
                    Pos2i pos = mainPos.add(x, y);
                    if (!GameMineSweeper.this.isBoardGenerated() || !GameMineSweeper.this.board.hasFieldOn(pos) || !GameMineSweeper.this.board.isHidden(pos) || !revealMarked && GameMineSweeper.this.board.getMark(pos) == Mark.FLAG) continue;
                    this.revealField(player, pos);
                }
            }
        }

        public void swapFieldMark(Pos2i pos) {
            if (GameMineSweeper.this.board.isHidden(pos)) {
                GameMineSweeper.this.board.swapMark(pos);
                GameMineSweeper.this.sendUpdatePacketToNearby(new SPMSFieldChanged(pos, GameMineSweeper.this.board.getField(pos)));
                GameMineSweeper.this.save();
            }
            if (GameMineSweeper.this.board.checkWin()) {
                GameMineSweeper.this.onLevelSuccessfullyFinished();
            }
        }

        private void triggerBombs(Pos2i pos) {
            WorldExt.playSoundServerly(GameMineSweeper.this.getWorld(), GameMineSweeper.this.convertToBlockPos(pos), LGSounds.MS_BOMB_ACTIVATED, 0.6f, 1.0f);
            GameMineSweeper.this.switchStage(new StageDetonating());
            GameMineSweeper.this.board.forEach((x, y) -> {
                if (GameMineSweeper.this.board.isBomb((int)x, (int)y)) {
                    GameMineSweeper.this.board.reveal((int)x, (int)y);
                }
            });
            GameMineSweeper.this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.ms.bomb_touched", new Object[0]), NotifyColor.FAIL);
            GameMineSweeper.this.saveAndSync();
            GameMineSweeper.this.attemptCount++;
        }

        @Override
        public String getID() {
            return ID;
        }
    }

    public static class Factory
    implements ILootGameFactory {
        @Override
        public void genOnPuzzleMasterClick(World world, BlockPos puzzleMasterPos) {
            BlockPos floorCenterPos = puzzleMasterPos.offset(0, -2, 0);
            WorldExt.setBlock(world, floorCenterPos, LGBlocks.MS_ACTIVATOR);
        }
    }
}

