/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.inventory;

import ic2.api.crops.CropCard;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.inventory.Tuple;

public class CropList {
    List<CropCard> crops = new ArrayList<CropCard>();
    List<ItemStack> cropItems = new ArrayList<ItemStack>();
    int index = 0;

    public void update(IInventory inv) {
        for (int i = 0; i < 9; ++i) {
            int realIndex = this.index + i;
            if (realIndex >= this.crops.size()) {
                inv.func_70299_a(i, null);
                continue;
            }
            inv.func_70299_a(i, this.cropItems.get(realIndex).func_77946_l());
        }
    }

    public void setCropList(List<CropCard> list) {
        this.index = 0;
        this.crops.clear();
        this.cropItems.clear();
        this.crops.addAll(list);
        for (CropCard crop : list) {
            ItemStack stack = CropPluginAPI.instance.getDisplayItem(crop);
            if (stack == null) {
                stack = IC2NeiPlugin.DISPLAY_ITEMS.get(crop);
            }
            this.cropItems.add(stack);
        }
    }

    public void increase(int amount) {
        this.index = Math.max(0, Math.min(this.index + amount, this.crops.size() - 9));
    }

    public void decrease(int amount) {
        this.index -= amount;
        if (this.index < 0) {
            this.index = 0;
        }
    }

    public CropCard getCrop(int offset) {
        return this.crops.get(this.index + offset);
    }

    public void clear() {
        this.index = 0;
        this.crops.clear();
        this.cropItems.clear();
    }

    public List<CropCard> getCrops() {
        return new ArrayList<CropCard>(this.crops);
    }

    public void addAll(List<Tuple<CropCard, ItemStack>> toStore) {
        for (Tuple<CropCard, ItemStack> entry : toStore) {
            this.crops.add(entry.getKey());
            this.cropItems.add(entry.getValue());
        }
    }
}

