/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.cover;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.EnderFluidLinkUIFactory;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import tectech.mechanics.enderStorage.EnderFluidContainer;
import tectech.mechanics.enderStorage.EnderLinkTag;
import tectech.mechanics.enderStorage.EnderWorldSavedData;

public class CoverEnderFluidLink
extends CoverLegacyData {
    private static final int L_PER_TICK = 8000;
    public static final int IMPORT_EXPORT_MASK = 1;
    public static final int PUBLIC_PRIVATE_MASK = 2;

    public CoverEnderFluidLink(CoverContext context) {
        super(context);
    }

    private void transferFluid(IFluidHandler source, ForgeDirection coverSide, IFluidHandler target, ForgeDirection tSide) {
        int drainAmount = 8000 * this.getTickRate();
        FluidStack fluidStack = source.drain(coverSide, drainAmount, false);
        if (fluidStack != null) {
            int fluidTransferred = target.fill(tSide, fluidStack, true);
            source.drain(coverSide, fluidTransferred, true);
        }
    }

    public static boolean testBit(int coverData, int bitMask) {
        return (coverData & bitMask) != 0;
    }

    public static int toggleBit(int coverData, int bitMask) {
        return coverData ^ bitMask;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        IFluidHandler teTank;
        EnderLinkTag tag;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (coverable instanceof IFluidHandler && (tag = EnderWorldSavedData.getEnderLinkTag(teTank = (IFluidHandler)coverable)) != null) {
            boolean isPrivate;
            boolean shouldBePrivate = CoverEnderFluidLink.testBit(this.coverData, 2);
            boolean bl = isPrivate = tag.getUUID() != null;
            if (shouldBePrivate != isPrivate) {
                tag = new EnderLinkTag(tag.getFrequency(), shouldBePrivate ? CoverEnderFluidLink.getOwner(coverable) : null);
                EnderWorldSavedData.bindEnderLinkTag(teTank, tag);
            }
            EnderFluidContainer enderTank = EnderWorldSavedData.getEnderFluidContainer(tag);
            if (CoverEnderFluidLink.testBit(this.coverData, 1)) {
                this.transferFluid(enderTank, ForgeDirection.UNKNOWN, teTank, this.coverSide);
            } else {
                this.transferFluid(teTank, this.coverSide, enderTank, ForgeDirection.UNKNOWN);
            }
        }
    }

    public static UUID getOwner(Object te) {
        if (te instanceof IGregTechTileEntity) {
            IGregTechTileEntity igte = (IGregTechTileEntity)te;
            return igte.getOwnerUuid();
        }
        if (te instanceof TileEntityBase) {
            TileEntityBase teb = (TileEntityBase)te;
            return teb.getOwnerUUID();
        }
        return null;
    }

    @Override
    public void onBaseTEDestroyed() {
        Object t = this.coveredTile.get();
        if (t instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)t;
            EnderWorldSavedData.unbindTank(fluidHandlerSelf);
        }
    }

    @Override
    public void onCoverRemoval() {
        Object t = this.coveredTile.get();
        if (t instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)t;
            EnderWorldSavedData.unbindTank(fluidHandlerSelf);
        }
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = CoverEnderFluidLink.toggleBit(this.coverData, 1);
        if (CoverEnderFluidLink.testBit(this.coverData, 1)) {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Suction Engaged!");
        } else {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Filling Engaged!");
        }
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        if (buildContext.getTile() instanceof IFluidHandler) {
            return new EnderFluidLinkUIFactory(buildContext).createWindow();
        }
        return null;
    }
}

