/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.gui.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.container.ContainerPestKiller;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.tileentities.machines.TileEntityPestKiller;
import gtPlusPlus.core.util.math.MathUtils;
import java.awt.Color;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIPestKiller
extends GuiContainer {
    private static final ResourceLocation craftingTableGuiTextures = new ResourceLocation(Mods.GTPlusPlus.ID, "textures/gui/PestKiller.png");
    private final TileEntityPestKiller mTileKiller;

    public GUIPestKiller(InventoryPlayer player_inventory, TileEntityPestKiller te) {
        super((Container)new ContainerPestKiller(player_inventory, te));
        this.mTileKiller = te;
    }

    protected void func_146979_b(int i, int j) {
        if (this.mTileKiller != null) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)this.mTileKiller.func_145825_b(), (Object[])new Object[0]), 4, 6, 0x404040);
            this.drawFluidTank((IFluidTank)this.mTileKiller.getTank(), 134, 35);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(craftingTableGuiTextures);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    private void drawFluidTank(IFluidTank tank, int x, int y) {
        TileEntityPestKiller aTile;
        Color startGrad = new Color(50, 50, 50);
        Color endGrad = new Color(20, 20, 20);
        ContainerPestKiller aCont = (ContainerPestKiller)this.field_147002_h;
        double aPercentage = 0.0;
        double aDivisor = 6.0;
        int aFrameHeight = 16;
        boolean didRender = false;
        if (aCont != null && (aTile = this.mTileKiller) != null) {
            FluidTank aTank = aTile.getTank();
            int aTier = aTile.getTier();
            this.func_73733_a(x, y, x + 16, y + 16, startGrad.getRGB(), endGrad.getRGB());
            if (aTier <= 0 || aTier > 2) {
                if (aTank != null && aTank.getFluidAmount() > 0) {
                    aPercentage = MathUtils.findPercentage(aTank.getFluidAmount(), aTank.getCapacity());
                }
                this.field_146289_q.func_78276_b("Tier: 0", 4, 18, 0x404040);
                this.field_146289_q.func_78276_b("Range: 1x1", 4, 30, 0x404040);
                this.field_146289_q.func_78276_b("Poison: None", 4, 42, 0x404040);
                this.field_146289_q.func_78276_b("Amount: 0", 4, 64, 0x404040);
                didRender = true;
            } else if (aTier == 1) {
                if (aTank != null && aTank.getFluidAmount() > 0) {
                    aPercentage = MathUtils.findPercentage(aTank.getFluidAmount(), aTank.getCapacity());
                    aFrameHeight = (int)(aPercentage / aDivisor);
                }
                startGrad = new Color(240, 50, 240);
                endGrad = new Color(130, 30, 130);
                this.func_73733_a(x, y + (16 - aFrameHeight), x + 16, y + 16, startGrad.getRGB(), endGrad.getRGB());
                this.field_146289_q.func_78276_b("Tier: 1", 4, 18, 0x404040);
                this.field_146289_q.func_78276_b("Range: 5x5", 4, 30, 0x404040);
                this.field_146289_q.func_78276_b("Poison: ", 4, 42, 0x404040);
                this.field_146289_q.func_78276_b(aTile.getTank().getFluid().getLocalizedName(), 4, 54, 0x404040);
                this.field_146289_q.func_78276_b("Amount: " + aTile.getTank().getFluidAmount(), 4, 64, 0x404040);
                didRender = true;
            } else if (aTier == 2) {
                if (aTank != null && aTank.getFluidAmount() > 0) {
                    aPercentage = MathUtils.findPercentage(aTank.getFluidAmount(), aTank.getCapacity());
                    aFrameHeight = (int)(aPercentage / aDivisor);
                }
                short[] aRGB = MaterialMisc.HYDROGEN_CYANIDE.getRGB();
                startGrad = new Color(aRGB[0], aRGB[1], aRGB[2]);
                endGrad = new Color(Math.max(aRGB[0], 0), Math.max(aRGB[1], 0), Math.max(aRGB[2], 0));
                this.func_73733_a(x, y + (16 - aFrameHeight), x + 16, y + 16, startGrad.getRGB(), endGrad.getRGB());
                this.field_146289_q.func_78276_b("Tier: 2", 4, 18, 0x404040);
                this.field_146289_q.func_78276_b("Range: 9x9", 4, 30, 0x404040);
                this.field_146289_q.func_78276_b("Poison: ", 4, 42, 0x404040);
                this.field_146289_q.func_78276_b(aTile.getTank().getFluid().getLocalizedName(), 4, 54, 0x404040);
                this.field_146289_q.func_78276_b("Amount: " + aTile.getTank().getFluidAmount(), 4, 64, 0x404040);
                didRender = true;
            }
        }
        if (!didRender) {
            startGrad = new Color(255, 30, 120);
            endGrad = new Color(255, 0, 50);
            this.func_73733_a(x, y, x + 16, y + 16, startGrad.getRGB(), endGrad.getRGB());
            this.field_146289_q.func_78276_b("Tier: 0", 4, 18, 0x404040);
        }
    }
}

