/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.api.crafting.ICraftingIconProvider;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MTEHatch
extends MTEBasicTank
implements ICraftingIconProvider {
    private int texturePage = 0;
    private int textureIndex = 0;
    private ItemStack ae2CraftingIcon;

    public MTEHatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTEHatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTEHatch(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public static int getSlots(int aTier) {
        return aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 9 : 16));
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public abstract ITexture[] getTexturesActive(ITexture var1);

    public abstract ITexture[] getTexturesInactive(ITexture var1);

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        try {
            ITexture background = this.texturePage > 0 || this.textureIndex > 0 ? Textures.BlockIcons.casingTexturePages[this.texturePage][this.textureIndex] : Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1];
            if (side != aFacing) {
                return new ITexture[]{background};
            }
            if (aActive) {
                return this.getTexturesActive(background);
            }
            return this.getTexturesInactive(background);
        }
        catch (NullPointerException npe) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[0][0]};
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("texturePage", this.texturePage);
        aNBT.func_74768_a("textureIndex", this.textureIndex);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.texturePage = aNBT.func_74762_e("texturePage");
        this.textureIndex = aNBT.func_74762_e("textureIndex");
        this.updateTexture(this.texturePage << 7 | this.textureIndex);
    }

    public final void updateTexture(int id) {
        int newTexturePage = id >> 7;
        int newTextureIndex = id & 0x7F;
        if (newTexturePage == this.texturePage && newTextureIndex == this.textureIndex) {
            return;
        }
        this.texturePage = newTexturePage;
        this.textureIndex = newTextureIndex;
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (base.isServerSide()) {
            base.issueTileUpdate();
        } else {
            base.issueTextureUpdate();
        }
    }

    @Override
    public NBTTagCompound getDescriptionData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("texturePage", this.texturePage);
        data.func_74768_a("textureIndex", this.textureIndex);
        return data;
    }

    @Override
    public void onDescriptionPacket(NBTTagCompound data) {
        this.texturePage = data.func_74762_e("texturePage");
        this.textureIndex = data.func_74762_e("textureIndex");
    }

    public final void updateCraftingIcon(ItemStack icon) {
        this.ae2CraftingIcon = icon;
    }

    @Override
    public ItemStack getMachineCraftingIcon() {
        return this.ae2CraftingIcon;
    }

    public byte getTierForStructure() {
        return this.mTier;
    }

    public long maxWorkingAmperesIn() {
        return this.maxAmperesIn();
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.CABLE;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    public int getCircuitSlot() {
        return -1;
    }

    public static enum ConnectionType {
        CABLE,
        WIRELESS,
        LASER;

    }
}

