/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import com.google.common.base.Splitter;
import com.gtnewhorizon.structurelib.ChannelDescription;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.gui.GuiScrollableList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.Optional;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiScreenConfigureChannels
extends GuiContainer
implements GuiScrollableList.IGuiScreen,
INEIGuiHandler {
    private static final String I18N_PREFIX = "item.structurelib.constructableTrigger.gui.";
    private static final int ADD_BTN = 0;
    private static final int UNSET_BTN = 1;
    private static final int WIPE_BTN = 2;
    private static final int KEY_MAX_WIDTH = 50;
    private static final int INFO_BOX_SIZE = 11;
    private final ItemStack trigger;
    private final GuiChannelsList list;
    private final GuiAutoCompleteList autoCompleteList;
    private final Map<String, List<String>> tooltipSplitCache = new HashMap<String, List<String>>();
    private final TIntObjectMap<Map<String, String>> trimCache = new TIntObjectHashMap();
    private GuiTextField key;
    private GuiTextField value;
    protected int field_147009_r;
    protected int field_147003_i;
    private List<String> info;

    public GuiScreenConfigureChannels(Container container, ItemStack trigger) {
        super(container);
        this.trigger = trigger;
        this.list = new GuiChannelsList(152, 91, 12, 21, 14);
        this.list.addSelectionListener((list, selectedIndex) -> {
            Map.Entry e = (Map.Entry)list.getElementAt(selectedIndex);
            this.key.func_146180_a((String)e.getKey());
            this.value.func_146180_a(((Integer)e.getValue()).toString());
            this.updateButtons();
        });
        this.autoCompleteList = new GuiAutoCompleteList(116, 50, 45, 131, 14);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_147003_i = (this.field_146294_l - this.getXSize()) / 2;
        this.field_147009_r = (this.field_146295_m - this.getYSize()) / 2;
        this.key = new GuiTextField(this.field_146289_q, this.field_147003_i + 45, this.field_147009_r + 119, 118, 12){

            public void func_146191_b(String text) {
                super.func_146191_b(text.toLowerCase(Locale.ROOT));
                GuiScreenConfigureChannels.this.updateButtons();
            }

            public void func_146192_a(int p_146192_1_, int p_146192_2_, int p_146192_3_) {
                boolean flag;
                super.func_146192_a(p_146192_1_, p_146192_2_, p_146192_3_);
                boolean bl = flag = p_146192_1_ >= this.field_146209_f && p_146192_1_ < this.field_146209_f + this.field_146218_h && p_146192_2_ >= this.field_146210_g && p_146192_2_ < this.field_146210_g + this.field_146219_i;
                if (flag && p_146192_3_ == 1) {
                    GuiScreenConfigureChannels.this.key.func_146180_a("");
                    GuiScreenConfigureChannels.this.value.func_146180_a("");
                }
            }

            public void func_146180_a(String p_146180_1_) {
                super.func_146180_a(p_146180_1_);
                GuiScreenConfigureChannels.this.updateButtons();
            }
        };
        this.value = new GuiTextField(this.field_146289_q, this.field_147003_i + 45, this.field_147009_r + 139, 118, 12){

            public void func_146191_b(String text) {
                if (text != null && text.codePoints().allMatch(Character::isDigit)) {
                    super.func_146191_b(text);
                    GuiScreenConfigureChannels.this.updateButtons();
                }
            }

            public void func_146195_b(boolean p_146195_1_) {
                if (!p_146195_1_ && this.func_146206_l() && !StringUtils.isBlank((CharSequence)this.func_146179_b())) {
                    int result;
                    try {
                        result = Math.max(Integer.parseInt(this.func_146179_b()), 1);
                    }
                    catch (NumberFormatException e) {
                        result = 1;
                    }
                    this.func_146180_a(String.valueOf(result));
                }
                super.func_146195_b(p_146195_1_);
            }

            public void func_146192_a(int p_146192_1_, int p_146192_2_, int p_146192_3_) {
                boolean flag;
                super.func_146192_a(p_146192_1_, p_146192_2_, p_146192_3_);
                boolean bl = flag = p_146192_1_ >= this.field_146209_f && p_146192_1_ < this.field_146209_f + this.field_146218_h && p_146192_2_ >= this.field_146210_g && p_146192_2_ < this.field_146210_g + this.field_146219_i;
                if (flag && p_146192_3_ == 1) {
                    this.func_146180_a("");
                }
            }

            public void func_146180_a(String p_146180_1_) {
                super.func_146180_a(p_146180_1_);
                GuiScreenConfigureChannels.this.updateButtons();
            }
        };
        this.list.onGuiInit(this);
        this.autoCompleteList.onGuiInit(this);
        this.addButton(new GuiButton(0, this.field_147003_i + 12, this.field_147009_r + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.add", (Object[])new Object[0])));
        this.addButton(new GuiButton(1, this.field_147003_i + 65, this.field_147009_r + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.unset", (Object[])new Object[0])));
        this.addButton(new GuiButton(2, this.field_147003_i + 118, this.field_147009_r + 157, 47, 20, I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.wipe", (Object[])new Object[0])));
        this.updateButtons();
        this.tooltipSplitCache.clear();
        this.info = StreamSupport.stream(Splitter.on((String)"\\n").split((CharSequence)StatCollector.func_74838_a((String)"item.structurelib.constructableTrigger.gui.info")).spliterator(), false).flatMap(line -> this.field_146289_q.func_78271_c(line, this.field_146294_l * 1 / 3).stream()).collect(Collectors.toList());
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public int getXSize() {
        return 176;
    }

    @Override
    public int getYSize() {
        return 188;
    }

    @Override
    public void addButton(GuiButton button) {
        this.getButtonList().add(button);
    }

    @Override
    public void removeButton(GuiButton button) {
        this.getButtonList().remove(button);
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    @Override
    public void doActionPerformed(GuiButton but) {
        this.func_146284_a(but);
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    private boolean isMouseOverValue() {
        int mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        return mx >= this.value.field_146209_f && mx < this.value.field_146209_f + this.value.field_146218_h && my >= this.value.field_146210_g && my < this.value.field_146210_g + this.value.field_146219_i;
    }

    public void func_146274_d() {
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            if (this.isMouseOverValue()) {
                if (delta > 0) {
                    this.value.func_146180_a(String.valueOf(this.getValue() + 1));
                } else {
                    this.value.func_146180_a(String.valueOf(Math.max(this.getValue() - 1, 1)));
                }
            } else {
                this.list.handleDWheel(delta);
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mX, int mY, int button) {
        super.func_73864_a(mX, mY, button);
        this.key.func_146192_a(mX, mY, button);
        this.value.func_146192_a(mX, mY, button);
    }

    protected void func_73869_a(char aChar, int aKey) {
        GuiScrollableList l = this.key.func_146206_l() ? this.autoCompleteList : this.list;
        switch (aKey) {
            case 15: {
                if (this.key.func_146206_l()) {
                    this.key.func_146195_b(false);
                    this.value.func_146195_b(true);
                } else {
                    this.key.func_146195_b(true);
                    this.value.func_146195_b(false);
                }
                return;
            }
            case 28: 
            case 156: {
                if (this.key.func_146206_l() && this.autoCompleteList.getSelectedElement() != null) {
                    this.key.func_146180_a((String)this.autoCompleteList.getSelectedElement());
                    this.key.func_146195_b(false);
                    this.value.func_146195_b(true);
                    this.value.func_146180_a("1");
                    this.value.func_146199_i(0);
                    return;
                }
                GuiButton add = this.getButtonList().get(0);
                if (add.field_146124_l) {
                    this.doActionPerformed(add);
                }
                return;
            }
            case 200: {
                if (l.selectedIndex > 0) {
                    l.setSelection(l.selectedIndex - 1);
                }
                return;
            }
            case 208: {
                if (l.selectedIndex < l.getNumElements() - 1) {
                    l.setSelection(l.selectedIndex + 1);
                }
                return;
            }
            case 1: {
                if (!this.key.func_146206_l()) break;
                if (this.autoCompleteList.getSelectedElement() != null) {
                    this.autoCompleteList.reset();
                } else {
                    this.key.func_146195_b(false);
                }
                return;
            }
        }
        if (this.key.func_146201_a(aChar, aKey)) {
            this.updateButtons();
            return;
        }
        if (this.value.func_146201_a(aChar, aKey)) {
            return;
        }
        super.func_73869_a(aChar, aKey);
    }

    private void updateButtons() {
        String keyText = this.key.func_146179_b();
        boolean existing = !StringUtils.isEmpty((CharSequence)keyText) && ChannelDataAccessor.hasSubChannel(this.trigger, keyText);
        this.getButtonList().get((int)0).field_146126_j = existing ? I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.set", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.add", (Object[])new Object[0]);
        this.getButtonList().get((int)0).field_146124_l = !StringUtils.isBlank((CharSequence)this.value.func_146179_b()) && Integer.parseInt(this.value.func_146179_b()) > 0;
        this.getButtonList().get((int)1).field_146124_l = existing && !StringUtils.isBlank((CharSequence)this.value.func_146179_b());
        this.autoCompleteList.reset();
    }

    private int getValue() {
        try {
            return Integer.parseInt(this.value.func_146179_b());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == null) {
            return;
        }
        switch (btn.field_146127_k) {
            case 0: {
                int value = this.getValue();
                if (value <= 0) {
                    return;
                }
                ChannelDataAccessor.setChannelData(this.trigger, this.key.func_146179_b(), value);
                break;
            }
            case 1: {
                ChannelDataAccessor.unsetChannelData(this.trigger, this.key.func_146179_b());
                break;
            }
            case 2: {
                ChannelDataAccessor.wipeChannelData(this.trigger);
                this.key.func_146180_a("");
                this.value.func_146180_a("");
            }
        }
        this.updateButtons();
        super.func_146284_a(btn);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        StructureLib.instance().proxy().uploadChannels(this.trigger);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.key.func_146178_a();
        this.value.func_146178_a();
    }

    public void func_146976_a(float partialTick, int mX, int mY) {
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("structurelib", "textures/gui/channels.png"));
        int topLeftX = (this.field_146294_l - this.getXSize()) / 2;
        int topLeftY = (this.field_146295_m - this.getYSize()) / 2;
        this.func_73729_b(topLeftX, topLeftY, 0, 0, this.getXSize(), this.getYSize());
        this.list.drawScreen(mX, mY, partialTick);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.title", (Object[])new Object[0]), this.field_147003_i + 12, this.field_147009_r + 9, 0);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.key", (Object[])new Object[0]), this.field_147003_i + 12, this.field_147009_r + 122, 0);
        this.key.func_146194_f();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.structurelib.constructableTrigger.gui.value", (Object[])new Object[0]), this.field_147003_i + 12, this.field_147009_r + 142, 0);
        this.value.func_146194_f();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.key.func_146206_l() && this.autoCompleteList.getNumElements() > 0) {
            this.autoCompleteList.drawScreen(mouseX, mouseY, 0.0f);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String highlight = null;
        if (this.key.func_146206_l() && this.autoCompleteList.getNumElements() > 0) {
            highlight = (String)this.autoCompleteList.getSelectedElement();
        }
        if (highlight == null && ChannelDescription.has(this.key.func_146179_b())) {
            highlight = this.key.func_146179_b();
        }
        if (highlight != null) {
            this.drawChannelDescriptionTooltip(highlight);
        }
        if (mouseX > this.field_146999_f + this.field_147003_i - 11 - 12 && mouseX < this.field_146999_f + this.field_147003_i - 12 && mouseY > this.field_147009_r + 7 && mouseY < this.field_147009_r + 11 + 7) {
            this.drawHoveringText(this.info, mouseX, mouseY, this.field_146289_q);
        }
    }

    private void drawChannelDescriptionTooltip(String candidate) {
        List tooltip = this.tooltipSplitCache.computeIfAbsent(candidate, this::getChannelDescriptionTooltip);
        this.drawHoveringText(tooltip, this.field_147003_i + 151 + 12, this.field_147009_r + 122, this.field_146289_q);
    }

    private List<String> getChannelDescriptionTooltip(String candidate) {
        ArrayList<String> tooltip = new ArrayList<String>();
        int maxLine = this.field_146294_l - (this.field_147003_i + 151 + 12) - 12;
        for (Map.Entry<String, String> e : ChannelDescription.get(candidate).getDescriptions().entrySet()) {
            tooltip.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74837_a((String)"item.structurelib.constructableTrigger.gui.channels.from", (Object[])new Object[]{((ModContainer)Loader.instance().getIndexedModList().get(e.getKey())).getName()}), maxLine));
            tooltip.addAll(this.field_146289_q.func_78271_c(StatCollector.func_74838_a((String)e.getValue()), maxLine));
        }
        return tooltip;
    }

    public String trim(String str, int keyMaxWidth) {
        HashMap<String, String> cache = (HashMap<String, String>)this.trimCache.get(keyMaxWidth);
        if (cache == null) {
            cache = new HashMap<String, String>();
            this.trimCache.put(keyMaxWidth, cache);
        }
        return cache.computeIfAbsent(str, e -> {
            String s = this.field_146289_q.func_78269_a(e, keyMaxWidth);
            if (s.length() != e.length()) {
                StringBuilder buffer = new StringBuilder(s).deleteCharAt(s.length() - 1).append("...");
                while ((s = this.field_146289_q.func_78269_a(buffer.toString(), keyMaxWidth)).length() != buffer.length()) {
                    buffer.deleteCharAt(s.length() - 4);
                }
                do {
                    buffer.append('.');
                } while (this.field_146289_q.func_78256_a(buffer.toString()) <= keyMaxWidth);
                s = buffer.deleteCharAt(s.length() - 1).insert(s.length() - 3, EnumChatFormatting.GRAY).toString();
            }
            return s;
        });
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (button != 0 || mousex <= this.field_147003_i || mousey <= this.field_147009_r || mousex >= this.field_147003_i + this.getXSize() || mousey >= this.field_147009_r + this.getYSize()) {
            return false;
        }
        Collection<Map.Entry<String, Integer>> channels = ChannelDescription.iterate(draggedStack);
        switch (channels.size()) {
            case 0: {
                return false;
            }
        }
        Map.Entry<String, Integer> e = channels.iterator().next();
        ChannelDataAccessor.setChannelData(this.trigger, e.getKey(), e.getValue());
        this.key.func_146180_a(e.getKey());
        this.value.func_146180_a(e.getValue().toString());
        draggedStack.field_77994_a = 0;
        return true;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return false;
    }

    private class GuiChannelsList
    extends GuiScrollableList<Map.Entry<String, Integer>> {
        private List<Map.Entry<String, Integer>> cache;

        public GuiChannelsList(int width, int height, int originX, int originY, int slotHeight) {
            super(width, height, originX, originY, slotHeight);
        }

        @Override
        public Map.Entry<String, Integer> getElementAt(int index) {
            return ChannelDataAccessor.iterateChannelData(GuiScreenConfigureChannels.this.trigger).sorted().skip(index).findFirst().orElse(null);
        }

        @Override
        public int getNumElements() {
            return ChannelDataAccessor.countChannelData(GuiScreenConfigureChannels.this.trigger);
        }

        @Override
        protected boolean elementClicked(int elementIndex, boolean doubleClick, int mXRelative, int mYRelative) {
            Object e;
            if (mXRelative >= this.margin + 1 && mXRelative <= this.margin + 5 && mYRelative >= this.margin / 2 + 1 && mYRelative <= this.margin / 2 + 5 && (e = this.getElementAt(elementIndex)) != null) {
                ChannelDataAccessor.unsetChannelData(GuiScreenConfigureChannels.this.trigger, (String)e.getKey());
                GuiScreenConfigureChannels.this.updateButtons();
                return false;
            }
            return super.elementClicked(elementIndex, doubleClick, mXRelative, mYRelative);
        }

        @Override
        protected void prepareDrawElements() {
            this.cache = ChannelDataAccessor.iterateChannelData(GuiScreenConfigureChannels.this.trigger).sorted().collect(Collectors.toList());
        }

        @Override
        protected void drawElement(int elementIndex, int x, int y, int height, Tessellator tessellator, boolean isHovering) {
            if (elementIndex < 0 || elementIndex >= this.cache.size()) {
                return;
            }
            Map.Entry<String, Integer> e = this.cache.get(elementIndex);
            if (e == null) {
                return;
            }
            if (elementIndex > 0) {
                GuiScreenConfigureChannels.this.func_73730_a(this.minX + 1, this.maxX - 1, y - 2, -5592406);
            }
            int keyMaxWidth = 100;
            if (isHovering) {
                GuiScreenConfigureChannels.this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("structurelib", "textures/gui/channels.png"));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiScreenConfigureChannels.this.func_73729_b(x + this.margin + 1, y + this.margin / 2 + 1, 251, 251, 5, 5);
            }
            GuiScreenConfigureChannels.this.field_146289_q.func_78276_b(GuiScreenConfigureChannels.this.trim(e.getKey(), keyMaxWidth - 9), x + this.margin + 8, y + this.margin / 2, 0xFFFFFF);
            int valueX = x + this.margin + keyMaxWidth + this.margin;
            GuiScreenConfigureChannels.this.field_146289_q.func_78276_b(GuiScreenConfigureChannels.this.trim(e.getValue().toString(), this.maxX - valueX), valueX, y + this.margin / 2, 0xFFFFFF);
        }

        @Override
        public void drawScreen(int mX, int mY, float partialTick) {
            super.drawScreen(mX, mY, partialTick);
            GuiScreenConfigureChannels.this.func_73728_b(this.minX + this.margin + this.margin / 2 + 100, this.minY + 1, this.maxY - 1, -5592406);
        }
    }

    private class GuiAutoCompleteList
    extends GuiScrollableList<String> {
        private List<Map.Entry<String, String>> cache;

        public GuiAutoCompleteList(int width, int height, int originX, int originY, int slotHeight) {
            super(width, height, originX, originY, slotHeight);
            this.margin = 2;
        }

        private List<Map.Entry<String, String>> getOptions() {
            if (this.cache == null) {
                this.cache = this.search();
            }
            return this.cache;
        }

        private List<Map.Entry<String, String>> search() {
            ArrayList<Map.Entry<String, String>> cache = new ArrayList<Map.Entry<String, String>>();
            HashSet<Object> added = new HashSet<Object>();
            String term = GuiScreenConfigureChannels.this.key.func_146179_b();
            Object[] subjects = ChannelDescription.getAll().keySet().toArray(new String[0]);
            Arrays.sort(subjects);
            if (StringUtils.isBlank((CharSequence)term)) {
                for (Object subject : subjects) {
                    cache.add(new AbstractMap.SimpleImmutableEntry<Object, String>(subject, EnumChatFormatting.GRAY + (String)subject));
                }
                return cache;
            }
            for (Object s : subjects) {
                if (!((String)s).startsWith(term)) continue;
                cache.add(new AbstractMap.SimpleImmutableEntry<Object, String>(s, term + EnumChatFormatting.GRAY + ((String)s).substring(term.length())));
                added.add(s);
            }
            for (Object subject : subjects) {
                if (added.contains(subject) || ((String)subject).length() <= term.length()) continue;
                int i = 0;
                int j = 0;
                StringBuilder sb = new StringBuilder();
                boolean mode = true;
                sb.append(EnumChatFormatting.WHITE);
                while (i < term.length() && j < ((String)subject).length()) {
                    if (term.codePointAt(i) == ((String)subject).codePointAt(j)) {
                        if (!mode) {
                            sb.append(EnumChatFormatting.WHITE);
                            mode = true;
                        }
                        sb.appendCodePoint(term.codePointAt(i));
                        ++i;
                        ++j;
                        continue;
                    }
                    if (mode) {
                        sb.append(EnumChatFormatting.GRAY);
                        mode = false;
                    }
                    sb.appendCodePoint(((String)subject).codePointAt(j));
                    ++j;
                }
                if (i != term.length()) continue;
                if (j < ((String)subject).length()) {
                    sb.append(EnumChatFormatting.GRAY);
                    sb.append((CharSequence)subject, j, ((String)subject).length());
                }
                cache.add(new AbstractMap.SimpleImmutableEntry<Object, String>(subject, sb.toString()));
                added.add(subject);
            }
            return cache;
        }

        public void reset() {
            this.cache = this.search();
            this.selectedIndex = this.cache.isEmpty() ? -1 : 0;
            this.resetScroll();
        }

        @Override
        public String getElementAt(int index) {
            return index >= 0 && index < this.cache.size() ? this.getOptions().get(index).getKey() : null;
        }

        @Override
        public int getNumElements() {
            return this.getOptions().size();
        }

        @Override
        protected void drawElement(int elementIndex, int x, int y, int height, Tessellator tessellator, boolean isHovering) {
            int color = elementIndex == this.selectedIndex ? 0xFFFFFF : 0xCCCCCC;
            GuiScreenConfigureChannels.this.field_146289_q.func_78276_b(this.getOptions().get(elementIndex).getValue(), x + this.margin, y + this.margin / 2, color);
        }
    }
}

