/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import magicbees.main.utils.LocalizationManager;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public enum MoonPhase {
    FULL("full"),
    WANING_GIBBOUS("gibbousWaning"),
    WANING_HALF("halfWaning"),
    WANING_CRESCENT("crescentWaning"),
    NEW("new"),
    WAXING_CRESCENT("crescentWaxing"),
    WAXING_HALF("halfWaxing"),
    WAXING_GIBBOUS("gibbousWaxing");

    private String phaseName;

    private MoonPhase(String name) {
        this.phaseName = name;
    }

    public boolean isBetween(MoonPhase first, MoonPhase second) {
        boolean flag = false;
        flag = first.ordinal() <= second.ordinal() ? first.ordinal() <= this.ordinal() && this.ordinal() <= second.ordinal() : first.ordinal() <= this.ordinal() && this.ordinal() <= WAXING_GIBBOUS.ordinal() || FULL.ordinal() <= this.ordinal() && this.ordinal() <= second.ordinal();
        return flag;
    }

    public String getLocalizedName() {
        return LocalizationManager.getLocalizedString("moon." + this.phaseName);
    }

    public String getLocalizedNameAlt() {
        if (StatCollector.func_94522_b((String)("moon.alt." + this.phaseName))) {
            return LocalizationManager.getLocalizedString("moon.alt." + this.phaseName);
        }
        return this.getLocalizedName();
    }

    public static MoonPhase getMoonPhase(World w) {
        return MoonPhase.getMoonPhaseFromTime(w.func_72820_D());
    }

    public static MoonPhase getMoonPhaseFromTime(long time) {
        return MoonPhase.values()[(int)((time - 6000L) / 24000L) % 8];
    }
}

