/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api_impl;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.IAppleCoreAccessor;
import squeek.applecore.api.IAppleCoreMutator;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.mixinplugin.ducks.FoodStatsExt;
import squeek.applecore.mixins.early.minecraft.accessors.FoodStatsAccessor;

public enum AppleCoreAccessorMutatorImpl implements IAppleCoreAccessor,
IAppleCoreMutator
{
    INSTANCE;


    private AppleCoreAccessorMutatorImpl() {
        AppleCoreAPI.accessor = this;
        AppleCoreAPI.mutator = this;
    }

    @Override
    public boolean isFood(ItemStack food) {
        return this.isEdible(food) && this.getUnmodifiedFoodValues(food) != null;
    }

    private boolean isEdible(ItemStack food) {
        if (food == null || food.func_77973_b() == null) {
            return false;
        }
        EnumAction useAction = food.func_77973_b().func_77661_b(food);
        if (useAction == EnumAction.eat || useAction == EnumAction.drink) {
            return true;
        }
        return AppleCoreAPI.registry.getEdibleBlockFromItem(food.func_77973_b()) != null;
    }

    @Override
    public FoodValues getUnmodifiedFoodValues(ItemStack food) {
        if (food != null && food.func_77973_b() != null) {
            if (food.func_77973_b() instanceof IEdible) {
                return ((IEdible)food.func_77973_b()).getFoodValues(food);
            }
            if (food.func_77973_b() instanceof ItemFood) {
                return this.getItemFoodValues((ItemFood)food.func_77973_b(), food);
            }
            Block block = AppleCoreAPI.registry.getEdibleBlockFromItem(food.func_77973_b());
            if (block instanceof IEdible) {
                return ((IEdible)block).getFoodValues(food);
            }
        }
        return null;
    }

    private FoodValues getItemFoodValues(ItemFood itemFood, ItemStack itemStack) {
        return new FoodValues(itemFood.func_150905_g(itemStack), itemFood.func_150906_h(itemStack));
    }

    @Override
    public FoodValues getFoodValues(ItemStack food) {
        FoodValues foodValues = this.getUnmodifiedFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetFoodValues event = new FoodEvent.GetFoodValues(food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public FoodValues getFoodValuesForPlayer(ItemStack food, EntityPlayer player) {
        FoodValues foodValues = this.getFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetPlayerFoodValues event = new FoodEvent.GetPlayerFoodValues(player, food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public float getMaxExhaustion(EntityPlayer player) {
        ExhaustionEvent.GetMaxExhaustion event = new ExhaustionEvent.GetMaxExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.maxExhaustionLevel;
    }

    @Override
    public int getHealthRegenTickPeriod(EntityPlayer player) {
        HealthRegenEvent.GetRegenTickPeriod event = new HealthRegenEvent.GetRegenTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.regenTickPeriod;
    }

    @Override
    public int getStarveDamageTickPeriod(EntityPlayer player) {
        StarvationEvent.GetStarveTickPeriod event = new StarvationEvent.GetStarveTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.starveTickPeriod;
    }

    @Override
    public float getExhaustion(EntityPlayer player) {
        return ((FoodStatsAccessor)player.func_71024_bL()).getFoodExhaustionLevel();
    }

    @Override
    public void setExhaustion(EntityPlayer player, float exhaustion) {
        ((FoodStatsAccessor)player.func_71024_bL()).setFoodExhaustionLevel(exhaustion);
    }

    @Override
    public void setHunger(EntityPlayer player, int hunger) {
        ((FoodStatsAccessor)player.func_71024_bL()).setFoodlevel(hunger);
    }

    @Override
    public void setSaturation(EntityPlayer player, float saturation) {
        ((FoodStatsAccessor)player.func_71024_bL()).setFoodSaturationLevel(saturation);
    }

    @Override
    public void setHealthRegenTickCounter(EntityPlayer player, int tickCounter) {
        ((FoodStatsAccessor)player.func_71024_bL()).setFoodTimer(tickCounter);
    }

    @Override
    public void setStarveDamageTickCounter(EntityPlayer player, int tickCounter) {
        ((FoodStatsExt)player.func_71024_bL()).setStarveTimer(tickCounter);
    }
}

