/*
 * Decompiled with CFR 0.152.
 */
package serverutils.pregenerator.filemanager.readwriters;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import serverutils.pregenerator.filemanager.readwriters.FileReadWriter;

public class SafeFileReadWriter
extends FileReadWriter {
    private final Path tempFile;
    private RandomAccessFile randomAccessFileTemp;
    private boolean randomAccessFileTempIsClosed = false;
    private final int iterationsBetweenWrites;
    private int writeIteration = 0;

    public SafeFileReadWriter(Path path, int iterationsBetweenWrites) throws IOException {
        super(path);
        this.iterationsBetweenWrites = iterationsBetweenWrites;
        this.tempFile = Paths.get(path + ".tmp", new String[0]);
        this.randomAccessFileTemp = new RandomAccessFile(this.tempFile.toFile(), "rw");
    }

    public void writeAndCommitIntAfterIterations(int value) throws IOException {
        if (this.writeIteration >= this.iterationsBetweenWrites) {
            this.writeIteration = 0;
            this.writeInt(value);
            this.commit();
        } else {
            ++this.writeIteration;
        }
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (this.randomAccessFileTempIsClosed) {
            this.openForWriting();
        }
        this.randomAccessFileTemp.seek(0L);
        this.randomAccessFileTemp.writeInt(value);
        this.randomAccessFileTemp.getChannel().force(true);
    }

    public void commit() throws IOException {
        this.randomAccessFileTemp.close();
        this.randomAccessFileTempIsClosed = true;
        this.randomAccessFile.close();
        this.randomAccessFileIsClosed = true;
        Files.move(this.tempFile, this.filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        this.openForWriting();
    }

    @Override
    public void clearFile() throws IOException {
        this.randomAccessFile.setLength(0L);
        this.randomAccessFileTemp.setLength(0L);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFileIsClosed = true;
        this.randomAccessFile.close();
        this.randomAccessFileTempIsClosed = true;
        this.randomAccessFileTemp.close();
        Files.deleteIfExists(this.tempFile);
    }

    @Override
    public void openForWriting() throws IOException {
        if (this.randomAccessFileTemp == null || !this.tempFile.toFile().exists() || this.randomAccessFileTempIsClosed) {
            this.randomAccessFileTempIsClosed = false;
            this.randomAccessFileTemp = new RandomAccessFile(this.tempFile.toFile(), "rw");
        }
    }
}

