/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.pluto.world.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomEmptyPluto
extends DungeonRoom {
    private int sizeX;
    private int sizeY;
    private int sizeZ;

    public RoomEmptyPluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(4) + 5;
            this.sizeY = rand.nextInt(2) + 7;
            this.sizeZ = rand.nextInt(4) + 5;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int x = this.posX - 1; x <= this.posX + this.sizeX; ++x) {
            for (int y = this.posY - 1; y <= this.posY + this.sizeY; ++y) {
                for (int z = this.posZ - 1; z <= this.posZ + this.sizeZ; ++z) {
                    if (x == this.posX - 1 || x == this.posX + this.sizeX || y == this.posY - 1 || y == this.posY + this.sizeY || z == this.posZ - 1 || z == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, x, y, z, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, x, y, z, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomEmptyPluto(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
    }
}

