/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.common.util.Util;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.painter.PaintSourceValidator;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class BasicPainterTemplate
implements IMachineRecipe {
    public static int DEFAULT_ENERGY_PER_TASK = Config.painterEnergyPerTaskRF;
    protected final Block[] validTargets;

    protected BasicPainterTemplate(Block ... validTargetBlocks) {
        this.validTargets = validTargetBlocks;
    }

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        return DEFAULT_ENERGY_PER_TASK;
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        return RecipeBonusType.NONE;
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        return this.isValidTarget(this.getTarget(inputs)) && this.isValidPaintSource(this.getPaintSource(inputs));
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        ItemStack target = this.getTarget(inputs);
        ItemStack paintSource = this.getPaintSource(inputs);
        if (target == null || paintSource == null) {
            return null;
        }
        ItemStack result = new ItemStack(this.getResultId(target), 1, target.func_77960_j());
        PainterUtil.setSourceBlock(result, Util.getBlockFromItemId((ItemStack)paintSource), paintSource.func_77960_j());
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
    }

    public ItemStack getTarget(MachineRecipeInput ... inputs) {
        return MachineRecipeInput.getInputForSlot(0, inputs);
    }

    public ItemStack getPaintSource(MachineRecipeInput ... inputs) {
        return MachineRecipeInput.getInputForSlot(1, inputs);
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null) {
            return false;
        }
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return this.isValidPaintSource(input.item);
        }
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPainter.unlocalisedName;
    }

    public boolean isValidPaintSource(ItemStack paintSource) {
        return PaintSourceValidator.instance.isValidSourceDefault(paintSource);
    }

    public boolean isValidTarget(ItemStack target) {
        if (target == null) {
            return false;
        }
        Block blk = Block.func_149634_a((Item)target.func_77973_b());
        if (blk == null) {
            return false;
        }
        for (int i = 0; i < this.validTargets.length; ++i) {
            if (this.validTargets[i] != blk) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUid() {
        return this.getClass().getCanonicalName();
    }

    protected Item getResultId(ItemStack target) {
        return target.func_77973_b();
    }

    public int getQuantityConsumed(MachineRecipeInput input) {
        return input.slotNumber == 0 ? 1 : 0;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        MachineRecipeInput consume = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.slotNumber != 0 || input.item == null) continue;
            ItemStack consumed = input.item.func_77946_l();
            consumed.field_77994_a = 1;
            consume = new MachineRecipeInput(input.slotNumber, consumed);
        }
        if (consume != null) {
            return Collections.singletonList(consume);
        }
        return null;
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        return 0.0f;
    }
}

