/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.blocks.BlockBase;
import eu.usrv.yamcore.blocks.ModSimpleBaseBlock;
import eu.usrv.yamcore.creativetabs.CreativeTabsManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class ModBlockManager {
    public Map<String, ModSimpleBaseBlock> BlockCollection = null;
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private String _mModID;

    public ModBlockManager(String pModID) {
        this.BlockCollection = new HashMap<String, ModSimpleBaseBlock>();
        this._mModID = pModID;
    }

    public BlockBase GetModBlock(ModSimpleBaseBlock pModBlock) {
        return this.GetModBlock(pModBlock.getUnlocItemName());
    }

    public BlockBase GetModBlock(String pModBlockName) {
        if (this.BlockCollection.containsKey(pModBlockName)) {
            return this.BlockCollection.get(pModBlockName).getConstructedBlock();
        }
        return null;
    }

    public boolean AddItemToManagedRegistry(ModSimpleBaseBlock pModBlock) {
        if (this.GetModBlock(pModBlock) == null) {
            this.BlockCollection.put(pModBlock.getUnlocItemName(), pModBlock);
            return true;
        }
        return false;
    }

    public boolean RegisterItems(CreativeTabsManager pTabManager) {
        try {
            for (ModSimpleBaseBlock modBlock : this.BlockCollection.values()) {
                try {
                    CreativeTabs tTargetTab = pTabManager.GetCreativeTabInstance(modBlock.getCreativeTabName());
                    if (tTargetTab == null) {
                        this._mLog.warn(String.format("CreativeTab name %s requested, but not registered in TabManager. Adding Block %s to Tab 'Misc'", modBlock.getCreativeTabName(), modBlock.getConstructedBlock().func_149739_a()));
                        modBlock.setCreativeTab(CreativeTabs.field_78026_f);
                    } else {
                        modBlock.setCreativeTab(tTargetTab);
                    }
                    BlockBase modBlockBlock = modBlock.getConstructedBlock();
                    String unlocName = modBlockBlock.func_149739_a();
                    this._mLog.debug(String.format("Block: %s BlockName: %s", new Object[]{modBlockBlock, unlocName}));
                    GameRegistry.registerBlock((Block)modBlock.getConstructedBlock(), (String)modBlock.getConstructedBlock().func_149739_a());
                }
                catch (Exception e) {
                    this._mLog.error(String.format("Error while registering item %s, skipping", modBlock.getUnlocItemName()));
                    this._mLog.DumpStack(e);
                }
            }
            return true;
        }
        catch (Exception e) {
            this._mLog.error(String.format("Error while registering items", new Object[0]));
            this._mLog.DumpStack(e);
            return false;
        }
    }
}

